/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"type", "outcome", "failure_codes"})
@JsonTypeName(value="ComplianceCheck")
public class ComplianceCheckBankModel {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_OUTCOME = "outcome";
    private String outcome;
    public static final String JSON_PROPERTY_FAILURE_CODES = "failure_codes";
    private JsonNullable<List<String>> failureCodes = JsonNullable.undefined();

    public ComplianceCheckBankModel type(String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The type of compliance check; one of business_watchlists, business_verification, business_tax_id_verification, person_attested, person_tax_id_attested, person_watchlists, person_verification, person_authentication, person_gov_id_verification, person_tax_id_verification, external_bank_account_verification, or external_bank_account_attested.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(String type) {
        this.type = type;
    }

    public ComplianceCheckBankModel outcome(String outcome) {
        this.outcome = outcome;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The outcome of the compliance check; one of passed, failed, or inconclusive.")
    @JsonProperty(value="outcome")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getOutcome() {
        return this.outcome;
    }

    @JsonProperty(value="outcome")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOutcome(String outcome) {
        this.outcome = outcome;
    }

    public ComplianceCheckBankModel failureCodes(List<String> failureCodes) {
        this.failureCodes = JsonNullable.of(failureCodes);
        return this;
    }

    public ComplianceCheckBankModel addFailureCodesItem(String failureCodesItem) {
        if (this.failureCodes == null || !this.failureCodes.isPresent()) {
            this.failureCodes = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.failureCodes.get()).add(failureCodesItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The reason codes explaining the outcome.")
    @JsonIgnore
    public List<String> getFailureCodes() {
        return (List)this.failureCodes.orElse(null);
    }

    @JsonProperty(value="failure_codes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getFailureCodes_JsonNullable() {
        return this.failureCodes;
    }

    @JsonProperty(value="failure_codes")
    public void setFailureCodes_JsonNullable(JsonNullable<List<String>> failureCodes) {
        this.failureCodes = failureCodes;
    }

    public void setFailureCodes(List<String> failureCodes) {
        this.failureCodes = JsonNullable.of(failureCodes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComplianceCheckBankModel complianceCheck = (ComplianceCheckBankModel)o;
        return Objects.equals(this.type, complianceCheck.type) && Objects.equals(this.outcome, complianceCheck.outcome) && ComplianceCheckBankModel.equalsNullable(this.failureCodes, complianceCheck.failureCodes);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.type, this.outcome, ComplianceCheckBankModel.hashCodeNullable(this.failureCodes));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ComplianceCheckBankModel {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    outcome: ").append(this.toIndentedString(this.outcome)).append("\n");
        sb.append("    failureCodes: ").append(this.toIndentedString(this.failureCodes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

