/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.api;

import app.cybrid.cybrid_api_bank.client.ApiClient;
import app.cybrid.cybrid_api_bank.client.model.BankBankModel;
import app.cybrid.cybrid_api_bank.client.model.BankListBankModel;
import app.cybrid.cybrid_api_bank.client.model.PostBankBankModel;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class BanksBankApi {
    private ApiClient apiClient;

    public BanksBankApi() {
        this(new ApiClient());
    }

    @Autowired
    public BanksBankApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createBankRequestCreation(PostBankBankModel postBankBankModel) throws WebClientResponseException {
        PostBankBankModel postBody = postBankBankModel;
        if (postBankBankModel == null) {
            throw new WebClientResponseException("Missing the required parameter 'postBankBankModel' when calling createBank", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<BankBankModel> localVarReturnType = new ParameterizedTypeReference<BankBankModel>(){};
        return this.apiClient.invokeAPI("/api/banks", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BankBankModel> createBank(PostBankBankModel postBankBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<BankBankModel> localVarReturnType = new ParameterizedTypeReference<BankBankModel>(){};
        return this.createBankRequestCreation(postBankBankModel).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BankBankModel>> createBankWithHttpInfo(PostBankBankModel postBankBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<BankBankModel> localVarReturnType = new ParameterizedTypeReference<BankBankModel>(){};
        return this.createBankRequestCreation(postBankBankModel).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec getBankRequestCreation(String bankGuid) throws WebClientResponseException {
        Object postBody = null;
        if (bankGuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'bankGuid' when calling getBank", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("bank_guid", bankGuid);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<BankBankModel> localVarReturnType = new ParameterizedTypeReference<BankBankModel>(){};
        return this.apiClient.invokeAPI("/api/banks/{bank_guid}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BankBankModel> getBank(String bankGuid) throws WebClientResponseException {
        ParameterizedTypeReference<BankBankModel> localVarReturnType = new ParameterizedTypeReference<BankBankModel>(){};
        return this.getBankRequestCreation(bankGuid).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BankBankModel>> getBankWithHttpInfo(String bankGuid) throws WebClientResponseException {
        ParameterizedTypeReference<BankBankModel> localVarReturnType = new ParameterizedTypeReference<BankBankModel>(){};
        return this.getBankRequestCreation(bankGuid).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec listBanksRequestCreation(BigInteger page, BigInteger perPage) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "per_page", perPage));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<BankListBankModel> localVarReturnType = new ParameterizedTypeReference<BankListBankModel>(){};
        return this.apiClient.invokeAPI("/api/banks", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BankListBankModel> listBanks(BigInteger page, BigInteger perPage) throws WebClientResponseException {
        ParameterizedTypeReference<BankListBankModel> localVarReturnType = new ParameterizedTypeReference<BankListBankModel>(){};
        return this.listBanksRequestCreation(page, perPage).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BankListBankModel>> listBanksWithHttpInfo(BigInteger page, BigInteger perPage) throws WebClientResponseException {
        ParameterizedTypeReference<BankListBankModel> localVarReturnType = new ParameterizedTypeReference<BankListBankModel>(){};
        return this.listBanksRequestCreation(page, perPage).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

