/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"type", "guid", "created_at", "exchange_guid", "asset_code"})
@JsonTypeName(value="ExchangeAccount")
public class ExchangeAccountBankModel {
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_GUID = "guid";
    private String guid;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_EXCHANGE_GUID = "exchange_guid";
    private String exchangeGuid;
    public static final String JSON_PROPERTY_ASSET_CODE = "asset_code";
    private String assetCode;

    public ExchangeAccountBankModel type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The exchange account type.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public ExchangeAccountBankModel guid(String guid) {
        this.guid = guid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Auto-generated unique identifier for exchange account.")
    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public ExchangeAccountBankModel createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the exchange account was created at.")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public ExchangeAccountBankModel exchangeGuid(String exchangeGuid) {
        this.exchangeGuid = exchangeGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier of the exchange that owns this exchange account.")
    @JsonProperty(value="exchange_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExchangeGuid() {
        return this.exchangeGuid;
    }

    @JsonProperty(value="exchange_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExchangeGuid(String exchangeGuid) {
        this.exchangeGuid = exchangeGuid;
    }

    public ExchangeAccountBankModel assetCode(String assetCode) {
        this.assetCode = assetCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The asset code of the exchange account.")
    @JsonProperty(value="asset_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAssetCode() {
        return this.assetCode;
    }

    @JsonProperty(value="asset_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAssetCode(String assetCode) {
        this.assetCode = assetCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExchangeAccountBankModel exchangeAccount = (ExchangeAccountBankModel)o;
        return Objects.equals((Object)this.type, (Object)exchangeAccount.type) && Objects.equals(this.guid, exchangeAccount.guid) && Objects.equals(this.createdAt, exchangeAccount.createdAt) && Objects.equals(this.exchangeGuid, exchangeAccount.exchangeGuid) && Objects.equals(this.assetCode, exchangeAccount.assetCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.guid, this.createdAt, this.exchangeGuid, this.assetCode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExchangeAccountBankModel {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    exchangeGuid: ").append(this.toIndentedString(this.exchangeGuid)).append("\n");
        sb.append("    assetCode: ").append(this.toIndentedString(this.assetCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        FIAT("fiat"),
        CRYPTO("crypto");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

