/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.api;

import app.cybrid.cybrid_api_bank.client.ApiClient;
import app.cybrid.cybrid_api_bank.client.model.IdentityRecordBankModel;
import app.cybrid.cybrid_api_bank.client.model.PostIdentityRecordBankModel;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class IdentityRecordsBankApi {
    private ApiClient apiClient;

    public IdentityRecordsBankApi() {
        this(new ApiClient());
    }

    @Autowired
    public IdentityRecordsBankApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createIdentityRecordRequestCreation(PostIdentityRecordBankModel postIdentityRecordBankModel) throws WebClientResponseException {
        PostIdentityRecordBankModel postBody = postIdentityRecordBankModel;
        if (postIdentityRecordBankModel == null) {
            throw new WebClientResponseException("Missing the required parameter 'postIdentityRecordBankModel' when calling createIdentityRecord", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<IdentityRecordBankModel> localVarReturnType = new ParameterizedTypeReference<IdentityRecordBankModel>(){};
        return this.apiClient.invokeAPI("/api/identity_records", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<IdentityRecordBankModel> createIdentityRecord(PostIdentityRecordBankModel postIdentityRecordBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<IdentityRecordBankModel> localVarReturnType = new ParameterizedTypeReference<IdentityRecordBankModel>(){};
        return this.createIdentityRecordRequestCreation(postIdentityRecordBankModel).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<IdentityRecordBankModel>> createIdentityRecordWithHttpInfo(PostIdentityRecordBankModel postIdentityRecordBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<IdentityRecordBankModel> localVarReturnType = new ParameterizedTypeReference<IdentityRecordBankModel>(){};
        return this.createIdentityRecordRequestCreation(postIdentityRecordBankModel).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec getIdentityRecordRequestCreation(String identityRecordGuid) throws WebClientResponseException {
        Object postBody = null;
        if (identityRecordGuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'identityRecordGuid' when calling getIdentityRecord", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("identity_record_guid", identityRecordGuid);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<IdentityRecordBankModel> localVarReturnType = new ParameterizedTypeReference<IdentityRecordBankModel>(){};
        return this.apiClient.invokeAPI("/api/identity_records/{identity_record_guid}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<IdentityRecordBankModel> getIdentityRecord(String identityRecordGuid) throws WebClientResponseException {
        ParameterizedTypeReference<IdentityRecordBankModel> localVarReturnType = new ParameterizedTypeReference<IdentityRecordBankModel>(){};
        return this.getIdentityRecordRequestCreation(identityRecordGuid).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<IdentityRecordBankModel>> getIdentityRecordWithHttpInfo(String identityRecordGuid) throws WebClientResponseException {
        ParameterizedTypeReference<IdentityRecordBankModel> localVarReturnType = new ParameterizedTypeReference<IdentityRecordBankModel>(){};
        return this.getIdentityRecordRequestCreation(identityRecordGuid).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

