/*
 * Cybrid Bank API
 * # Welcome  Welcome to the Cybrid platform; enabling turnkey crypto banking services!  In these documents, you will find information on the operations provided by our platform, as well as details on how our REST API operates more generally.  Our complete set of APIs allows you to manage all your resources: your Organization, your banks and your identities. The complete set of APIs can be found on the following pages:  | API                                                            | Description                  | |----------------------------------------------------------------|------------------------------| | [Organization API](https://organization.demo.cybrid.app/api/schema/swagger-ui) | APIs to manage organizations | | [Bank API](https://bank.demo.cybrid.app/api/schema/swagger-ui)                 | APIs to manage banks         | | [Identities API](https://id.demo.cybrid.app/api/schema/swagger-ui)                     | APIs to manage identities    |  When you're ready, [request access](https://www.cybrid.xyz/access) to your Dashboard to view and administer your Organization. Once you've logged in, you can begin creating Banks, either for sandbox or production usage, and start enabling your customers to leverage DeFi and web3 with confidence.  If you have any questions, please contact [Support](mailto:support@cybrid.app) at any time so that we can help.  ## Authentication  The Cybrid Platform uses OAuth 2.0 Bearer Tokens to authenticate requests to the platform. Credentials to create Organization and Bank tokens can be generated via your Dashboard ([request access](https://www.cybrid.xyz/access)).  An Organization Token applies broadly to the whole Organization and all of its Banks, whereas, a Bank Token is specific to an individual Bank.  Both Organization and Bank tokens can be created using the OAuth Client Credential Grant flow. Each Organization and Bank has its own unique Client ID and Secret that allows for machine-to-machine authentication.  **Never share your Client ID or Secret publicly or in your source code repository**  Your Client ID and Secret can be exchanged for a time-limited Bearer Token by interacting with the Cybrid Identity Provider or through interacting with the **Authorize** button in this document:  ``` curl -X POST https://id.demo.cybrid.app/oauth/token -d '{     \"grant_type\": \"client_credentials\",     \"client_id\": \"<Your Client ID>\",     \"client_secret\": \"<Your Secret>\",     \"scope\": \"<Your requested scopes -- space separated>\"   }' -H \"Content-Type: application/json\" ```  ## Scopes  The Cybrid platform supports the use of scopes to control the level of access a token is limited to. Scopes do not grant access to resources; instead, they provide limits, in support of the least privilege principal.  The following scopes are available on the platform and can be requested when generating either an Organization or a Bank token. Generally speaking, the _Read_ scope is required to read and list resources, the _Write_ scope is required to update a resource and the _Execute_ scope is required to create a resource.  | Resource      | Read scope         | Write scope          | Execute scope     | Token Type         | |---------------|--------------------|----------------------|-------------------|--------------------| | Organizations | organizations:read | organizations:write  |                   | Organization/ Bank | | Banks         | banks:read         | banks:write          | banks:execute     | Organization/ Bank | | Customers     | customers:read     | customers:write      | customers:execute | Bank               | | Assets        | prices:read        |                      |                   | Bank               | | Accounts      | accounts:read      |                      | accounts:execute  | Bank               | | Prices        | prices:read        |                      |                   | Bank               | | Symbols       | prices:read        |                      |                   | Bank               | | Quotes        | quotes:read        |                      | quotes:execute    | Bank               | | Trades        | trades:read        |                      | trades:execute    | Bank               |  ## Organizations  An Organization is meant to model the organization partnering with Cybrid to use our platform.  An Organization does not directly interact with customers. Instead, an Organization has one or more banks, which encompass the financial service offerings of the platform.  ## Banks  A Bank is owned by an Organization and can be thought of as an environment or container for Customers and product offerings. An example of a Bank would be your customer facing banking website, or an internal staging environment for testing and integration.  An Organization can have multiple banks, in sandbox or production environments. A sandbox Bank will be backed by stubbed data and process flows. For instance, identity record and funding source processes will be simulated rather than performed.  ## Customers  Customers represent your banking users on the platform. At present, we offer support for Individuals as Customers.  Customers must be verified in our system before they can play any part on the platform. See the Identity Records section for more details on how a customer can be verified.  Customers must also have an account to be able to transact. See the Accounts APIs for more details on setting up accounts for the customer. 
 *
 * The version of the OpenAPI document: v0.30.56
 * Contact: support@cybrid.app
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package app.cybrid.cybrid_api_bank.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * ExchangeSettlementPaymentOrderBankModel
 */
@JsonPropertyOrder({
  ExchangeSettlementPaymentOrderBankModel.JSON_PROPERTY_GUID,
  ExchangeSettlementPaymentOrderBankModel.JSON_PROPERTY_EXCHANGE_SETTLEMENT_OBLIGATION_GUID,
  ExchangeSettlementPaymentOrderBankModel.JSON_PROPERTY_SEQUENCE_NUMBER,
  ExchangeSettlementPaymentOrderBankModel.JSON_PROPERTY_PAYMENT_AMOUNT,
  ExchangeSettlementPaymentOrderBankModel.JSON_PROPERTY_INTERNAL_ACCOUNT_GUID,
  ExchangeSettlementPaymentOrderBankModel.JSON_PROPERTY_INTERNAL_ACCOUNT_TYPE,
  ExchangeSettlementPaymentOrderBankModel.JSON_PROPERTY_EXTERNAL_ACCOUNT_GUID,
  ExchangeSettlementPaymentOrderBankModel.JSON_PROPERTY_EXTERNAL_ACCOUNT_TYPE,
  ExchangeSettlementPaymentOrderBankModel.JSON_PROPERTY_STATE,
  ExchangeSettlementPaymentOrderBankModel.JSON_PROPERTY_CREATED_AT
})
@JsonTypeName("ExchangeSettlementPaymentOrder")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-07-06T12:38:23.239219Z[Etc/UTC]")
public class ExchangeSettlementPaymentOrderBankModel {
  public static final String JSON_PROPERTY_GUID = "guid";
  private String guid;

  public static final String JSON_PROPERTY_EXCHANGE_SETTLEMENT_OBLIGATION_GUID = "exchange_settlement_obligation_guid";
  private String exchangeSettlementObligationGuid;

  public static final String JSON_PROPERTY_SEQUENCE_NUMBER = "sequence_number";
  private java.math.BigInteger sequenceNumber;

  public static final String JSON_PROPERTY_PAYMENT_AMOUNT = "payment_amount";
  private java.math.BigInteger paymentAmount;

  public static final String JSON_PROPERTY_INTERNAL_ACCOUNT_GUID = "internal_account_guid";
  private String internalAccountGuid;

  /**
   * The type of the internal account that is expected to originate the payment.
   */
  public enum InternalAccountTypeEnum {
    WALLET("internal_wallet"),
    
    BANK_ACCOUNT("internal_bank_account");

    private String value;

    InternalAccountTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static InternalAccountTypeEnum fromValue(String value) {
      for (InternalAccountTypeEnum b : InternalAccountTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_INTERNAL_ACCOUNT_TYPE = "internal_account_type";
  private InternalAccountTypeEnum internalAccountType;

  public static final String JSON_PROPERTY_EXTERNAL_ACCOUNT_GUID = "external_account_guid";
  private String externalAccountGuid;

  /**
   * The type of the external account that is expected to receive the payment.
   */
  public enum ExternalAccountTypeEnum {
    WALLET("external_wallet"),
    
    BANK_ACCOUNT("external_bank_account");

    private String value;

    ExternalAccountTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ExternalAccountTypeEnum fromValue(String value) {
      for (ExternalAccountTypeEnum b : ExternalAccountTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_EXTERNAL_ACCOUNT_TYPE = "external_account_type";
  private ExternalAccountTypeEnum externalAccountType;

  /**
   * The exchange settlement payment order&#39;s state
   */
  public enum StateEnum {
    STORING("storing"),
    
    PENDING__CREATED("pending__created"),
    
    PENDING__PRINCIPAL_RESERVED("pending__principal_reserved"),
    
    PENDING__TRANSACTIONS_CLAIMED("pending__transactions_claimed"),
    
    NOT_APPROVED("not_approved"),
    
    IN_PROGRESS("in_progress"),
    
    NOT_OWING("not_owing"),
    
    AMOUNT_INCORRECT("amount_incorrect"),
    
    INVALID_PRINCIPAL("invalid_principal"),
    
    NSF("nsf"),
    
    SENT("sent"),
    
    REJECTED("rejected");

    private String value;

    StateEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StateEnum fromValue(String value) {
      for (StateEnum b : StateEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATE = "state";
  private StateEnum state;

  public static final String JSON_PROPERTY_CREATED_AT = "created_at";
  private OffsetDateTime createdAt;

  public ExchangeSettlementPaymentOrderBankModel() { 
  }

  public ExchangeSettlementPaymentOrderBankModel guid(String guid) {
    
    this.guid = guid;
    return this;
  }

   /**
   * Auto-generated unique identifier for the exchange settlement payment order.
   * @return guid
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Auto-generated unique identifier for the exchange settlement payment order.")
  @JsonProperty(JSON_PROPERTY_GUID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getGuid() {
    return guid;
  }


  @JsonProperty(JSON_PROPERTY_GUID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGuid(String guid) {
    this.guid = guid;
  }


  public ExchangeSettlementPaymentOrderBankModel exchangeSettlementObligationGuid(String exchangeSettlementObligationGuid) {
    
    this.exchangeSettlementObligationGuid = exchangeSettlementObligationGuid;
    return this;
  }

   /**
   * The identifier of the exchange settlement obligation that this payment is associated with.
   * @return exchangeSettlementObligationGuid
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The identifier of the exchange settlement obligation that this payment is associated with.")
  @JsonProperty(JSON_PROPERTY_EXCHANGE_SETTLEMENT_OBLIGATION_GUID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExchangeSettlementObligationGuid() {
    return exchangeSettlementObligationGuid;
  }


  @JsonProperty(JSON_PROPERTY_EXCHANGE_SETTLEMENT_OBLIGATION_GUID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExchangeSettlementObligationGuid(String exchangeSettlementObligationGuid) {
    this.exchangeSettlementObligationGuid = exchangeSettlementObligationGuid;
  }


  public ExchangeSettlementPaymentOrderBankModel sequenceNumber(java.math.BigInteger sequenceNumber) {
    
    this.sequenceNumber = sequenceNumber;
    return this;
  }

   /**
   * The sequence number of the payment order
   * @return sequenceNumber
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The sequence number of the payment order")
  @JsonProperty(JSON_PROPERTY_SEQUENCE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.math.BigInteger getSequenceNumber() {
    return sequenceNumber;
  }


  @JsonProperty(JSON_PROPERTY_SEQUENCE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSequenceNumber(java.math.BigInteger sequenceNumber) {
    this.sequenceNumber = sequenceNumber;
  }


  public ExchangeSettlementPaymentOrderBankModel paymentAmount(java.math.BigInteger paymentAmount) {
    
    this.paymentAmount = paymentAmount;
    return this;
  }

   /**
   * The amount expected to be received as part of this payment.
   * @return paymentAmount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The amount expected to be received as part of this payment.")
  @JsonProperty(JSON_PROPERTY_PAYMENT_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.math.BigInteger getPaymentAmount() {
    return paymentAmount;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentAmount(java.math.BigInteger paymentAmount) {
    this.paymentAmount = paymentAmount;
  }


  public ExchangeSettlementPaymentOrderBankModel internalAccountGuid(String internalAccountGuid) {
    
    this.internalAccountGuid = internalAccountGuid;
    return this;
  }

   /**
   * The identifier of the internal account that is expected to originate the payment.
   * @return internalAccountGuid
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The identifier of the internal account that is expected to originate the payment.")
  @JsonProperty(JSON_PROPERTY_INTERNAL_ACCOUNT_GUID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getInternalAccountGuid() {
    return internalAccountGuid;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_ACCOUNT_GUID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalAccountGuid(String internalAccountGuid) {
    this.internalAccountGuid = internalAccountGuid;
  }


  public ExchangeSettlementPaymentOrderBankModel internalAccountType(InternalAccountTypeEnum internalAccountType) {
    
    this.internalAccountType = internalAccountType;
    return this;
  }

   /**
   * The type of the internal account that is expected to originate the payment.
   * @return internalAccountType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The type of the internal account that is expected to originate the payment.")
  @JsonProperty(JSON_PROPERTY_INTERNAL_ACCOUNT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public InternalAccountTypeEnum getInternalAccountType() {
    return internalAccountType;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_ACCOUNT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalAccountType(InternalAccountTypeEnum internalAccountType) {
    this.internalAccountType = internalAccountType;
  }


  public ExchangeSettlementPaymentOrderBankModel externalAccountGuid(String externalAccountGuid) {
    
    this.externalAccountGuid = externalAccountGuid;
    return this;
  }

   /**
   * The identifier of the external account that is expected to receive the payment.
   * @return externalAccountGuid
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The identifier of the external account that is expected to receive the payment.")
  @JsonProperty(JSON_PROPERTY_EXTERNAL_ACCOUNT_GUID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalAccountGuid() {
    return externalAccountGuid;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_ACCOUNT_GUID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalAccountGuid(String externalAccountGuid) {
    this.externalAccountGuid = externalAccountGuid;
  }


  public ExchangeSettlementPaymentOrderBankModel externalAccountType(ExternalAccountTypeEnum externalAccountType) {
    
    this.externalAccountType = externalAccountType;
    return this;
  }

   /**
   * The type of the external account that is expected to receive the payment.
   * @return externalAccountType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The type of the external account that is expected to receive the payment.")
  @JsonProperty(JSON_PROPERTY_EXTERNAL_ACCOUNT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ExternalAccountTypeEnum getExternalAccountType() {
    return externalAccountType;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_ACCOUNT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalAccountType(ExternalAccountTypeEnum externalAccountType) {
    this.externalAccountType = externalAccountType;
  }


  public ExchangeSettlementPaymentOrderBankModel state(StateEnum state) {
    
    this.state = state;
    return this;
  }

   /**
   * The exchange settlement payment order&#39;s state
   * @return state
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The exchange settlement payment order's state")
  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StateEnum getState() {
    return state;
  }


  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(StateEnum state) {
    this.state = state;
  }


  public ExchangeSettlementPaymentOrderBankModel createdAt(OffsetDateTime createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

   /**
   * ISO8601 datetime the exchange settlement payment order was created at.
   * @return createdAt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "ISO8601 datetime the exchange settlement payment order was created at.")
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExchangeSettlementPaymentOrderBankModel exchangeSettlementPaymentOrder = (ExchangeSettlementPaymentOrderBankModel) o;
    return Objects.equals(this.guid, exchangeSettlementPaymentOrder.guid) &&
        Objects.equals(this.exchangeSettlementObligationGuid, exchangeSettlementPaymentOrder.exchangeSettlementObligationGuid) &&
        Objects.equals(this.sequenceNumber, exchangeSettlementPaymentOrder.sequenceNumber) &&
        Objects.equals(this.paymentAmount, exchangeSettlementPaymentOrder.paymentAmount) &&
        Objects.equals(this.internalAccountGuid, exchangeSettlementPaymentOrder.internalAccountGuid) &&
        Objects.equals(this.internalAccountType, exchangeSettlementPaymentOrder.internalAccountType) &&
        Objects.equals(this.externalAccountGuid, exchangeSettlementPaymentOrder.externalAccountGuid) &&
        Objects.equals(this.externalAccountType, exchangeSettlementPaymentOrder.externalAccountType) &&
        Objects.equals(this.state, exchangeSettlementPaymentOrder.state) &&
        Objects.equals(this.createdAt, exchangeSettlementPaymentOrder.createdAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(guid, exchangeSettlementObligationGuid, sequenceNumber, paymentAmount, internalAccountGuid, internalAccountType, externalAccountGuid, externalAccountType, state, createdAt);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ExchangeSettlementPaymentOrderBankModel {\n");
    sb.append("    guid: ").append(toIndentedString(guid)).append("\n");
    sb.append("    exchangeSettlementObligationGuid: ").append(toIndentedString(exchangeSettlementObligationGuid)).append("\n");
    sb.append("    sequenceNumber: ").append(toIndentedString(sequenceNumber)).append("\n");
    sb.append("    paymentAmount: ").append(toIndentedString(paymentAmount)).append("\n");
    sb.append("    internalAccountGuid: ").append(toIndentedString(internalAccountGuid)).append("\n");
    sb.append("    internalAccountType: ").append(toIndentedString(internalAccountType)).append("\n");
    sb.append("    externalAccountGuid: ").append(toIndentedString(externalAccountGuid)).append("\n");
    sb.append("    externalAccountType: ").append(toIndentedString(externalAccountType)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

