/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonPropertyOrder(value={"name", "type", "supported_fiat_assets", "features"})
@JsonTypeName(value="PostBank")
public class PostBankBankModel {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_SUPPORTED_FIAT_ASSETS = "supported_fiat_assets";
    private List<String> supportedFiatAssets = new ArrayList<String>();
    public static final String JSON_PROPERTY_FEATURES = "features";
    private List<FeaturesEnum> features = new ArrayList<FeaturesEnum>();

    public PostBankBankModel name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The bank's name.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public PostBankBankModel type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The bank's type. At present, only **sandbox** is supported.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public PostBankBankModel supportedFiatAssets(List<String> supportedFiatAssets) {
        this.supportedFiatAssets = supportedFiatAssets;
        return this;
    }

    public PostBankBankModel addSupportedFiatAssetsItem(String supportedFiatAssetsItem) {
        this.supportedFiatAssets.add(supportedFiatAssetsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The bank's list of supported fiat assets.")
    @JsonProperty(value="supported_fiat_assets")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getSupportedFiatAssets() {
        return this.supportedFiatAssets;
    }

    @JsonProperty(value="supported_fiat_assets")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupportedFiatAssets(List<String> supportedFiatAssets) {
        this.supportedFiatAssets = supportedFiatAssets;
    }

    public PostBankBankModel features(List<FeaturesEnum> features) {
        this.features = features;
        return this;
    }

    public PostBankBankModel addFeaturesItem(FeaturesEnum featuresItem) {
        this.features.add(featuresItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The bank's enabled features. At present, both **attestation_identity_records** and **backstopped_funding_source** must be set.")
    @JsonProperty(value="features")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<FeaturesEnum> getFeatures() {
        return this.features;
    }

    @JsonProperty(value="features")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFeatures(List<FeaturesEnum> features) {
        this.features = features;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostBankBankModel postBank = (PostBankBankModel)o;
        return Objects.equals(this.name, postBank.name) && Objects.equals((Object)this.type, (Object)postBank.type) && Objects.equals(this.supportedFiatAssets, postBank.supportedFiatAssets) && Objects.equals(this.features, postBank.features);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.supportedFiatAssets, this.features});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostBankBankModel {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    supportedFiatAssets: ").append(this.toIndentedString(this.supportedFiatAssets)).append("\n");
        sb.append("    features: ").append(this.toIndentedString(this.features)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FeaturesEnum {
        ATTESTATION_IDENTITY_RECORDS("attestation_identity_records"),
        BACKSTOPPED_FUNDING_SOURCE("backstopped_funding_source");

        private String value;

        private FeaturesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FeaturesEnum fromValue(String value) {
            for (FeaturesEnum b : FeaturesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        SANDBOX("sandbox"),
        PRODUCTION("production");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

