/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"guid", "exchange_guid", "name", "trade_guids", "exchange_settlement_obligation_guids", "state", "created_at"})
@JsonTypeName(value="ExchangeSettlement")
public class ExchangeSettlementBankModel {
    public static final String JSON_PROPERTY_GUID = "guid";
    private String guid;
    public static final String JSON_PROPERTY_EXCHANGE_GUID = "exchange_guid";
    private String exchangeGuid;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_TRADE_GUIDS = "trade_guids";
    private List<String> tradeGuids = null;
    public static final String JSON_PROPERTY_EXCHANGE_SETTLEMENT_OBLIGATION_GUIDS = "exchange_settlement_obligation_guids";
    private List<String> exchangeSettlementObligationGuids = null;
    public static final String JSON_PROPERTY_STATE = "state";
    private StateEnum state;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;

    public ExchangeSettlementBankModel guid(String guid) {
        this.guid = guid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Auto-generated unique identifier for the exchange settlement.")
    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public ExchangeSettlementBankModel exchangeGuid(String exchangeGuid) {
        this.exchangeGuid = exchangeGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier of the exchange that corresponds to this settlement.")
    @JsonProperty(value="exchange_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExchangeGuid() {
        return this.exchangeGuid;
    }

    @JsonProperty(value="exchange_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExchangeGuid(String exchangeGuid) {
        this.exchangeGuid = exchangeGuid;
    }

    public ExchangeSettlementBankModel name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the exchange settlement.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public ExchangeSettlementBankModel tradeGuids(List<String> tradeGuids) {
        this.tradeGuids = tradeGuids;
        return this;
    }

    public ExchangeSettlementBankModel addTradeGuidsItem(String tradeGuidsItem) {
        if (this.tradeGuids == null) {
            this.tradeGuids = new ArrayList<String>();
        }
        this.tradeGuids.add(tradeGuidsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The exchange settlement's set of included trade guids.")
    @JsonProperty(value="trade_guids")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTradeGuids() {
        return this.tradeGuids;
    }

    @JsonProperty(value="trade_guids")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTradeGuids(List<String> tradeGuids) {
        this.tradeGuids = tradeGuids;
    }

    public ExchangeSettlementBankModel exchangeSettlementObligationGuids(List<String> exchangeSettlementObligationGuids) {
        this.exchangeSettlementObligationGuids = exchangeSettlementObligationGuids;
        return this;
    }

    public ExchangeSettlementBankModel addExchangeSettlementObligationGuidsItem(String exchangeSettlementObligationGuidsItem) {
        if (this.exchangeSettlementObligationGuids == null) {
            this.exchangeSettlementObligationGuids = new ArrayList<String>();
        }
        this.exchangeSettlementObligationGuids.add(exchangeSettlementObligationGuidsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The exchange settlement's set of obligation guids.")
    @JsonProperty(value="exchange_settlement_obligation_guids")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getExchangeSettlementObligationGuids() {
        return this.exchangeSettlementObligationGuids;
    }

    @JsonProperty(value="exchange_settlement_obligation_guids")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExchangeSettlementObligationGuids(List<String> exchangeSettlementObligationGuids) {
        this.exchangeSettlementObligationGuids = exchangeSettlementObligationGuids;
    }

    public ExchangeSettlementBankModel state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The exchange settlement's state")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StateEnum getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(StateEnum state) {
        this.state = state;
    }

    public ExchangeSettlementBankModel createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the exchange settlement was created at.")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExchangeSettlementBankModel exchangeSettlement = (ExchangeSettlementBankModel)o;
        return Objects.equals(this.guid, exchangeSettlement.guid) && Objects.equals(this.exchangeGuid, exchangeSettlement.exchangeGuid) && Objects.equals(this.name, exchangeSettlement.name) && Objects.equals(this.tradeGuids, exchangeSettlement.tradeGuids) && Objects.equals(this.exchangeSettlementObligationGuids, exchangeSettlement.exchangeSettlementObligationGuids) && Objects.equals((Object)this.state, (Object)exchangeSettlement.state) && Objects.equals(this.createdAt, exchangeSettlement.createdAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.guid, this.exchangeGuid, this.name, this.tradeGuids, this.exchangeSettlementObligationGuids, this.state, this.createdAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExchangeSettlementBankModel {\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    exchangeGuid: ").append(this.toIndentedString(this.exchangeGuid)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    tradeGuids: ").append(this.toIndentedString(this.tradeGuids)).append("\n");
        sb.append("    exchangeSettlementObligationGuids: ").append(this.toIndentedString(this.exchangeSettlementObligationGuids)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        STORING("storing"),
        PENDING__CREATED("pending__created"),
        PENDING__APPROVED("pending__approved"),
        FAILED_CREATION("failed_creation"),
        TRADES_COMPLETED("trades_completed");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

