/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"guid", "exchange_settlement_obligation_guid", "sequence_number", "payment_amount", "internal_account_guid", "internal_account_type", "external_account_guid", "external_account_type", "state", "created_at"})
@JsonTypeName(value="ExchangeSettlementPaymentOrder")
public class ExchangeSettlementPaymentOrderBankModel {
    public static final String JSON_PROPERTY_GUID = "guid";
    private String guid;
    public static final String JSON_PROPERTY_EXCHANGE_SETTLEMENT_OBLIGATION_GUID = "exchange_settlement_obligation_guid";
    private String exchangeSettlementObligationGuid;
    public static final String JSON_PROPERTY_SEQUENCE_NUMBER = "sequence_number";
    private BigInteger sequenceNumber;
    public static final String JSON_PROPERTY_PAYMENT_AMOUNT = "payment_amount";
    private BigInteger paymentAmount;
    public static final String JSON_PROPERTY_INTERNAL_ACCOUNT_GUID = "internal_account_guid";
    private String internalAccountGuid;
    public static final String JSON_PROPERTY_INTERNAL_ACCOUNT_TYPE = "internal_account_type";
    private InternalAccountTypeEnum internalAccountType;
    public static final String JSON_PROPERTY_EXTERNAL_ACCOUNT_GUID = "external_account_guid";
    private String externalAccountGuid;
    public static final String JSON_PROPERTY_EXTERNAL_ACCOUNT_TYPE = "external_account_type";
    private ExternalAccountTypeEnum externalAccountType;
    public static final String JSON_PROPERTY_STATE = "state";
    private StateEnum state;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;

    public ExchangeSettlementPaymentOrderBankModel guid(String guid) {
        this.guid = guid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Auto-generated unique identifier for the exchange settlement payment order.")
    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public ExchangeSettlementPaymentOrderBankModel exchangeSettlementObligationGuid(String exchangeSettlementObligationGuid) {
        this.exchangeSettlementObligationGuid = exchangeSettlementObligationGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier of the exchange settlement obligation that this payment is associated with.")
    @JsonProperty(value="exchange_settlement_obligation_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExchangeSettlementObligationGuid() {
        return this.exchangeSettlementObligationGuid;
    }

    @JsonProperty(value="exchange_settlement_obligation_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExchangeSettlementObligationGuid(String exchangeSettlementObligationGuid) {
        this.exchangeSettlementObligationGuid = exchangeSettlementObligationGuid;
    }

    public ExchangeSettlementPaymentOrderBankModel sequenceNumber(BigInteger sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The sequence number of the payment order")
    @JsonProperty(value="sequence_number")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getSequenceNumber() {
        return this.sequenceNumber;
    }

    @JsonProperty(value="sequence_number")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSequenceNumber(BigInteger sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public ExchangeSettlementPaymentOrderBankModel paymentAmount(BigInteger paymentAmount) {
        this.paymentAmount = paymentAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount expected to be received as part of this payment.")
    @JsonProperty(value="payment_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getPaymentAmount() {
        return this.paymentAmount;
    }

    @JsonProperty(value="payment_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentAmount(BigInteger paymentAmount) {
        this.paymentAmount = paymentAmount;
    }

    public ExchangeSettlementPaymentOrderBankModel internalAccountGuid(String internalAccountGuid) {
        this.internalAccountGuid = internalAccountGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier of the internal account that is expected to originate the payment.")
    @JsonProperty(value="internal_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInternalAccountGuid() {
        return this.internalAccountGuid;
    }

    @JsonProperty(value="internal_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalAccountGuid(String internalAccountGuid) {
        this.internalAccountGuid = internalAccountGuid;
    }

    public ExchangeSettlementPaymentOrderBankModel internalAccountType(InternalAccountTypeEnum internalAccountType) {
        this.internalAccountType = internalAccountType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of the internal account that is expected to originate the payment.")
    @JsonProperty(value="internal_account_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public InternalAccountTypeEnum getInternalAccountType() {
        return this.internalAccountType;
    }

    @JsonProperty(value="internal_account_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalAccountType(InternalAccountTypeEnum internalAccountType) {
        this.internalAccountType = internalAccountType;
    }

    public ExchangeSettlementPaymentOrderBankModel externalAccountGuid(String externalAccountGuid) {
        this.externalAccountGuid = externalAccountGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier of the external account that is expected to receive the payment.")
    @JsonProperty(value="external_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalAccountGuid() {
        return this.externalAccountGuid;
    }

    @JsonProperty(value="external_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalAccountGuid(String externalAccountGuid) {
        this.externalAccountGuid = externalAccountGuid;
    }

    public ExchangeSettlementPaymentOrderBankModel externalAccountType(ExternalAccountTypeEnum externalAccountType) {
        this.externalAccountType = externalAccountType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of the external account that is expected to receive the payment.")
    @JsonProperty(value="external_account_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ExternalAccountTypeEnum getExternalAccountType() {
        return this.externalAccountType;
    }

    @JsonProperty(value="external_account_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalAccountType(ExternalAccountTypeEnum externalAccountType) {
        this.externalAccountType = externalAccountType;
    }

    public ExchangeSettlementPaymentOrderBankModel state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The exchange settlement payment order's state")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StateEnum getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(StateEnum state) {
        this.state = state;
    }

    public ExchangeSettlementPaymentOrderBankModel createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the exchange settlement payment order was created at.")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExchangeSettlementPaymentOrderBankModel exchangeSettlementPaymentOrder = (ExchangeSettlementPaymentOrderBankModel)o;
        return Objects.equals(this.guid, exchangeSettlementPaymentOrder.guid) && Objects.equals(this.exchangeSettlementObligationGuid, exchangeSettlementPaymentOrder.exchangeSettlementObligationGuid) && Objects.equals(this.sequenceNumber, exchangeSettlementPaymentOrder.sequenceNumber) && Objects.equals(this.paymentAmount, exchangeSettlementPaymentOrder.paymentAmount) && Objects.equals(this.internalAccountGuid, exchangeSettlementPaymentOrder.internalAccountGuid) && Objects.equals((Object)this.internalAccountType, (Object)exchangeSettlementPaymentOrder.internalAccountType) && Objects.equals(this.externalAccountGuid, exchangeSettlementPaymentOrder.externalAccountGuid) && Objects.equals((Object)this.externalAccountType, (Object)exchangeSettlementPaymentOrder.externalAccountType) && Objects.equals((Object)this.state, (Object)exchangeSettlementPaymentOrder.state) && Objects.equals(this.createdAt, exchangeSettlementPaymentOrder.createdAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.guid, this.exchangeSettlementObligationGuid, this.sequenceNumber, this.paymentAmount, this.internalAccountGuid, this.internalAccountType, this.externalAccountGuid, this.externalAccountType, this.state, this.createdAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExchangeSettlementPaymentOrderBankModel {\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    exchangeSettlementObligationGuid: ").append(this.toIndentedString(this.exchangeSettlementObligationGuid)).append("\n");
        sb.append("    sequenceNumber: ").append(this.toIndentedString(this.sequenceNumber)).append("\n");
        sb.append("    paymentAmount: ").append(this.toIndentedString(this.paymentAmount)).append("\n");
        sb.append("    internalAccountGuid: ").append(this.toIndentedString(this.internalAccountGuid)).append("\n");
        sb.append("    internalAccountType: ").append(this.toIndentedString((Object)this.internalAccountType)).append("\n");
        sb.append("    externalAccountGuid: ").append(this.toIndentedString(this.externalAccountGuid)).append("\n");
        sb.append("    externalAccountType: ").append(this.toIndentedString((Object)this.externalAccountType)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        STORING("storing"),
        PENDING__CREATED("pending__created"),
        PENDING__PRINCIPAL_RESERVED("pending__principal_reserved"),
        PENDING__TRANSACTIONS_CLAIMED("pending__transactions_claimed"),
        NOT_APPROVED("not_approved"),
        IN_PROGRESS("in_progress"),
        NOT_OWING("not_owing"),
        AMOUNT_INCORRECT("amount_incorrect"),
        INVALID_PRINCIPAL("invalid_principal"),
        NSF("nsf"),
        SENT("sent"),
        REJECTED("rejected");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ExternalAccountTypeEnum {
        WALLET("external_wallet"),
        BANK_ACCOUNT("external_bank_account");

        private String value;

        private ExternalAccountTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ExternalAccountTypeEnum fromValue(String value) {
            for (ExternalAccountTypeEnum b : ExternalAccountTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum InternalAccountTypeEnum {
        WALLET("internal_wallet"),
        BANK_ACCOUNT("internal_bank_account");

        private String value;

        private InternalAccountTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static InternalAccountTypeEnum fromValue(String value) {
            for (InternalAccountTypeEnum b : InternalAccountTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

