/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"product_type", "customer_guid", "symbol", "asset", "side", "receive_amount", "deliver_amount", "product_provider"})
@JsonTypeName(value="PostQuote")
public class PostQuoteBankModel {
    public static final String JSON_PROPERTY_PRODUCT_TYPE = "product_type";
    private ProductTypeEnum productType = ProductTypeEnum.TRADING;
    public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
    private String customerGuid;
    public static final String JSON_PROPERTY_SYMBOL = "symbol";
    private String symbol;
    public static final String JSON_PROPERTY_ASSET = "asset";
    private String asset;
    public static final String JSON_PROPERTY_SIDE = "side";
    private SideEnum side;
    public static final String JSON_PROPERTY_RECEIVE_AMOUNT = "receive_amount";
    private BigInteger receiveAmount;
    public static final String JSON_PROPERTY_DELIVER_AMOUNT = "deliver_amount";
    private BigInteger deliverAmount;
    public static final String JSON_PROPERTY_PRODUCT_PROVIDER = "product_provider";
    private ProductProviderEnum productProvider;

    public PostQuoteBankModel productType(ProductTypeEnum productType) {
        this.productType = productType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of product the quote is for.")
    @JsonProperty(value="product_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProductTypeEnum getProductType() {
        return this.productType;
    }

    @JsonProperty(value="product_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProductType(ProductTypeEnum productType) {
        this.productType = productType;
    }

    public PostQuoteBankModel customerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The unique identifier for the customer.")
    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCustomerGuid() {
        return this.customerGuid;
    }

    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCustomerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
    }

    public PostQuoteBankModel symbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Symbol the quote is being requested for. Format is \"asset-counter_asset\" in uppercase. See the Symbols API for a complete list of cryptocurrencies supported.")
    @JsonProperty(value="symbol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSymbol() {
        return this.symbol;
    }

    @JsonProperty(value="symbol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public PostQuoteBankModel asset(String asset) {
        this.asset = asset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The asset code the quote was requested for. Populated for savings quotes.")
    @JsonProperty(value="asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAsset() {
        return this.asset;
    }

    @JsonProperty(value="asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAsset(String asset) {
        this.asset = asset;
    }

    public PostQuoteBankModel side(SideEnum side) {
        this.side = side;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The direction of the quote: either 'buy' or 'sell' for trade quotes; 'deposit' or 'withdrawal' for savings quotes.")
    @JsonProperty(value="side")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SideEnum getSide() {
        return this.side;
    }

    @JsonProperty(value="side")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSide(SideEnum side) {
        this.side = side;
    }

    public PostQuoteBankModel receiveAmount(BigInteger receiveAmount) {
        this.receiveAmount = receiveAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount to be received in base units of the currency: currency is \"asset\" for buy and \"counter_asset\" for sell for trade quotes and currency is always \"asset\" for savings quotes.")
    @JsonProperty(value="receive_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getReceiveAmount() {
        return this.receiveAmount;
    }

    @JsonProperty(value="receive_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReceiveAmount(BigInteger receiveAmount) {
        this.receiveAmount = receiveAmount;
    }

    public PostQuoteBankModel deliverAmount(BigInteger deliverAmount) {
        this.deliverAmount = deliverAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount to be delivered in base units of the currency: currency is \"counter_asset\" for buy and \"asset\" for sell for trade quotes and currency is always \"asset\" for savings quotes.")
    @JsonProperty(value="deliver_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getDeliverAmount() {
        return this.deliverAmount;
    }

    @JsonProperty(value="deliver_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliverAmount(BigInteger deliverAmount) {
        this.deliverAmount = deliverAmount;
    }

    public PostQuoteBankModel productProvider(ProductProviderEnum productProvider) {
        this.productProvider = productProvider;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The provider for the product being quoted. Populated for savings quotes.")
    @JsonProperty(value="product_provider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProductProviderEnum getProductProvider() {
        return this.productProvider;
    }

    @JsonProperty(value="product_provider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProductProvider(ProductProviderEnum productProvider) {
        this.productProvider = productProvider;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostQuoteBankModel postQuote = (PostQuoteBankModel)o;
        return Objects.equals((Object)this.productType, (Object)postQuote.productType) && Objects.equals(this.customerGuid, postQuote.customerGuid) && Objects.equals(this.symbol, postQuote.symbol) && Objects.equals(this.asset, postQuote.asset) && Objects.equals((Object)this.side, (Object)postQuote.side) && Objects.equals(this.receiveAmount, postQuote.receiveAmount) && Objects.equals(this.deliverAmount, postQuote.deliverAmount) && Objects.equals((Object)this.productProvider, (Object)postQuote.productProvider);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.productType, this.customerGuid, this.symbol, this.asset, this.side, this.receiveAmount, this.deliverAmount, this.productProvider});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostQuoteBankModel {\n");
        sb.append("    productType: ").append(this.toIndentedString((Object)this.productType)).append("\n");
        sb.append("    customerGuid: ").append(this.toIndentedString(this.customerGuid)).append("\n");
        sb.append("    symbol: ").append(this.toIndentedString(this.symbol)).append("\n");
        sb.append("    asset: ").append(this.toIndentedString(this.asset)).append("\n");
        sb.append("    side: ").append(this.toIndentedString((Object)this.side)).append("\n");
        sb.append("    receiveAmount: ").append(this.toIndentedString(this.receiveAmount)).append("\n");
        sb.append("    deliverAmount: ").append(this.toIndentedString(this.deliverAmount)).append("\n");
        sb.append("    productProvider: ").append(this.toIndentedString((Object)this.productProvider)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ProductProviderEnum {
        COMPOUND("compound");

        private String value;

        private ProductProviderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProductProviderEnum fromValue(String value) {
            for (ProductProviderEnum b : ProductProviderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum SideEnum {
        BUY("buy"),
        SELL("sell"),
        DEPOSIT("deposit"),
        WITHDRAWAL("withdrawal");

        private String value;

        private SideEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SideEnum fromValue(String value) {
            for (SideEnum b : SideEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ProductTypeEnum {
        TRADING("trading"),
        SAVINGS("savings");

        private String value;

        private ProductTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProductTypeEnum fromValue(String value) {
            for (ProductTypeEnum b : ProductTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

