/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"type", "guid", "created_at", "asset", "name", "bank_guid", "customer_guid", "platform_balance", "platform_available", "state"})
@JsonTypeName(value="Account")
public class AccountBankModel {
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_GUID = "guid";
    private String guid;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_ASSET = "asset";
    private String asset;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_BANK_GUID = "bank_guid";
    private String bankGuid;
    public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
    private String customerGuid;
    public static final String JSON_PROPERTY_PLATFORM_BALANCE = "platform_balance";
    private BigInteger platformBalance;
    public static final String JSON_PROPERTY_PLATFORM_AVAILABLE = "platform_available";
    private BigInteger platformAvailable;
    public static final String JSON_PROPERTY_STATE = "state";
    private StateEnum state;

    public AccountBankModel type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The account type.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public AccountBankModel guid(String guid) {
        this.guid = guid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Auto-generated unique identifier for the account.")
    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public AccountBankModel createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the account was created at.")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public AccountBankModel asset(String asset) {
        this.asset = asset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The asset code.")
    @JsonProperty(value="asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAsset() {
        return this.asset;
    }

    @JsonProperty(value="asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAsset(String asset) {
        this.asset = asset;
    }

    public AccountBankModel name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the account.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public AccountBankModel bankGuid(String bankGuid) {
        this.bankGuid = bankGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The bank identifier associated with the account.")
    @JsonProperty(value="bank_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBankGuid() {
        return this.bankGuid;
    }

    @JsonProperty(value="bank_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankGuid(String bankGuid) {
        this.bankGuid = bankGuid;
    }

    public AccountBankModel customerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer identifier associated with the account.")
    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomerGuid() {
        return this.customerGuid;
    }

    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
    }

    public AccountBankModel platformBalance(BigInteger platformBalance) {
        this.platformBalance = platformBalance;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount of funds that are in the account, in base units of the asset.")
    @JsonProperty(value="platform_balance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getPlatformBalance() {
        return this.platformBalance;
    }

    @JsonProperty(value="platform_balance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlatformBalance(BigInteger platformBalance) {
        this.platformBalance = platformBalance;
    }

    public AccountBankModel platformAvailable(BigInteger platformAvailable) {
        this.platformAvailable = platformAvailable;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount of funds that are in the account, in base units of the asset, that are available for use on the platform.")
    @JsonProperty(value="platform_available")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getPlatformAvailable() {
        return this.platformAvailable;
    }

    @JsonProperty(value="platform_available")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlatformAvailable(BigInteger platformAvailable) {
        this.platformAvailable = platformAvailable;
    }

    public AccountBankModel state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The account's state.")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StateEnum getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(StateEnum state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountBankModel account = (AccountBankModel)o;
        return Objects.equals((Object)this.type, (Object)account.type) && Objects.equals(this.guid, account.guid) && Objects.equals(this.createdAt, account.createdAt) && Objects.equals(this.asset, account.asset) && Objects.equals(this.name, account.name) && Objects.equals(this.bankGuid, account.bankGuid) && Objects.equals(this.customerGuid, account.customerGuid) && Objects.equals(this.platformBalance, account.platformBalance) && Objects.equals(this.platformAvailable, account.platformAvailable) && Objects.equals((Object)this.state, (Object)account.state);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.guid, this.createdAt, this.asset, this.name, this.bankGuid, this.customerGuid, this.platformBalance, this.platformAvailable, this.state});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountBankModel {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    asset: ").append(this.toIndentedString(this.asset)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    bankGuid: ").append(this.toIndentedString(this.bankGuid)).append("\n");
        sb.append("    customerGuid: ").append(this.toIndentedString(this.customerGuid)).append("\n");
        sb.append("    platformBalance: ").append(this.toIndentedString(this.platformBalance)).append("\n");
        sb.append("    platformAvailable: ").append(this.toIndentedString(this.platformAvailable)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        STORING("storing"),
        CREATED("created");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        BACKSTOPPED("backstopped"),
        TRADING("trading"),
        FEE("fee");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

