package app.cybrid.cybrid_api_bank.client.api;

import app.cybrid.cybrid_api_bank.client.ApiClient;

import app.cybrid.cybrid_api_bank.client.model.ErrorResponseBankModel;
import app.cybrid.cybrid_api_bank.client.model.FeeConfigurationBankModel;
import app.cybrid.cybrid_api_bank.client.model.FeeConfigurationListBankModel;
import app.cybrid.cybrid_api_bank.client.model.PostFeeConfigurationBankModel;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-11-28T15:57:30.153409Z[Etc/UTC]")
public class FeeConfigurationsBankApi {
    private ApiClient apiClient;

    public FeeConfigurationsBankApi() {
        this(new ApiClient());
    }

    @Autowired
    public FeeConfigurationsBankApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Fee Configuration
     * Creates a fee configuration.  Required scope: **banks:write**
     * <p><b>201</b> - fee configuration created
     * <p><b>400</b> - Invalid requests - malformed authentication header
     * <p><b>401</b> - Unauthorized - Authentication failed, 
     * <p><b>403</b> - Invalid scope
     * @param postFeeConfigurationBankModel The postFeeConfigurationBankModel parameter
     * @return FeeConfigurationBankModel
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createFeeConfigurationRequestCreation(PostFeeConfigurationBankModel postFeeConfigurationBankModel) throws WebClientResponseException {
        Object postBody = postFeeConfigurationBankModel;
        // verify the required parameter 'postFeeConfigurationBankModel' is set
        if (postFeeConfigurationBankModel == null) {
            throw new WebClientResponseException("Missing the required parameter 'postFeeConfigurationBankModel' when calling createFeeConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "BearerAuth", "oauth2" };

        ParameterizedTypeReference<FeeConfigurationBankModel> localVarReturnType = new ParameterizedTypeReference<FeeConfigurationBankModel>() {};
        return apiClient.invokeAPI("/api/fee_configurations", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Fee Configuration
     * Creates a fee configuration.  Required scope: **banks:write**
     * <p><b>201</b> - fee configuration created
     * <p><b>400</b> - Invalid requests - malformed authentication header
     * <p><b>401</b> - Unauthorized - Authentication failed, 
     * <p><b>403</b> - Invalid scope
     * @param postFeeConfigurationBankModel The postFeeConfigurationBankModel parameter
     * @return FeeConfigurationBankModel
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<FeeConfigurationBankModel> createFeeConfiguration(PostFeeConfigurationBankModel postFeeConfigurationBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<FeeConfigurationBankModel> localVarReturnType = new ParameterizedTypeReference<FeeConfigurationBankModel>() {};
        return createFeeConfigurationRequestCreation(postFeeConfigurationBankModel).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<FeeConfigurationBankModel>> createFeeConfigurationWithHttpInfo(PostFeeConfigurationBankModel postFeeConfigurationBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<FeeConfigurationBankModel> localVarReturnType = new ParameterizedTypeReference<FeeConfigurationBankModel>() {};
        return createFeeConfigurationRequestCreation(postFeeConfigurationBankModel).toEntity(localVarReturnType);
    }
    /**
     * Get Fee Configuration
     * Retrieves a fee configuration.  Required scope: **banks:read**
     * <p><b>200</b> - fee configuration found
     * <p><b>401</b> - Unauthorized - Authentication failed, 
     * <p><b>403</b> - Invalid scope
     * <p><b>404</b> - fee_configuration not found
     * @param feeConfigurationGuid Identifier for the fee configuration.
     * @return FeeConfigurationBankModel
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getFeeConfigurationRequestCreation(String feeConfigurationGuid) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'feeConfigurationGuid' is set
        if (feeConfigurationGuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'feeConfigurationGuid' when calling getFeeConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("fee_configuration_guid", feeConfigurationGuid);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "BearerAuth", "oauth2" };

        ParameterizedTypeReference<FeeConfigurationBankModel> localVarReturnType = new ParameterizedTypeReference<FeeConfigurationBankModel>() {};
        return apiClient.invokeAPI("/api/fee_configurations/{fee_configuration_guid}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Get Fee Configuration
     * Retrieves a fee configuration.  Required scope: **banks:read**
     * <p><b>200</b> - fee configuration found
     * <p><b>401</b> - Unauthorized - Authentication failed, 
     * <p><b>403</b> - Invalid scope
     * <p><b>404</b> - fee_configuration not found
     * @param feeConfigurationGuid Identifier for the fee configuration.
     * @return FeeConfigurationBankModel
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<FeeConfigurationBankModel> getFeeConfiguration(String feeConfigurationGuid) throws WebClientResponseException {
        ParameterizedTypeReference<FeeConfigurationBankModel> localVarReturnType = new ParameterizedTypeReference<FeeConfigurationBankModel>() {};
        return getFeeConfigurationRequestCreation(feeConfigurationGuid).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<FeeConfigurationBankModel>> getFeeConfigurationWithHttpInfo(String feeConfigurationGuid) throws WebClientResponseException {
        ParameterizedTypeReference<FeeConfigurationBankModel> localVarReturnType = new ParameterizedTypeReference<FeeConfigurationBankModel>() {};
        return getFeeConfigurationRequestCreation(feeConfigurationGuid).toEntity(localVarReturnType);
    }
    /**
     * List Fee Configurations
     * Retrieves a listing of fee configurations for a bank.  Required scope: **banks:read**
     * <p><b>200</b> - get list of fee configurations
     * <p><b>400</b> - Invalid requests - malformed authentication header
     * <p><b>401</b> - Unauthorized - Authentication failed, 
     * <p><b>403</b> - Invalid scope
     * @param page The page parameter
     * @param perPage The perPage parameter
     * @return FeeConfigurationListBankModel
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec listFeeConfigurationsRequestCreation(java.math.BigInteger page, java.math.BigInteger perPage) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "per_page", perPage));

        final String[] localVarAccepts = { 
            "application/json"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "BearerAuth", "oauth2" };

        ParameterizedTypeReference<FeeConfigurationListBankModel> localVarReturnType = new ParameterizedTypeReference<FeeConfigurationListBankModel>() {};
        return apiClient.invokeAPI("/api/fee_configurations", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List Fee Configurations
     * Retrieves a listing of fee configurations for a bank.  Required scope: **banks:read**
     * <p><b>200</b> - get list of fee configurations
     * <p><b>400</b> - Invalid requests - malformed authentication header
     * <p><b>401</b> - Unauthorized - Authentication failed, 
     * <p><b>403</b> - Invalid scope
     * @param page The page parameter
     * @param perPage The perPage parameter
     * @return FeeConfigurationListBankModel
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<FeeConfigurationListBankModel> listFeeConfigurations(java.math.BigInteger page, java.math.BigInteger perPage) throws WebClientResponseException {
        ParameterizedTypeReference<FeeConfigurationListBankModel> localVarReturnType = new ParameterizedTypeReference<FeeConfigurationListBankModel>() {};
        return listFeeConfigurationsRequestCreation(page, perPage).bodyToMono(localVarReturnType);
    }

    public Mono<ResponseEntity<FeeConfigurationListBankModel>> listFeeConfigurationsWithHttpInfo(java.math.BigInteger page, java.math.BigInteger perPage) throws WebClientResponseException {
        ParameterizedTypeReference<FeeConfigurationListBankModel> localVarReturnType = new ParameterizedTypeReference<FeeConfigurationListBankModel>() {};
        return listFeeConfigurationsRequestCreation(page, perPage).toEntity(localVarReturnType);
    }
}
