/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.api;

import app.cybrid.cybrid_api_bank.client.ApiClient;
import app.cybrid.cybrid_api_bank.client.model.PostVerificationKeyBankModel;
import app.cybrid.cybrid_api_bank.client.model.VerificationKeyBankModel;
import app.cybrid.cybrid_api_bank.client.model.VerificationKeyListBankModel;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class VerificationKeysBankApi {
    private ApiClient apiClient;

    public VerificationKeysBankApi() {
        this(new ApiClient());
    }

    @Autowired
    public VerificationKeysBankApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createVerificationKeyRequestCreation(String bankGuid, PostVerificationKeyBankModel postVerificationKeyBankModel) throws WebClientResponseException {
        PostVerificationKeyBankModel postBody = postVerificationKeyBankModel;
        if (bankGuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'bankGuid' when calling createVerificationKey", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (postVerificationKeyBankModel == null) {
            throw new WebClientResponseException("Missing the required parameter 'postVerificationKeyBankModel' when calling createVerificationKey", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("bank_guid", bankGuid);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<VerificationKeyBankModel> localVarReturnType = new ParameterizedTypeReference<VerificationKeyBankModel>(){};
        return this.apiClient.invokeAPI("/api/banks/{bank_guid}/verification_keys", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<VerificationKeyBankModel> createVerificationKey(String bankGuid, PostVerificationKeyBankModel postVerificationKeyBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<VerificationKeyBankModel> localVarReturnType = new ParameterizedTypeReference<VerificationKeyBankModel>(){};
        return this.createVerificationKeyRequestCreation(bankGuid, postVerificationKeyBankModel).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<VerificationKeyBankModel>> createVerificationKeyWithHttpInfo(String bankGuid, PostVerificationKeyBankModel postVerificationKeyBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<VerificationKeyBankModel> localVarReturnType = new ParameterizedTypeReference<VerificationKeyBankModel>(){};
        return this.createVerificationKeyRequestCreation(bankGuid, postVerificationKeyBankModel).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec getVerificationKeyRequestCreation(String bankGuid, String verificationKeyGuid) throws WebClientResponseException {
        Object postBody = null;
        if (bankGuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'bankGuid' when calling getVerificationKey", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (verificationKeyGuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'verificationKeyGuid' when calling getVerificationKey", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("bank_guid", bankGuid);
        pathParams.put("verification_key_guid", verificationKeyGuid);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<VerificationKeyBankModel> localVarReturnType = new ParameterizedTypeReference<VerificationKeyBankModel>(){};
        return this.apiClient.invokeAPI("/api/banks/{bank_guid}/verification_keys/{verification_key_guid}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<VerificationKeyBankModel> getVerificationKey(String bankGuid, String verificationKeyGuid) throws WebClientResponseException {
        ParameterizedTypeReference<VerificationKeyBankModel> localVarReturnType = new ParameterizedTypeReference<VerificationKeyBankModel>(){};
        return this.getVerificationKeyRequestCreation(bankGuid, verificationKeyGuid).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<VerificationKeyBankModel>> getVerificationKeyWithHttpInfo(String bankGuid, String verificationKeyGuid) throws WebClientResponseException {
        ParameterizedTypeReference<VerificationKeyBankModel> localVarReturnType = new ParameterizedTypeReference<VerificationKeyBankModel>(){};
        return this.getVerificationKeyRequestCreation(bankGuid, verificationKeyGuid).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec listVerificationKeysRequestCreation(String bankGuid, BigInteger page, BigInteger perPage) throws WebClientResponseException {
        Object postBody = null;
        if (bankGuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'bankGuid' when calling listVerificationKeys", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("bank_guid", bankGuid);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "per_page", perPage));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<VerificationKeyListBankModel> localVarReturnType = new ParameterizedTypeReference<VerificationKeyListBankModel>(){};
        return this.apiClient.invokeAPI("/api/banks/{bank_guid}/verification_keys", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<VerificationKeyListBankModel> listVerificationKeys(String bankGuid, BigInteger page, BigInteger perPage) throws WebClientResponseException {
        ParameterizedTypeReference<VerificationKeyListBankModel> localVarReturnType = new ParameterizedTypeReference<VerificationKeyListBankModel>(){};
        return this.listVerificationKeysRequestCreation(bankGuid, page, perPage).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<VerificationKeyListBankModel>> listVerificationKeysWithHttpInfo(String bankGuid, BigInteger page, BigInteger perPage) throws WebClientResponseException {
        ParameterizedTypeReference<VerificationKeyListBankModel> localVarReturnType = new ParameterizedTypeReference<VerificationKeyListBankModel>(){};
        return this.listVerificationKeysRequestCreation(bankGuid, page, perPage).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

