/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import app.cybrid.cybrid_api_bank.client.model.PostFeeBankModel;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonPropertyOrder(value={"product_type", "asset", "fees"})
@JsonTypeName(value="PostFeeConfiguration")
public class PostFeeConfigurationBankModel {
    public static final String JSON_PROPERTY_PRODUCT_TYPE = "product_type";
    private ProductTypeEnum productType;
    public static final String JSON_PROPERTY_ASSET = "asset";
    private String asset;
    public static final String JSON_PROPERTY_FEES = "fees";
    private List<PostFeeBankModel> fees = new ArrayList<PostFeeBankModel>();

    public PostFeeConfigurationBankModel productType(ProductTypeEnum productType) {
        this.productType = productType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The type of product being configured.")
    @JsonProperty(value="product_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ProductTypeEnum getProductType() {
        return this.productType;
    }

    @JsonProperty(value="product_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setProductType(ProductTypeEnum productType) {
        this.productType = productType;
    }

    public PostFeeConfigurationBankModel asset(String asset) {
        this.asset = asset;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The asset code.")
    @JsonProperty(value="asset")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAsset() {
        return this.asset;
    }

    @JsonProperty(value="asset")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAsset(String asset) {
        this.asset = asset;
    }

    public PostFeeConfigurationBankModel fees(List<PostFeeBankModel> fees) {
        this.fees = fees;
        return this;
    }

    public PostFeeConfigurationBankModel addFeesItem(PostFeeBankModel feesItem) {
        this.fees.add(feesItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The fees associated with the configuration")
    @JsonProperty(value="fees")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<PostFeeBankModel> getFees() {
        return this.fees;
    }

    @JsonProperty(value="fees")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFees(List<PostFeeBankModel> fees) {
        this.fees = fees;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostFeeConfigurationBankModel postFeeConfiguration = (PostFeeConfigurationBankModel)o;
        return Objects.equals((Object)this.productType, (Object)postFeeConfiguration.productType) && Objects.equals(this.asset, postFeeConfiguration.asset) && Objects.equals(this.fees, postFeeConfiguration.fees);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.productType, this.asset, this.fees});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostFeeConfigurationBankModel {\n");
        sb.append("    productType: ").append(this.toIndentedString((Object)this.productType)).append("\n");
        sb.append("    asset: ").append(this.toIndentedString(this.asset)).append("\n");
        sb.append("    fees: ").append(this.toIndentedString(this.fees)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ProductTypeEnum {
        TRADING("trading");

        private String value;

        private ProductTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProductTypeEnum fromValue(String value) {
            for (ProductTypeEnum b : ProductTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

