/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"guid", "name", "asset", "account_kind", "environment", "bank_guid", "customer_guid", "created_at", "plaid_institution_id", "plaid_account_mask", "plaid_account_name", "state", "failure_code"})
@JsonTypeName(value="ExternalBankAccount")
public class ExternalBankAccountBankModel {
    public static final String JSON_PROPERTY_GUID = "guid";
    private String guid;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_ASSET = "asset";
    private String asset;
    public static final String JSON_PROPERTY_ACCOUNT_KIND = "account_kind";
    private AccountKindEnum accountKind;
    public static final String JSON_PROPERTY_ENVIRONMENT = "environment";
    private EnvironmentEnum environment;
    public static final String JSON_PROPERTY_BANK_GUID = "bank_guid";
    private String bankGuid;
    public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
    private String customerGuid;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_PLAID_INSTITUTION_ID = "plaid_institution_id";
    private String plaidInstitutionId;
    public static final String JSON_PROPERTY_PLAID_ACCOUNT_MASK = "plaid_account_mask";
    private String plaidAccountMask;
    public static final String JSON_PROPERTY_PLAID_ACCOUNT_NAME = "plaid_account_name";
    private String plaidAccountName;
    public static final String JSON_PROPERTY_STATE = "state";
    private StateEnum state;
    public static final String JSON_PROPERTY_FAILURE_CODE = "failure_code";
    private String failureCode;

    public ExternalBankAccountBankModel guid(String guid) {
        this.guid = guid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Auto-generated unique identifier for the account.")
    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public ExternalBankAccountBankModel name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the account.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public ExternalBankAccountBankModel asset(String asset) {
        this.asset = asset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The asset code.")
    @JsonProperty(value="asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAsset() {
        return this.asset;
    }

    @JsonProperty(value="asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAsset(String asset) {
        this.asset = asset;
    }

    public ExternalBankAccountBankModel accountKind(AccountKindEnum accountKind) {
        this.accountKind = accountKind;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of account.")
    @JsonProperty(value="account_kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AccountKindEnum getAccountKind() {
        return this.accountKind;
    }

    @JsonProperty(value="account_kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountKind(AccountKindEnum accountKind) {
        this.accountKind = accountKind;
    }

    public ExternalBankAccountBankModel environment(EnvironmentEnum environment) {
        this.environment = environment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The environment that the external bank account is operating in.")
    @JsonProperty(value="environment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EnvironmentEnum getEnvironment() {
        return this.environment;
    }

    @JsonProperty(value="environment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnvironment(EnvironmentEnum environment) {
        this.environment = environment;
    }

    public ExternalBankAccountBankModel bankGuid(String bankGuid) {
        this.bankGuid = bankGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The bank identifier.")
    @JsonProperty(value="bank_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBankGuid() {
        return this.bankGuid;
    }

    @JsonProperty(value="bank_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankGuid(String bankGuid) {
        this.bankGuid = bankGuid;
    }

    public ExternalBankAccountBankModel customerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer identifier.")
    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomerGuid() {
        return this.customerGuid;
    }

    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
    }

    public ExternalBankAccountBankModel createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the exchange was created at.")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public ExternalBankAccountBankModel plaidInstitutionId(String plaidInstitutionId) {
        this.plaidInstitutionId = plaidInstitutionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Plaid institution ID for the account.")
    @JsonProperty(value="plaid_institution_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPlaidInstitutionId() {
        return this.plaidInstitutionId;
    }

    @JsonProperty(value="plaid_institution_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlaidInstitutionId(String plaidInstitutionId) {
        this.plaidInstitutionId = plaidInstitutionId;
    }

    public ExternalBankAccountBankModel plaidAccountMask(String plaidAccountMask) {
        this.plaidAccountMask = plaidAccountMask;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The account number mask for the account.")
    @JsonProperty(value="plaid_account_mask")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPlaidAccountMask() {
        return this.plaidAccountMask;
    }

    @JsonProperty(value="plaid_account_mask")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlaidAccountMask(String plaidAccountMask) {
        this.plaidAccountMask = plaidAccountMask;
    }

    public ExternalBankAccountBankModel plaidAccountName(String plaidAccountName) {
        this.plaidAccountName = plaidAccountName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name for the account.")
    @JsonProperty(value="plaid_account_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPlaidAccountName() {
        return this.plaidAccountName;
    }

    @JsonProperty(value="plaid_account_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlaidAccountName(String plaidAccountName) {
        this.plaidAccountName = plaidAccountName;
    }

    public ExternalBankAccountBankModel state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The state of the external bank account.")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StateEnum getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(StateEnum state) {
        this.state = state;
    }

    public ExternalBankAccountBankModel failureCode(String failureCode) {
        this.failureCode = failureCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The failure code for failed transfers.")
    @JsonProperty(value="failure_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFailureCode() {
        return this.failureCode;
    }

    @JsonProperty(value="failure_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFailureCode(String failureCode) {
        this.failureCode = failureCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalBankAccountBankModel externalBankAccount = (ExternalBankAccountBankModel)o;
        return Objects.equals(this.guid, externalBankAccount.guid) && Objects.equals(this.name, externalBankAccount.name) && Objects.equals(this.asset, externalBankAccount.asset) && Objects.equals((Object)this.accountKind, (Object)externalBankAccount.accountKind) && Objects.equals((Object)this.environment, (Object)externalBankAccount.environment) && Objects.equals(this.bankGuid, externalBankAccount.bankGuid) && Objects.equals(this.customerGuid, externalBankAccount.customerGuid) && Objects.equals(this.createdAt, externalBankAccount.createdAt) && Objects.equals(this.plaidInstitutionId, externalBankAccount.plaidInstitutionId) && Objects.equals(this.plaidAccountMask, externalBankAccount.plaidAccountMask) && Objects.equals(this.plaidAccountName, externalBankAccount.plaidAccountName) && Objects.equals((Object)this.state, (Object)externalBankAccount.state) && Objects.equals(this.failureCode, externalBankAccount.failureCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.guid, this.name, this.asset, this.accountKind, this.environment, this.bankGuid, this.customerGuid, this.createdAt, this.plaidInstitutionId, this.plaidAccountMask, this.plaidAccountName, this.state, this.failureCode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExternalBankAccountBankModel {\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    asset: ").append(this.toIndentedString(this.asset)).append("\n");
        sb.append("    accountKind: ").append(this.toIndentedString((Object)this.accountKind)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString((Object)this.environment)).append("\n");
        sb.append("    bankGuid: ").append(this.toIndentedString(this.bankGuid)).append("\n");
        sb.append("    customerGuid: ").append(this.toIndentedString(this.customerGuid)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    plaidInstitutionId: ").append(this.toIndentedString(this.plaidInstitutionId)).append("\n");
        sb.append("    plaidAccountMask: ").append(this.toIndentedString(this.plaidAccountMask)).append("\n");
        sb.append("    plaidAccountName: ").append(this.toIndentedString(this.plaidAccountName)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    failureCode: ").append(this.toIndentedString(this.failureCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        STORING("storing"),
        COMPLETED("completed"),
        FAILED("failed"),
        REFRESH_REQUIRED("refresh_required"),
        DELETING("deleting"),
        DELETED("deleted");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum EnvironmentEnum {
        SANDBOX("sandbox"),
        PRODUCTION("production");

        private String value;

        private EnvironmentEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EnvironmentEnum fromValue(String value) {
            for (EnvironmentEnum b : EnvironmentEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum AccountKindEnum {
        PLAID("plaid"),
        PLAID_PROCESSOR_TOKEN("plaid_processor_token");

        private String value;

        private AccountKindEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AccountKindEnum fromValue(String value) {
            for (AccountKindEnum b : AccountKindEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

