/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"customer_guid", "symbol", "receive_amount", "deliver_amount"})
@JsonTypeName(value="PostReward")
public class PostRewardBankModel {
    public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
    private String customerGuid;
    public static final String JSON_PROPERTY_SYMBOL = "symbol";
    private String symbol;
    public static final String JSON_PROPERTY_RECEIVE_AMOUNT = "receive_amount";
    private BigInteger receiveAmount;
    public static final String JSON_PROPERTY_DELIVER_AMOUNT = "deliver_amount";
    private BigInteger deliverAmount;

    public PostRewardBankModel customerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The unique identifier for the customer.")
    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCustomerGuid() {
        return this.customerGuid;
    }

    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCustomerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
    }

    public PostRewardBankModel symbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Symbol the quote is being requested for. Format is \"asset-counter_asset\" in uppercase. See the Symbols API for a complete list of cryptocurrencies supported.")
    @JsonProperty(value="symbol")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSymbol() {
        return this.symbol;
    }

    @JsonProperty(value="symbol")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public PostRewardBankModel receiveAmount(BigInteger receiveAmount) {
        this.receiveAmount = receiveAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount to be received in base units of the currency: currency is \"asset\" for buy and \"counter_asset\" for sell.")
    @JsonProperty(value="receive_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getReceiveAmount() {
        return this.receiveAmount;
    }

    @JsonProperty(value="receive_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReceiveAmount(BigInteger receiveAmount) {
        this.receiveAmount = receiveAmount;
    }

    public PostRewardBankModel deliverAmount(BigInteger deliverAmount) {
        this.deliverAmount = deliverAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount to be delivered in base units of the currency: currency is \"counter_asset\" for buy and \"asset\" for sell.")
    @JsonProperty(value="deliver_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getDeliverAmount() {
        return this.deliverAmount;
    }

    @JsonProperty(value="deliver_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliverAmount(BigInteger deliverAmount) {
        this.deliverAmount = deliverAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostRewardBankModel postReward = (PostRewardBankModel)o;
        return Objects.equals(this.customerGuid, postReward.customerGuid) && Objects.equals(this.symbol, postReward.symbol) && Objects.equals(this.receiveAmount, postReward.receiveAmount) && Objects.equals(this.deliverAmount, postReward.deliverAmount);
    }

    public int hashCode() {
        return Objects.hash(this.customerGuid, this.symbol, this.receiveAmount, this.deliverAmount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostRewardBankModel {\n");
        sb.append("    customerGuid: ").append(this.toIndentedString(this.customerGuid)).append("\n");
        sb.append("    symbol: ").append(this.toIndentedString(this.symbol)).append("\n");
        sb.append("    receiveAmount: ").append(this.toIndentedString(this.receiveAmount)).append("\n");
        sb.append("    deliverAmount: ").append(this.toIndentedString(this.deliverAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

