/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"guid", "name", "asset_code", "account_kind", "environment", "exchange_guid", "created_at", "state", "failure_code"})
@JsonTypeName(value="ExternalWallet")
public class ExternalWalletBankModel {
    public static final String JSON_PROPERTY_GUID = "guid";
    private String guid;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_ASSET_CODE = "asset_code";
    private String assetCode;
    public static final String JSON_PROPERTY_ACCOUNT_KIND = "account_kind";
    private AccountKindEnum accountKind;
    public static final String JSON_PROPERTY_ENVIRONMENT = "environment";
    private EnvironmentEnum environment;
    public static final String JSON_PROPERTY_EXCHANGE_GUID = "exchange_guid";
    private String exchangeGuid;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_STATE = "state";
    private StateEnum state;
    public static final String JSON_PROPERTY_FAILURE_CODE = "failure_code";
    private String failureCode;

    public ExternalWalletBankModel guid(String guid) {
        this.guid = guid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Auto-generated unique identifier for the account.")
    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public ExternalWalletBankModel name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the account.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public ExternalWalletBankModel assetCode(String assetCode) {
        this.assetCode = assetCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The asset code.")
    @JsonProperty(value="asset_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAssetCode() {
        return this.assetCode;
    }

    @JsonProperty(value="asset_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAssetCode(String assetCode) {
        this.assetCode = assetCode;
    }

    public ExternalWalletBankModel accountKind(AccountKindEnum accountKind) {
        this.accountKind = accountKind;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of account.")
    @JsonProperty(value="account_kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AccountKindEnum getAccountKind() {
        return this.accountKind;
    }

    @JsonProperty(value="account_kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountKind(AccountKindEnum accountKind) {
        this.accountKind = accountKind;
    }

    public ExternalWalletBankModel environment(EnvironmentEnum environment) {
        this.environment = environment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The environment that the exchange is operating in.")
    @JsonProperty(value="environment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EnvironmentEnum getEnvironment() {
        return this.environment;
    }

    @JsonProperty(value="environment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnvironment(EnvironmentEnum environment) {
        this.environment = environment;
    }

    public ExternalWalletBankModel exchangeGuid(String exchangeGuid) {
        this.exchangeGuid = exchangeGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The exchange identifier.")
    @JsonProperty(value="exchange_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExchangeGuid() {
        return this.exchangeGuid;
    }

    @JsonProperty(value="exchange_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExchangeGuid(String exchangeGuid) {
        this.exchangeGuid = exchangeGuid;
    }

    public ExternalWalletBankModel createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the exchange was created at.")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public ExternalWalletBankModel state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The state of an external wallet")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StateEnum getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(StateEnum state) {
        this.state = state;
    }

    public ExternalWalletBankModel failureCode(String failureCode) {
        this.failureCode = failureCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The failure code of an external wallet (if any)")
    @JsonProperty(value="failure_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFailureCode() {
        return this.failureCode;
    }

    @JsonProperty(value="failure_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFailureCode(String failureCode) {
        this.failureCode = failureCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalWalletBankModel externalWallet = (ExternalWalletBankModel)o;
        return Objects.equals(this.guid, externalWallet.guid) && Objects.equals(this.name, externalWallet.name) && Objects.equals(this.assetCode, externalWallet.assetCode) && Objects.equals((Object)this.accountKind, (Object)externalWallet.accountKind) && Objects.equals((Object)this.environment, (Object)externalWallet.environment) && Objects.equals(this.exchangeGuid, externalWallet.exchangeGuid) && Objects.equals(this.createdAt, externalWallet.createdAt) && Objects.equals((Object)this.state, (Object)externalWallet.state) && Objects.equals(this.failureCode, externalWallet.failureCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.guid, this.name, this.assetCode, this.accountKind, this.environment, this.exchangeGuid, this.createdAt, this.state, this.failureCode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExternalWalletBankModel {\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    assetCode: ").append(this.toIndentedString(this.assetCode)).append("\n");
        sb.append("    accountKind: ").append(this.toIndentedString((Object)this.accountKind)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString((Object)this.environment)).append("\n");
        sb.append("    exchangeGuid: ").append(this.toIndentedString(this.exchangeGuid)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    failureCode: ").append(this.toIndentedString(this.failureCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        STORING("storing"),
        PENDING("pending"),
        FAILED("failed"),
        COMPLETED("completed");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum EnvironmentEnum {
        SANDBOX("sandbox"),
        PRODUCTION("production");

        private String value;

        private EnvironmentEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EnvironmentEnum fromValue(String value) {
            for (EnvironmentEnum b : EnvironmentEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum AccountKindEnum {
        FIREBLOCKS_EXTERNAL_WALLET("fireblocks_external_wallet"),
        CIRCLE_WIRE_EXTERNAL_WALLET("circle_wire_external_wallet");

        private String value;

        private AccountKindEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AccountKindEnum fromValue(String value) {
            for (AccountKindEnum b : AccountKindEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

