/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.api;

import app.cybrid.cybrid_api_bank.client.ApiClient;
import app.cybrid.cybrid_api_bank.client.model.ExternalWalletBankModel;
import app.cybrid.cybrid_api_bank.client.model.ExternalWalletListBankModel;
import app.cybrid.cybrid_api_bank.client.model.PostExternalWalletBankModel;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class ExternalWalletsBankApi {
    private ApiClient apiClient;

    public ExternalWalletsBankApi() {
        this(new ApiClient());
    }

    @Autowired
    public ExternalWalletsBankApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createExternalWalletRequestCreation(PostExternalWalletBankModel postExternalWalletBankModel) throws WebClientResponseException {
        PostExternalWalletBankModel postBody = postExternalWalletBankModel;
        if (postExternalWalletBankModel == null) {
            throw new WebClientResponseException("Missing the required parameter 'postExternalWalletBankModel' when calling createExternalWallet", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<ExternalWalletBankModel> localVarReturnType = new ParameterizedTypeReference<ExternalWalletBankModel>(){};
        return this.apiClient.invokeAPI("/api/external_wallets", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ExternalWalletBankModel> createExternalWallet(PostExternalWalletBankModel postExternalWalletBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<ExternalWalletBankModel> localVarReturnType = new ParameterizedTypeReference<ExternalWalletBankModel>(){};
        return this.createExternalWalletRequestCreation(postExternalWalletBankModel).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ExternalWalletBankModel>> createExternalWalletWithHttpInfo(PostExternalWalletBankModel postExternalWalletBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<ExternalWalletBankModel> localVarReturnType = new ParameterizedTypeReference<ExternalWalletBankModel>(){};
        return this.createExternalWalletRequestCreation(postExternalWalletBankModel).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec deleteExternalWalletRequestCreation(String externalWalletGuid) throws WebClientResponseException {
        Object postBody = null;
        if (externalWalletGuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'externalWalletGuid' when calling deleteExternalWallet", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("external_wallet_guid", externalWalletGuid);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<ExternalWalletBankModel> localVarReturnType = new ParameterizedTypeReference<ExternalWalletBankModel>(){};
        return this.apiClient.invokeAPI("/api/external_wallets/{external_wallet_guid}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ExternalWalletBankModel> deleteExternalWallet(String externalWalletGuid) throws WebClientResponseException {
        ParameterizedTypeReference<ExternalWalletBankModel> localVarReturnType = new ParameterizedTypeReference<ExternalWalletBankModel>(){};
        return this.deleteExternalWalletRequestCreation(externalWalletGuid).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ExternalWalletBankModel>> deleteExternalWalletWithHttpInfo(String externalWalletGuid) throws WebClientResponseException {
        ParameterizedTypeReference<ExternalWalletBankModel> localVarReturnType = new ParameterizedTypeReference<ExternalWalletBankModel>(){};
        return this.deleteExternalWalletRequestCreation(externalWalletGuid).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec getExternalWalletRequestCreation(String externalWalletGuid) throws WebClientResponseException {
        Object postBody = null;
        if (externalWalletGuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'externalWalletGuid' when calling getExternalWallet", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("external_wallet_guid", externalWalletGuid);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<ExternalWalletBankModel> localVarReturnType = new ParameterizedTypeReference<ExternalWalletBankModel>(){};
        return this.apiClient.invokeAPI("/api/external_wallets/{external_wallet_guid}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ExternalWalletBankModel> getExternalWallet(String externalWalletGuid) throws WebClientResponseException {
        ParameterizedTypeReference<ExternalWalletBankModel> localVarReturnType = new ParameterizedTypeReference<ExternalWalletBankModel>(){};
        return this.getExternalWalletRequestCreation(externalWalletGuid).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ExternalWalletBankModel>> getExternalWalletWithHttpInfo(String externalWalletGuid) throws WebClientResponseException {
        ParameterizedTypeReference<ExternalWalletBankModel> localVarReturnType = new ParameterizedTypeReference<ExternalWalletBankModel>(){};
        return this.getExternalWalletRequestCreation(externalWalletGuid).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec listExternalWalletsRequestCreation(BigInteger page, BigInteger perPage, String guid, String bankGuid, String customerGuid) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "per_page", perPage));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "guid", guid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "bank_guid", bankGuid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "customer_guid", customerGuid));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<ExternalWalletListBankModel> localVarReturnType = new ParameterizedTypeReference<ExternalWalletListBankModel>(){};
        return this.apiClient.invokeAPI("/api/external_wallets", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ExternalWalletListBankModel> listExternalWallets(BigInteger page, BigInteger perPage, String guid, String bankGuid, String customerGuid) throws WebClientResponseException {
        ParameterizedTypeReference<ExternalWalletListBankModel> localVarReturnType = new ParameterizedTypeReference<ExternalWalletListBankModel>(){};
        return this.listExternalWalletsRequestCreation(page, perPage, guid, bankGuid, customerGuid).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ExternalWalletListBankModel>> listExternalWalletsWithHttpInfo(BigInteger page, BigInteger perPage, String guid, String bankGuid, String customerGuid) throws WebClientResponseException {
        ParameterizedTypeReference<ExternalWalletListBankModel> localVarReturnType = new ParameterizedTypeReference<ExternalWalletListBankModel>(){};
        return this.listExternalWalletsRequestCreation(page, perPage, guid, bankGuid, customerGuid).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

