/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import app.cybrid.cybrid_api_bank.client.model.PostOneTimeAddressBankModel;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"quote_guid", "transfer_type", "external_wallet_guid", "external_bank_account_guid", "one_time_address", "expected_error"})
@JsonTypeName(value="PostTransfer")
public class PostTransferBankModel {
    public static final String JSON_PROPERTY_QUOTE_GUID = "quote_guid";
    private String quoteGuid;
    public static final String JSON_PROPERTY_TRANSFER_TYPE = "transfer_type";
    private TransferTypeEnum transferType;
    public static final String JSON_PROPERTY_EXTERNAL_WALLET_GUID = "external_wallet_guid";
    private String externalWalletGuid;
    public static final String JSON_PROPERTY_EXTERNAL_BANK_ACCOUNT_GUID = "external_bank_account_guid";
    private String externalBankAccountGuid;
    public static final String JSON_PROPERTY_ONE_TIME_ADDRESS = "one_time_address";
    private PostOneTimeAddressBankModel oneTimeAddress;
    public static final String JSON_PROPERTY_EXPECTED_ERROR = "expected_error";
    private ExpectedErrorEnum expectedError;

    public PostTransferBankModel quoteGuid(String quoteGuid) {
        this.quoteGuid = quoteGuid;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The associated quote's identifier.")
    @JsonProperty(value="quote_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getQuoteGuid() {
        return this.quoteGuid;
    }

    @JsonProperty(value="quote_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setQuoteGuid(String quoteGuid) {
        this.quoteGuid = quoteGuid;
    }

    public PostTransferBankModel transferType(TransferTypeEnum transferType) {
        this.transferType = transferType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The type of transfer.")
    @JsonProperty(value="transfer_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TransferTypeEnum getTransferType() {
        return this.transferType;
    }

    @JsonProperty(value="transfer_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTransferType(TransferTypeEnum transferType) {
        this.transferType = transferType;
    }

    public PostTransferBankModel externalWalletGuid(String externalWalletGuid) {
        this.externalWalletGuid = externalWalletGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's external wallet's identifier.")
    @JsonProperty(value="external_wallet_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalWalletGuid() {
        return this.externalWalletGuid;
    }

    @JsonProperty(value="external_wallet_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalWalletGuid(String externalWalletGuid) {
        this.externalWalletGuid = externalWalletGuid;
    }

    public PostTransferBankModel externalBankAccountGuid(String externalBankAccountGuid) {
        this.externalBankAccountGuid = externalBankAccountGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer's 'plaid' or 'plaid_processor_token' external bank account's identifier.")
    @JsonProperty(value="external_bank_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalBankAccountGuid() {
        return this.externalBankAccountGuid;
    }

    @JsonProperty(value="external_bank_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalBankAccountGuid(String externalBankAccountGuid) {
        this.externalBankAccountGuid = externalBankAccountGuid;
    }

    public PostTransferBankModel oneTimeAddress(PostOneTimeAddressBankModel oneTimeAddress) {
        this.oneTimeAddress = oneTimeAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="one_time_address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PostOneTimeAddressBankModel getOneTimeAddress() {
        return this.oneTimeAddress;
    }

    @JsonProperty(value="one_time_address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOneTimeAddress(PostOneTimeAddressBankModel oneTimeAddress) {
        this.oneTimeAddress = oneTimeAddress;
    }

    public PostTransferBankModel expectedError(ExpectedErrorEnum expectedError) {
        this.expectedError = expectedError;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The optional expected error to simulate transfer failure.")
    @JsonProperty(value="expected_error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ExpectedErrorEnum getExpectedError() {
        return this.expectedError;
    }

    @JsonProperty(value="expected_error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpectedError(ExpectedErrorEnum expectedError) {
        this.expectedError = expectedError;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostTransferBankModel postTransfer = (PostTransferBankModel)o;
        return Objects.equals(this.quoteGuid, postTransfer.quoteGuid) && Objects.equals((Object)this.transferType, (Object)postTransfer.transferType) && Objects.equals(this.externalWalletGuid, postTransfer.externalWalletGuid) && Objects.equals(this.externalBankAccountGuid, postTransfer.externalBankAccountGuid) && Objects.equals(this.oneTimeAddress, postTransfer.oneTimeAddress) && Objects.equals((Object)this.expectedError, (Object)postTransfer.expectedError);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.quoteGuid, this.transferType, this.externalWalletGuid, this.externalBankAccountGuid, this.oneTimeAddress, this.expectedError});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostTransferBankModel {\n");
        sb.append("    quoteGuid: ").append(this.toIndentedString(this.quoteGuid)).append("\n");
        sb.append("    transferType: ").append(this.toIndentedString((Object)this.transferType)).append("\n");
        sb.append("    externalWalletGuid: ").append(this.toIndentedString(this.externalWalletGuid)).append("\n");
        sb.append("    externalBankAccountGuid: ").append(this.toIndentedString(this.externalBankAccountGuid)).append("\n");
        sb.append("    oneTimeAddress: ").append(this.toIndentedString(this.oneTimeAddress)).append("\n");
        sb.append("    expectedError: ").append(this.toIndentedString((Object)this.expectedError)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ExpectedErrorEnum {
        PENDING("pending"),
        IN_PROGRESS("in_progress"),
        COMPLETED("completed"),
        FAILED("failed"),
        CANCELLED("cancelled"),
        MANUAL_INTERVENTION("manual_intervention"),
        REVERSED("reversed");

        private String value;

        private ExpectedErrorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ExpectedErrorEnum fromValue(String value) {
            for (ExpectedErrorEnum b : ExpectedErrorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TransferTypeEnum {
        FUNDING("funding"),
        BOOK("book"),
        CRYPTO("crypto");

        private String value;

        private TransferTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TransferTypeEnum fromValue(String value) {
            for (TransferTypeEnum b : TransferTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

