/*
 * Cybrid Bank API
 * # Cybrid API documentation  Welcome to Cybrid, an all-in-one crypto platform that enables you to easily **build** and **launch** white-label crypto products or services.  In these documents, you'll find details on how our REST API operates and generally how our platform functions.  If you're looking for our UI SDK Widgets for Web or Mobile (iOS/Android), generated API clients, or demo applications, head over to our [Github repo](https://github.com/Cybrid-app).  💡 We recommend bookmarking the [Cybrid LinkTree](https://linktr.ee/cybridtechnologies) which contains many helpful links to platform resources.  ## Getting Started  This is Cybrid's public interactive API documentation, which allows you to fully test our APIs. If you'd like to use a different tool to exercise our APIs, you can download the [Open API 3.0 yaml](https://bank.sandbox.cybrid.app/api/schema/v1/swagger.yaml) for import.  If you're new to our APIs and the Cybrid Platform, follow the below guides to get set up and familiar with the platform:  1. [Understanding the Platform](https://kb.cybrid.xyz/understanding-the-platform) 2. [Getting Started in the Cybrid Sandbox](https://kb.cybrid.xyz/getting-started-guide) 3. [Getting Ready for Trading](https://kb.cybrid.xyz/getting-ready-for-trading) 4. [Running the Web Demo App](https://kb.cybrid.xyz/locally-running-the-web-demo-app) (or, alternatively, [Testing with Hosted Web Demo App](https://kb.cybrid.xyz/testing-with-hosted-web-demo-app))  In [Getting Started in the Cybrid Sandbox](https://kb.cybrid.xyz/getting-started-guide), we walk you through how to use the [Cybrid Sandbox](https://id.sandbox.cybrid.app/) to create a test bank and generate API keys. In [Getting Ready for Trading](https://kb.cybrid.xyz/getting-ready-for-trading), we walk through creating customers, customer identities, accounts, as well as executing quotes and trades.  If you've already run through the first two guides, you can follow the [Running the Web Demo App](https://kb.cybrid.xyz/locally-running-the-web-demo-app) guide to test our web SDK with your sandbox `bank` and `customer`.  ## Working with the Cybrid Platform  There are three primary ways you can interact with the Cybrid platform:  1. Directly via our RESTful API (this documentation) 2. Using our API clients available in a variety of languages ([Angular](https://github.com/Cybrid-app/cybrid-api-bank-angular), [Java](https://github.com/Cybrid-app/cybrid-api-bank-java), [Kotlin](https://github.com/Cybrid-app/cybrid-api-bank-kotlin), [Python](https://github.com/Cybrid-app/cybrid-api-bank-python), [Ruby](https://github.com/Cybrid-app/cybrid-api-bank-ruby), [Swift](https://github.com/Cybrid-app/cybrid-api-bank-swift) or [Typescript](https://github.com/Cybrid-app/cybrid-api-bank-typescript)) 3. Integrating a platform specific SDK ([Web](https://github.com/Cybrid-app/cybrid-sdk-web), [Android](https://github.com/Cybrid-app/cybrid-sdk-android), [iOS](https://github.com/Cybrid-app/cybrid-sdk-ios))  Our complete set of APIs allows you to manage resources across three distinct areas: your `Organization`, your `Banks` and your `Identities`. For most of your testing and interaction you'll be using the `Bank` API, which is where the majority of APIs reside.  *The complete set of APIs can be found on the following pages:*  | API                                                              | Description                                                 | |------------------------------------------------------------------|-------------------------------------------------------------| | [Organization API](https://organization.sandbox.cybrid.app/api/schema/swagger-ui)   | APIs to manage organizations                                | | [Bank API](https://bank.sandbox.cybrid.app/api/schema/swagger-ui)                   | APIs to manage banks (and all downstream customer activity) | | [Identities API](https://id.sandbox.cybrid.app/api/schema/swagger-ui)                       | APIs to manage organization and bank identities             |  For questions please contact [Support](mailto:support@cybrid.xyz) at any time for assistance, or contact the [Product Team](mailto:product@cybrid.xyz) for product suggestions.  ## Authenticating with the API  The Cybrid Platform uses OAuth 2.0 Bearer Tokens to authenticate requests to the platform. Credentials to create `Organization` and `Bank` tokens can be generated via the [Cybrid Sandbox](https://id.sandbox.cybrid.app). Access tokens can be generated for a `Customer` as well via the [Cybrid IdP](https://id.sandbox.cybrid.app) as well.  An `Organization` access token applies broadly to the whole Organization and all of its `Banks`, whereas, a `Bank` access token is specific to an individual Bank. `Customer` tokens, similarly, are scoped to a specific customer in a bank.  Both `Organization` and `Bank` tokens can be created using the OAuth Client Credential Grant flow. Each Organization and Bank has its own unique `Client ID` and `Secret` that allows for machine-to-machine authentication.  A `Bank` can then generate `Customer` access tokens via API using our [Identities API](https://id.sandbox.cybrid.app/api/schema/swagger-ui).  <font color=\"orange\">**⚠️ Never share your Client ID or Secret publicly or in your source code repository.**</font>  Your `Client ID` and `Secret` can be exchanged for a time-limited `Bearer Token` by interacting with the Cybrid Identity Provider or through interacting with the **Authorize** button in this document.  The following curl command can be used to quickly generate a `Bearer Token` for use in testing the API or demo applications.  ``` # Example request when using Bank credentials curl -X POST https://id.sandbox.cybrid.app/oauth/token -d '{     \"grant_type\": \"client_credentials\",     \"client_id\": \"<Your Client ID>\",     \"client_secret\": \"<Your Secret>\",     \"scope\": \"banks:read banks:write bank_applications:execute accounts:read accounts:execute customers:read customers:write customers:execute prices:read quotes:execute quotes:read trades:execute trades:read transfers:execute transfers:read rewards:execute rewards:read external_bank_accounts:read external_bank_accounts:write external_bank_accounts:execute external_wallets:read external_wallets:execute workflows:read workflows:execute deposit_addresses:read deposit_addresses:execute\"   }' -H \"Content-Type: application/json\"  # When using Organization credentials set `scope` to 'organizations:read organizations:write organization_applications:execute banks:read banks:write banks:execute bank_applications:execute users:execute customers:read accounts:read prices:read quotes:execute quotes:read trades:execute trades:read transfers:read transfers:execute external_bank_accounts:read external_wallets:read workflows:read deposit_addresses:read' ``` <font color=\"orange\">**⚠️ Note: The above curl will create a bearer token with full scope access. Delete scopes if you'd like to restrict access.**</font>  ## Authentication Scopes  The Cybrid platform supports the use of scopes to control the level of access a token is limited to. Scopes do not grant access to resources; instead, they provide limits, in support of the least privilege principal.  The following scopes are available on the platform and can be requested when generating either an Organization, Bank or Customer token. Generally speaking, the _Read_ scope is required to read and list resources, the _Write_ scope is required to update a resource and the _Execute_ scope is required to create a resource.  | Resource              | Read scope (Token Type)                                    | Write scope (Token Type)                      | Execute scope (Token Type)                       | |-----------------------|------------------------------------------------------------|-----------------------------------------------|--------------------------------------------------| | Account               | accounts:read (Organization, Bank, Customer)               |                                               | accounts:execute (Bank, Customer)                | | Bank                  | banks:read (Organization, Bank)                            | banks:write (Organization, Bank)              | banks:execute (Organization)                     | | Customer              | customers:read (Organization, Bank, Customer)              | customers:write (Bank, Customer)              | customers:execute (Bank)                         | | Deposit Address       | deposit_addresses:read (Organization, Bank, Customer)      | deposit_addresses:write (Bank, Customer)      | deposit_addresses:execute (Bank, Customer)       | | External Bank Account | external_bank_accounts:read (Organization, Bank, Customer) | external_bank_accounts:write (Bank, Customer) | external_bank_accounts:execute (Bank, Customer)  | | External Wallet       | external_wallet:read (Organization, Bank, Customer)        |                                               | external_wallet:execute (Bank, Customer)         | | Organization          | organizations:read (Organization)                          | organizations:write (Organization)            |                                                  | | User                  |                                                            |                                               | users:execute (Organization)                     | | Price                 | prices:read (Bank, Customer)                               |                                               |                                                  | | Quote                 | quotes:read (Organization, Bank, Customer)                 |                                               | quotes:execute (Organization, Bank, Customer)    | | Reward                | rewards:read (Bank, Customer)                              |                                               | rewards:execute (Bank)                           | | Trade                 | trades:read (Organization, Bank, Customer)                 |                                               | trades:execute (Organization, Bank, Customer)    | | Transfer              | transfers:read (Organization, Bank, Customer)              |                                               | transfers:execute (Organization, Bank, Customer) | | Workflow              | workflows:read (Organization, Bank, Customer)              |                                               | workflows:execute (Bank, Customer)               |  ## Available Endpoints  The available APIs for the [Identity](https://id.sandbox.cybrid.app/api/schema/swagger-ui), [Organization](https://organization.sandbox.cybrid.app/api/schema/swagger-ui) and [Bank](https://bank.sandbox.cybrid.app/api/schema/swagger-ui) API services are listed below:  | API Service  | Model                | API Endpoint Path              | Description                                                                                       | |--------------|----------------------|--------------------------------|---------------------------------------------------------------------------------------------------| | Identity     | Bank                 | /api/bank_applications         | Create and list banks                                                                             | | Identity     | CustomerToken        | /api/customer_tokens           | Create customer JWT access tokens                                                                 | | Identity     | Organization         | /api/organization_applications | Create and list organizations                                                                     | | Identity     | Organization         | /api/users                     | Create an organization user                                                                       | | Organization | Organization         | /api/organizations             | APIs to retrieve and update organization name                                                     | | Bank         | Account              | /api/accounts                  | Create and list accounts, which hold a specific asset for a customers                             | | Bank         | Asset                | /api/assets                    | Get a list of assets supported by the platform (ex: BTC, ETH)                                     | | Bank         | Bank                 | /api/banks                     | Create, update and list banks, the parent to customers, accounts, etc                             | | Bank         | Customer             | /api/customers                 | Create and list customers                                                                         | | Bank         | DepositAddress       | /api/deposit_addresses         | Create, get and list deposit addresses                                                            | | Bank         | ExternalBankAccount  | /api/external_bank_accounts    | Create, get and list external bank accounts, which connect customer bank accounts to the platform | | Bank         | ExternalWallet       | /api/external_wallets          | Create, get, list and delete external wallets, which connect customer wallets to the platform     | | Bank         | IdentityVerification | /api/identity_verifications    | Create and list identity verifications, which are performed on customers for KYC                  | | Bank         | Price                | /api/prices                    | Get the current prices for assets on the platform                                                 | | Bank         | Quote                | /api/quotes                    | Create and list quotes, which are required to execute trades                                      | | Bank         | Reward               | /api/rewards                   | Create a new reward (automates quote/trade for simplicity)                                        | | Bank         | Symbol               | /api/symbols                   | Get a list of symbols supported for trade (ex: BTC-USD)                                           | | Bank         | Trade                | /api/trades                    | Create and list trades, which buy or sell cryptocurrency                                          | | Bank         | Transfer             | /api/transfers                 | Create, get and list transfers (e.g., funding, book)                                              | | Bank         | Workflow             | /api/workflows                 | Create, get and list workflows                                                                    |  ## Understanding Object Models & Endpoints  **Organizations**  An `Organization` is meant to represent the organization partnering with Cybrid to use our platform.  An `Organization` typically does not directly interact with `customers`. Instead, an Organization has one or more `banks`, which encompass the financial service offerings of the platform.  **Banks**  A `Bank` is owned by an `Organization` and can be thought of as an environment or container for `customers` and product offerings. Banks are created in either `Sandbox` or `Production` mode, where `Sandbox` is the environment that you would test, prototype and build in prior to moving to `Production`.  An `Organization` can have multiple `banks`, in either `Sandbox` or `Production` environments. A `Sandbox Bank` will be backed by stubbed data and process flows. For instance, funding source transfer processes as well as trades will be simulated rather than performed, however asset prices are representative of real-world values. You have an unlimited amount of simulated fiat currency for testing purposes.  **Customers**  `Customers` represent your banking users on the platform. At present, we offer support for `Individuals` as Customers.  `Customers` must be verified (i.e., KYC'd) in our system before they can play any part on the platform, which means they must have an associated and a passing `Identity Verification`. See the Identity Verifications section for more details on how a customer can be verified.  `Customers` must also have an `Account` to be able to transact, in the desired asset class. See the Accounts APIs for more details on setting up accounts for the customer. 
 *
 * The version of the OpenAPI document: v0.92.5
 * Contact: support@cybrid.app
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package app.cybrid.cybrid_api_bank.client.model;

import java.util.Objects;
import java.util.Arrays;
import app.cybrid.cybrid_api_bank.client.model.TransferDestinationAccountBankModel;
import app.cybrid.cybrid_api_bank.client.model.TransferSourceAccountBankModel;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * TransferBankModel
 */
@JsonPropertyOrder({
  TransferBankModel.JSON_PROPERTY_GUID,
  TransferBankModel.JSON_PROPERTY_TRANSFER_TYPE,
  TransferBankModel.JSON_PROPERTY_BANK_GUID,
  TransferBankModel.JSON_PROPERTY_CUSTOMER_GUID,
  TransferBankModel.JSON_PROPERTY_QUOTE_GUID,
  TransferBankModel.JSON_PROPERTY_EXTERNAL_BANK_ACCOUNT_GUID,
  TransferBankModel.JSON_PROPERTY_ASSET,
  TransferBankModel.JSON_PROPERTY_SIDE,
  TransferBankModel.JSON_PROPERTY_STATE,
  TransferBankModel.JSON_PROPERTY_FAILURE_CODE,
  TransferBankModel.JSON_PROPERTY_AMOUNT,
  TransferBankModel.JSON_PROPERTY_ESTIMATED_AMOUNT,
  TransferBankModel.JSON_PROPERTY_FEE,
  TransferBankModel.JSON_PROPERTY_ESTIMATED_NETWORK_FEE,
  TransferBankModel.JSON_PROPERTY_NETWORK_FEE,
  TransferBankModel.JSON_PROPERTY_NETWORK_FEE_ASSET,
  TransferBankModel.JSON_PROPERTY_NETWORK_FEE_LIABILITY_AMOUNT,
  TransferBankModel.JSON_PROPERTY_NETWORK_FEE_LIABILITY_AMOUNT_ASSET,
  TransferBankModel.JSON_PROPERTY_TXN_HASH,
  TransferBankModel.JSON_PROPERTY_SOURCE_ACCOUNT,
  TransferBankModel.JSON_PROPERTY_DESTINATION_ACCOUNT,
  TransferBankModel.JSON_PROPERTY_CREATED_AT,
  TransferBankModel.JSON_PROPERTY_UPDATED_AT
})
@JsonTypeName("Transfer")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-09-11T12:01:34.462801Z[Etc/UTC]")
public class TransferBankModel {
  public static final String JSON_PROPERTY_GUID = "guid";
  private String guid;

  /**
   * The type of transfer.
   */
  public enum TransferTypeEnum {
    SAVINGS("savings"),
    
    FUNDING("funding"),
    
    BOOK("book"),
    
    CRYPTO("crypto"),
    
    INTERNAL_BANK_REBALANCE("internal_bank_rebalance"),
    
    INTERNAL_WALLET_REBALANCE("internal_wallet_rebalance"),
    
    INSTANT_FUNDING("instant_funding");

    private String value;

    TransferTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TransferTypeEnum fromValue(String value) {
      for (TransferTypeEnum b : TransferTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TRANSFER_TYPE = "transfer_type";
  private TransferTypeEnum transferType;

  public static final String JSON_PROPERTY_BANK_GUID = "bank_guid";
  private String bankGuid;

  public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
  private String customerGuid;

  public static final String JSON_PROPERTY_QUOTE_GUID = "quote_guid";
  private String quoteGuid;

  public static final String JSON_PROPERTY_EXTERNAL_BANK_ACCOUNT_GUID = "external_bank_account_guid";
  private String externalBankAccountGuid;

  public static final String JSON_PROPERTY_ASSET = "asset";
  private String asset;

  /**
   * The direction of the quote: &#39;deposit&#39; or &#39;withdrawal&#39;.
   */
  public enum SideEnum {
    DEPOSIT("deposit"),
    
    WITHDRAWAL("withdrawal");

    private String value;

    SideEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SideEnum fromValue(String value) {
      for (SideEnum b : SideEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SIDE = "side";
  private SideEnum side;

  /**
   * The transfer&#39;s state
   */
  public enum StateEnum {
    STORING("storing"),
    
    PENDING("pending"),
    
    COMPLETED("completed"),
    
    FAILED("failed");

    private String value;

    StateEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StateEnum fromValue(String value) {
      for (StateEnum b : StateEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATE = "state";
  private StateEnum state;

  public static final String JSON_PROPERTY_FAILURE_CODE = "failure_code";
  private String failureCode;

  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private java.math.BigInteger amount;

  public static final String JSON_PROPERTY_ESTIMATED_AMOUNT = "estimated_amount";
  private java.math.BigInteger estimatedAmount;

  public static final String JSON_PROPERTY_FEE = "fee";
  private java.math.BigInteger fee;

  public static final String JSON_PROPERTY_ESTIMATED_NETWORK_FEE = "estimated_network_fee";
  private java.math.BigInteger estimatedNetworkFee;

  public static final String JSON_PROPERTY_NETWORK_FEE = "network_fee";
  private java.math.BigInteger networkFee;

  public static final String JSON_PROPERTY_NETWORK_FEE_ASSET = "network_fee_asset";
  private String networkFeeAsset;

  public static final String JSON_PROPERTY_NETWORK_FEE_LIABILITY_AMOUNT = "network_fee_liability_amount";
  private java.math.BigInteger networkFeeLiabilityAmount;

  public static final String JSON_PROPERTY_NETWORK_FEE_LIABILITY_AMOUNT_ASSET = "network_fee_liability_amount_asset";
  private String networkFeeLiabilityAmountAsset;

  public static final String JSON_PROPERTY_TXN_HASH = "txn_hash";
  private String txnHash;

  public static final String JSON_PROPERTY_SOURCE_ACCOUNT = "source_account";
  private TransferSourceAccountBankModel sourceAccount;

  public static final String JSON_PROPERTY_DESTINATION_ACCOUNT = "destination_account";
  private TransferDestinationAccountBankModel destinationAccount;

  public static final String JSON_PROPERTY_CREATED_AT = "created_at";
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
  private OffsetDateTime updatedAt;

  public TransferBankModel() { 
  }

  public TransferBankModel guid(String guid) {
    
    this.guid = guid;
    return this;
  }

   /**
   * Auto-generated unique identifier for the transfer.
   * @return guid
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Auto-generated unique identifier for the transfer.")
  @JsonProperty(JSON_PROPERTY_GUID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getGuid() {
    return guid;
  }


  @JsonProperty(JSON_PROPERTY_GUID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGuid(String guid) {
    this.guid = guid;
  }


  public TransferBankModel transferType(TransferTypeEnum transferType) {
    
    this.transferType = transferType;
    return this;
  }

   /**
   * The type of transfer.
   * @return transferType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The type of transfer.")
  @JsonProperty(JSON_PROPERTY_TRANSFER_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TransferTypeEnum getTransferType() {
    return transferType;
  }


  @JsonProperty(JSON_PROPERTY_TRANSFER_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransferType(TransferTypeEnum transferType) {
    this.transferType = transferType;
  }


  public TransferBankModel bankGuid(String bankGuid) {
    
    this.bankGuid = bankGuid;
    return this;
  }

   /**
   * The associated bank&#39;s identifier.
   * @return bankGuid
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The associated bank's identifier.")
  @JsonProperty(JSON_PROPERTY_BANK_GUID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBankGuid() {
    return bankGuid;
  }


  @JsonProperty(JSON_PROPERTY_BANK_GUID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBankGuid(String bankGuid) {
    this.bankGuid = bankGuid;
  }


  public TransferBankModel customerGuid(String customerGuid) {
    
    this.customerGuid = customerGuid;
    return this;
  }

   /**
   * The associated customer&#39;s identifier.
   * @return customerGuid
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The associated customer's identifier.")
  @JsonProperty(JSON_PROPERTY_CUSTOMER_GUID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCustomerGuid() {
    return customerGuid;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOMER_GUID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomerGuid(String customerGuid) {
    this.customerGuid = customerGuid;
  }


  public TransferBankModel quoteGuid(String quoteGuid) {
    
    this.quoteGuid = quoteGuid;
    return this;
  }

   /**
   * The associated quote&#39;s identifier.
   * @return quoteGuid
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The associated quote's identifier.")
  @JsonProperty(JSON_PROPERTY_QUOTE_GUID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getQuoteGuid() {
    return quoteGuid;
  }


  @JsonProperty(JSON_PROPERTY_QUOTE_GUID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setQuoteGuid(String quoteGuid) {
    this.quoteGuid = quoteGuid;
  }


  public TransferBankModel externalBankAccountGuid(String externalBankAccountGuid) {
    
    this.externalBankAccountGuid = externalBankAccountGuid;
    return this;
  }

   /**
   * The associated external bank account&#39;s identifier.
   * @return externalBankAccountGuid
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The associated external bank account's identifier.")
  @JsonProperty(JSON_PROPERTY_EXTERNAL_BANK_ACCOUNT_GUID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalBankAccountGuid() {
    return externalBankAccountGuid;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_BANK_ACCOUNT_GUID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalBankAccountGuid(String externalBankAccountGuid) {
    this.externalBankAccountGuid = externalBankAccountGuid;
  }


  public TransferBankModel asset(String asset) {
    
    this.asset = asset;
    return this;
  }

   /**
   * The asset the transfer is related to, e.g., USD.
   * @return asset
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The asset the transfer is related to, e.g., USD.")
  @JsonProperty(JSON_PROPERTY_ASSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAsset() {
    return asset;
  }


  @JsonProperty(JSON_PROPERTY_ASSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAsset(String asset) {
    this.asset = asset;
  }


  public TransferBankModel side(SideEnum side) {
    
    this.side = side;
    return this;
  }

   /**
   * The direction of the quote: &#39;deposit&#39; or &#39;withdrawal&#39;.
   * @return side
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The direction of the quote: 'deposit' or 'withdrawal'.")
  @JsonProperty(JSON_PROPERTY_SIDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SideEnum getSide() {
    return side;
  }


  @JsonProperty(JSON_PROPERTY_SIDE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSide(SideEnum side) {
    this.side = side;
  }


  public TransferBankModel state(StateEnum state) {
    
    this.state = state;
    return this;
  }

   /**
   * The transfer&#39;s state
   * @return state
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The transfer's state")
  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StateEnum getState() {
    return state;
  }


  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(StateEnum state) {
    this.state = state;
  }


  public TransferBankModel failureCode(String failureCode) {
    
    this.failureCode = failureCode;
    return this;
  }

   /**
   * The failure code for failed transfers.
   * @return failureCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The failure code for failed transfers.")
  @JsonProperty(JSON_PROPERTY_FAILURE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFailureCode() {
    return failureCode;
  }


  @JsonProperty(JSON_PROPERTY_FAILURE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFailureCode(String failureCode) {
    this.failureCode = failureCode;
  }


  public TransferBankModel amount(java.math.BigInteger amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * The actual amount in base units of the asset.
   * @return amount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The actual amount in base units of the asset.")
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.math.BigInteger getAmount() {
    return amount;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmount(java.math.BigInteger amount) {
    this.amount = amount;
  }


  public TransferBankModel estimatedAmount(java.math.BigInteger estimatedAmount) {
    
    this.estimatedAmount = estimatedAmount;
    return this;
  }

   /**
   * The estimated amount in base units of the asset.
   * @return estimatedAmount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The estimated amount in base units of the asset.")
  @JsonProperty(JSON_PROPERTY_ESTIMATED_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.math.BigInteger getEstimatedAmount() {
    return estimatedAmount;
  }


  @JsonProperty(JSON_PROPERTY_ESTIMATED_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEstimatedAmount(java.math.BigInteger estimatedAmount) {
    this.estimatedAmount = estimatedAmount;
  }


  public TransferBankModel fee(java.math.BigInteger fee) {
    
    this.fee = fee;
    return this;
  }

   /**
   * The fee associated with the transfer.
   * @return fee
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The fee associated with the transfer.")
  @JsonProperty(JSON_PROPERTY_FEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.math.BigInteger getFee() {
    return fee;
  }


  @JsonProperty(JSON_PROPERTY_FEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFee(java.math.BigInteger fee) {
    this.fee = fee;
  }


  public TransferBankModel estimatedNetworkFee(java.math.BigInteger estimatedNetworkFee) {
    
    this.estimatedNetworkFee = estimatedNetworkFee;
    return this;
  }

   /**
   * The estimated network fee in base units of network_fee_asset. Only present on &#x60;crypto&#x60; transfers.
   * @return estimatedNetworkFee
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The estimated network fee in base units of network_fee_asset. Only present on `crypto` transfers.")
  @JsonProperty(JSON_PROPERTY_ESTIMATED_NETWORK_FEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.math.BigInteger getEstimatedNetworkFee() {
    return estimatedNetworkFee;
  }


  @JsonProperty(JSON_PROPERTY_ESTIMATED_NETWORK_FEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEstimatedNetworkFee(java.math.BigInteger estimatedNetworkFee) {
    this.estimatedNetworkFee = estimatedNetworkFee;
  }


  public TransferBankModel networkFee(java.math.BigInteger networkFee) {
    
    this.networkFee = networkFee;
    return this;
  }

   /**
   * The actual network fee in base units of network_fee_asset. Only present on &#x60;crypto&#x60; transfers that have successfully completed.
   * @return networkFee
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The actual network fee in base units of network_fee_asset. Only present on `crypto` transfers that have successfully completed.")
  @JsonProperty(JSON_PROPERTY_NETWORK_FEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.math.BigInteger getNetworkFee() {
    return networkFee;
  }


  @JsonProperty(JSON_PROPERTY_NETWORK_FEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetworkFee(java.math.BigInteger networkFee) {
    this.networkFee = networkFee;
  }


  public TransferBankModel networkFeeAsset(String networkFeeAsset) {
    
    this.networkFeeAsset = networkFeeAsset;
    return this;
  }

   /**
   * The asset code of the network fee. Only present on &#x60;crypto&#x60; transfers that have successfully completed.
   * @return networkFeeAsset
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The asset code of the network fee. Only present on `crypto` transfers that have successfully completed.")
  @JsonProperty(JSON_PROPERTY_NETWORK_FEE_ASSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNetworkFeeAsset() {
    return networkFeeAsset;
  }


  @JsonProperty(JSON_PROPERTY_NETWORK_FEE_ASSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetworkFeeAsset(String networkFeeAsset) {
    this.networkFeeAsset = networkFeeAsset;
  }


  public TransferBankModel networkFeeLiabilityAmount(java.math.BigInteger networkFeeLiabilityAmount) {
    
    this.networkFeeLiabilityAmount = networkFeeLiabilityAmount;
    return this;
  }

   /**
   * The equivalent fiat network fee in base units of network_fee_liability_amount_asset. Only present on &#x60;crypto&#x60; transfers that have successfully completed.
   * @return networkFeeLiabilityAmount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The equivalent fiat network fee in base units of network_fee_liability_amount_asset. Only present on `crypto` transfers that have successfully completed.")
  @JsonProperty(JSON_PROPERTY_NETWORK_FEE_LIABILITY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.math.BigInteger getNetworkFeeLiabilityAmount() {
    return networkFeeLiabilityAmount;
  }


  @JsonProperty(JSON_PROPERTY_NETWORK_FEE_LIABILITY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetworkFeeLiabilityAmount(java.math.BigInteger networkFeeLiabilityAmount) {
    this.networkFeeLiabilityAmount = networkFeeLiabilityAmount;
  }


  public TransferBankModel networkFeeLiabilityAmountAsset(String networkFeeLiabilityAmountAsset) {
    
    this.networkFeeLiabilityAmountAsset = networkFeeLiabilityAmountAsset;
    return this;
  }

   /**
   * The fiat asset the network_fee_liability_amount is denominated in. Only present on &#x60;crypto&#x60; transfers that have successfully completed.
   * @return networkFeeLiabilityAmountAsset
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The fiat asset the network_fee_liability_amount is denominated in. Only present on `crypto` transfers that have successfully completed.")
  @JsonProperty(JSON_PROPERTY_NETWORK_FEE_LIABILITY_AMOUNT_ASSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNetworkFeeLiabilityAmountAsset() {
    return networkFeeLiabilityAmountAsset;
  }


  @JsonProperty(JSON_PROPERTY_NETWORK_FEE_LIABILITY_AMOUNT_ASSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetworkFeeLiabilityAmountAsset(String networkFeeLiabilityAmountAsset) {
    this.networkFeeLiabilityAmountAsset = networkFeeLiabilityAmountAsset;
  }


  public TransferBankModel txnHash(String txnHash) {
    
    this.txnHash = txnHash;
    return this;
  }

   /**
   * The hash of the blockchain transaction
   * @return txnHash
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The hash of the blockchain transaction")
  @JsonProperty(JSON_PROPERTY_TXN_HASH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTxnHash() {
    return txnHash;
  }


  @JsonProperty(JSON_PROPERTY_TXN_HASH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTxnHash(String txnHash) {
    this.txnHash = txnHash;
  }


  public TransferBankModel sourceAccount(TransferSourceAccountBankModel sourceAccount) {
    
    this.sourceAccount = sourceAccount;
    return this;
  }

   /**
   * Get sourceAccount
   * @return sourceAccount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TransferSourceAccountBankModel getSourceAccount() {
    return sourceAccount;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceAccount(TransferSourceAccountBankModel sourceAccount) {
    this.sourceAccount = sourceAccount;
  }


  public TransferBankModel destinationAccount(TransferDestinationAccountBankModel destinationAccount) {
    
    this.destinationAccount = destinationAccount;
    return this;
  }

   /**
   * Get destinationAccount
   * @return destinationAccount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DESTINATION_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TransferDestinationAccountBankModel getDestinationAccount() {
    return destinationAccount;
  }


  @JsonProperty(JSON_PROPERTY_DESTINATION_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDestinationAccount(TransferDestinationAccountBankModel destinationAccount) {
    this.destinationAccount = destinationAccount;
  }


  public TransferBankModel createdAt(OffsetDateTime createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

   /**
   * ISO8601 datetime the bank was created at.
   * @return createdAt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "ISO8601 datetime the bank was created at.")
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public TransferBankModel updatedAt(OffsetDateTime updatedAt) {
    
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * ISO8601 datetime the trade was last updated at.
   * @return updatedAt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "ISO8601 datetime the trade was last updated at.")
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }


  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TransferBankModel transfer = (TransferBankModel) o;
    return Objects.equals(this.guid, transfer.guid) &&
        Objects.equals(this.transferType, transfer.transferType) &&
        Objects.equals(this.bankGuid, transfer.bankGuid) &&
        Objects.equals(this.customerGuid, transfer.customerGuid) &&
        Objects.equals(this.quoteGuid, transfer.quoteGuid) &&
        Objects.equals(this.externalBankAccountGuid, transfer.externalBankAccountGuid) &&
        Objects.equals(this.asset, transfer.asset) &&
        Objects.equals(this.side, transfer.side) &&
        Objects.equals(this.state, transfer.state) &&
        Objects.equals(this.failureCode, transfer.failureCode) &&
        Objects.equals(this.amount, transfer.amount) &&
        Objects.equals(this.estimatedAmount, transfer.estimatedAmount) &&
        Objects.equals(this.fee, transfer.fee) &&
        Objects.equals(this.estimatedNetworkFee, transfer.estimatedNetworkFee) &&
        Objects.equals(this.networkFee, transfer.networkFee) &&
        Objects.equals(this.networkFeeAsset, transfer.networkFeeAsset) &&
        Objects.equals(this.networkFeeLiabilityAmount, transfer.networkFeeLiabilityAmount) &&
        Objects.equals(this.networkFeeLiabilityAmountAsset, transfer.networkFeeLiabilityAmountAsset) &&
        Objects.equals(this.txnHash, transfer.txnHash) &&
        Objects.equals(this.sourceAccount, transfer.sourceAccount) &&
        Objects.equals(this.destinationAccount, transfer.destinationAccount) &&
        Objects.equals(this.createdAt, transfer.createdAt) &&
        Objects.equals(this.updatedAt, transfer.updatedAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(guid, transferType, bankGuid, customerGuid, quoteGuid, externalBankAccountGuid, asset, side, state, failureCode, amount, estimatedAmount, fee, estimatedNetworkFee, networkFee, networkFeeAsset, networkFeeLiabilityAmount, networkFeeLiabilityAmountAsset, txnHash, sourceAccount, destinationAccount, createdAt, updatedAt);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TransferBankModel {\n");
    sb.append("    guid: ").append(toIndentedString(guid)).append("\n");
    sb.append("    transferType: ").append(toIndentedString(transferType)).append("\n");
    sb.append("    bankGuid: ").append(toIndentedString(bankGuid)).append("\n");
    sb.append("    customerGuid: ").append(toIndentedString(customerGuid)).append("\n");
    sb.append("    quoteGuid: ").append(toIndentedString(quoteGuid)).append("\n");
    sb.append("    externalBankAccountGuid: ").append(toIndentedString(externalBankAccountGuid)).append("\n");
    sb.append("    asset: ").append(toIndentedString(asset)).append("\n");
    sb.append("    side: ").append(toIndentedString(side)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    failureCode: ").append(toIndentedString(failureCode)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    estimatedAmount: ").append(toIndentedString(estimatedAmount)).append("\n");
    sb.append("    fee: ").append(toIndentedString(fee)).append("\n");
    sb.append("    estimatedNetworkFee: ").append(toIndentedString(estimatedNetworkFee)).append("\n");
    sb.append("    networkFee: ").append(toIndentedString(networkFee)).append("\n");
    sb.append("    networkFeeAsset: ").append(toIndentedString(networkFeeAsset)).append("\n");
    sb.append("    networkFeeLiabilityAmount: ").append(toIndentedString(networkFeeLiabilityAmount)).append("\n");
    sb.append("    networkFeeLiabilityAmountAsset: ").append(toIndentedString(networkFeeLiabilityAmountAsset)).append("\n");
    sb.append("    txnHash: ").append(toIndentedString(txnHash)).append("\n");
    sb.append("    sourceAccount: ").append(toIndentedString(sourceAccount)).append("\n");
    sb.append("    destinationAccount: ").append(toIndentedString(destinationAccount)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

