/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_id.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.annotations.ApiModelProperty;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

@JsonPropertyOrder(value={"customer_guid", "scopes"})
@JsonTypeName(value="PostCustomerToken")
public class PostCustomerTokenIdpModel {
    public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
    private String customerGuid;
    public static final String JSON_PROPERTY_SCOPES = "scopes";
    private Set<ScopesEnum> scopes = new LinkedHashSet<ScopesEnum>();

    public PostCustomerTokenIdpModel customerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Customer guid the access token is being generated for.")
    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCustomerGuid() {
        return this.customerGuid;
    }

    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCustomerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
    }

    public PostCustomerTokenIdpModel scopes(Set<ScopesEnum> scopes) {
        this.scopes = scopes;
        return this;
    }

    public PostCustomerTokenIdpModel addScopesItem(ScopesEnum scopesItem) {
        this.scopes.add(scopesItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="List of the scopes requested for the access token.")
    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Set<ScopesEnum> getScopes() {
        return this.scopes;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setScopes(Set<ScopesEnum> scopes) {
        this.scopes = scopes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostCustomerTokenIdpModel postCustomerToken = (PostCustomerTokenIdpModel)o;
        return Objects.equals(this.customerGuid, postCustomerToken.customerGuid) && Objects.equals(this.scopes, postCustomerToken.scopes);
    }

    public int hashCode() {
        return Objects.hash(this.customerGuid, this.scopes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostCustomerTokenIdpModel {\n");
        sb.append("    customerGuid: ").append(this.toIndentedString(this.customerGuid)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ScopesEnum {
        CUSTOMERS_READ("customers:read"),
        CUSTOMERS_WRITE("customers:write"),
        ACCOUNTS_READ("accounts:read"),
        ACCOUNTS_EXECUTE("accounts:execute"),
        PRICES_READ("prices:read"),
        QUOTES_READ("quotes:read"),
        QUOTES_EXECUTE("quotes:execute"),
        TRADES_READ("trades:read"),
        TRADES_EXECUTE("trades:execute"),
        TRANSFERS_READ("transfers:read"),
        TRANSFERS_EXECUTE("transfers:execute"),
        EXTERNAL_BANK_ACCOUNTS_READ("external_bank_accounts:read"),
        EXTERNAL_BANK_ACCOUNTS_WRITE("external_bank_accounts:write"),
        EXTERNAL_BANK_ACCOUNTS_EXECUTE("external_bank_accounts:execute"),
        EXTERNAL_WALLETS_READ("external_wallets:read"),
        EXTERNAL_WALLETS_EXECUTE("external_wallets:execute"),
        WORKFLOWS_READ("workflows:read"),
        WORKFLOWS_EXECUTE("workflows:execute"),
        DEPOSIT_ADDRESSES_READ("deposit_addresses:read"),
        DEPOSIT_ADDRESSES_EXECUTE("deposit_addresses:execute"),
        DEPOSIT_BANK_ACCOUNTS_READ("deposit_bank_accounts:read"),
        DEPOSIT_BANK_ACCOUNTS_EXECUTE("deposit_bank_accounts:execute");

        private String value;

        private ScopesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ScopesEnum fromValue(String value) {
            for (ScopesEnum b : ScopesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

