/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_id.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"guid", "username", "email", "allowed_scopes", "created_at", "updated_at"})
@JsonTypeName(value="User")
public class UserIdpModel {
    public static final String JSON_PROPERTY_GUID = "guid";
    private String guid;
    public static final String JSON_PROPERTY_USERNAME = "username";
    private String username;
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_ALLOWED_SCOPES = "allowed_scopes";
    private JsonNullable<Set<AllowedScopesEnum>> allowedScopes = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private OffsetDateTime updatedAt;

    public UserIdpModel guid(String guid) {
        this.guid = guid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Auto-generated unique identifier for the user.")
    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public UserIdpModel username(String username) {
        this.username = username;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user's username.")
    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUsername(String username) {
        this.username = username;
    }

    public UserIdpModel email(String email) {
        this.email = email;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user's email address.")
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmail(String email) {
        this.email = email;
    }

    public UserIdpModel allowedScopes(Set<AllowedScopesEnum> allowedScopes) {
        this.allowedScopes = JsonNullable.of(allowedScopes);
        return this;
    }

    public UserIdpModel addAllowedScopesItem(AllowedScopesEnum allowedScopesItem) {
        if (this.allowedScopes == null || !this.allowedScopes.isPresent()) {
            this.allowedScopes = JsonNullable.of(new LinkedHashSet());
        }
        try {
            ((Set)this.allowedScopes.get()).add(allowedScopesItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The list of scopes that the user is allowed to request.")
    @JsonIgnore
    public Set<AllowedScopesEnum> getAllowedScopes() {
        return (Set)this.allowedScopes.orElse(null);
    }

    @JsonProperty(value="allowed_scopes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Set<AllowedScopesEnum>> getAllowedScopes_JsonNullable() {
        return this.allowedScopes;
    }

    @JsonProperty(value="allowed_scopes")
    public void setAllowedScopes_JsonNullable(JsonNullable<Set<AllowedScopesEnum>> allowedScopes) {
        this.allowedScopes = allowedScopes;
    }

    public void setAllowedScopes(Set<AllowedScopesEnum> allowedScopes) {
        this.allowedScopes = JsonNullable.of(allowedScopes);
    }

    public UserIdpModel createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was created at.")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public UserIdpModel updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was last updated at.")
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserIdpModel user = (UserIdpModel)o;
        return Objects.equals(this.guid, user.guid) && Objects.equals(this.username, user.username) && Objects.equals(this.email, user.email) && UserIdpModel.equalsNullable(this.allowedScopes, user.allowedScopes) && Objects.equals(this.createdAt, user.createdAt) && Objects.equals(this.updatedAt, user.updatedAt);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.guid, this.username, this.email, UserIdpModel.hashCodeNullable(this.allowedScopes), this.createdAt, this.updatedAt);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserIdpModel {\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    allowedScopes: ").append(this.toIndentedString(this.allowedScopes)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AllowedScopesEnum {
        ORGANIZATIONS_READ("organizations:read"),
        ORGANIZATIONS_WRITE("organizations:write"),
        ORGANIZATION_APPLICATIONS_EXECUTE("organization_applications:execute"),
        BANKS_READ("banks:read"),
        BANKS_WRITE("banks:write"),
        BANKS_EXECUTE("banks:execute"),
        BANK_APPLICATIONS_EXECUTE("bank_applications:execute"),
        USERS_READ("users:read"),
        USERS_EXECUTE("users:execute"),
        ACCOUNTS_READ("accounts:read"),
        ACCOUNTS_EXECUTE("accounts:execute"),
        COUNTERPARTIES_READ("counterparties:read"),
        COUNTERPARTIES_PII_READ("counterparties:pii:read"),
        COUNTERPARTIES_WRITE("counterparties:write"),
        COUNTERPARTIES_EXECUTE("counterparties:execute"),
        CUSTOMERS_READ("customers:read"),
        CUSTOMERS_PII_READ("customers:pii:read"),
        CUSTOMERS_WRITE("customers:write"),
        CUSTOMERS_EXECUTE("customers:execute"),
        PRICES_READ("prices:read"),
        QUOTES_EXECUTE("quotes:execute"),
        QUOTES_READ("quotes:read"),
        TRADES_EXECUTE("trades:execute"),
        TRADES_READ("trades:read"),
        TRANSFERS_EXECUTE("transfers:execute"),
        TRANSFERS_READ("transfers:read"),
        TRANSFERS_WRITE("transfers:write"),
        EXTERNAL_BANK_ACCOUNTS_READ("external_bank_accounts:read"),
        EXTERNAL_BANK_ACCOUNTS_PII_READ("external_bank_accounts:pii:read"),
        EXTERNAL_BANK_ACCOUNTS_WRITE("external_bank_accounts:write"),
        EXTERNAL_BANK_ACCOUNTS_EXECUTE("external_bank_accounts:execute"),
        EXTERNAL_WALLETS_READ("external_wallets:read"),
        EXTERNAL_WALLETS_EXECUTE("external_wallets:execute"),
        WORKFLOWS_READ("workflows:read"),
        WORKFLOWS_EXECUTE("workflows:execute"),
        DEPOSIT_ADDRESSES_READ("deposit_addresses:read"),
        DEPOSIT_ADDRESSES_EXECUTE("deposit_addresses:execute"),
        DEPOSIT_BANK_ACCOUNTS_READ("deposit_bank_accounts:read"),
        DEPOSIT_BANK_ACCOUNTS_EXECUTE("deposit_bank_accounts:execute"),
        INVOICES_READ("invoices:read"),
        INVOICES_WRITE("invoices:write"),
        INVOICES_EXECUTE("invoices:execute"),
        SUBSCRIPTIONS_READ("subscriptions:read"),
        SUBSCRIPTIONS_WRITE("subscriptions:write"),
        SUBSCRIPTIONS_EXECUTE("subscriptions:execute"),
        SUBSCRIPTION_EVENTS_READ("subscription_events:read"),
        SUBSCRIPTION_EVENTS_EXECUTE("subscription_events:execute"),
        IDENTITY_VERIFICATIONS_READ("identity_verifications:read"),
        IDENTITY_VERIFICATIONS_PII_READ("identity_verifications:pii:read"),
        IDENTITY_VERIFICATIONS_WRITE("identity_verifications:write"),
        IDENTITY_VERIFICATIONS_EXECUTE("identity_verifications:execute"),
        FILES_READ("files:read"),
        FILES_PII_READ("files:pii:read"),
        FILES_EXECUTE("files:execute"),
        OPENID("openid"),
        PROFILE("profile"),
        EMAIL("email");

        private String value;

        private AllowedScopesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AllowedScopesEnum fromValue(String value) {
            for (AllowedScopesEnum b : AllowedScopesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

