/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_id.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonPropertyOrder(value={"name", "client_id", "scopes", "created_at"})
@JsonTypeName(value="Application")
public class ApplicationIdpModel {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_CLIENT_ID = "client_id";
    private String clientId;
    public static final String JSON_PROPERTY_SCOPES = "scopes";
    private List<ScopesEnum> scopes = new ArrayList<ScopesEnum>();
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;

    public ApplicationIdpModel name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Name provided for the OAuth2 application.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public ApplicationIdpModel clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The OAuth2 application's client ID.")
    @JsonProperty(value="client_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="client_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public ApplicationIdpModel scopes(List<ScopesEnum> scopes) {
        this.scopes = scopes;
        return this;
    }

    public ApplicationIdpModel addScopesItem(ScopesEnum scopesItem) {
        this.scopes.add(scopesItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="List of the scopes granted to the OAuth2 application.")
    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<ScopesEnum> getScopes() {
        return this.scopes;
    }

    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setScopes(List<ScopesEnum> scopes) {
        this.scopes = scopes;
    }

    public ApplicationIdpModel createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="ISO8601 datetime the application was created at.")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationIdpModel application = (ApplicationIdpModel)o;
        return Objects.equals(this.name, application.name) && Objects.equals(this.clientId, application.clientId) && Objects.equals(this.scopes, application.scopes) && Objects.equals(this.createdAt, application.createdAt);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.clientId, this.scopes, this.createdAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationIdpModel {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ScopesEnum {
        ORGANIZATIONS_READ("organizations:read"),
        ORGANIZATIONS_WRITE("organizations:write"),
        BANKS_READ("banks:read"),
        BANKS_WRITE("banks:write"),
        BANKS_EXECUTE("banks:execute"),
        CUSTOMERS_READ("customers:read"),
        ACCOUNTS_READ("accounts:read"),
        QUOTES_READ("quotes:read"),
        TRADES_READ("trades:read"),
        TRANSFERS_READ("transfers:read"),
        EXTERNAL_BANK_ACCOUNTS_READ("external_bank_accounts:read"),
        WORKFLOWS_READ("workflows:read"),
        DEPOSIT_ADDRESSES_READ("deposit_addresses:read"),
        ACCOUNTS_EXECUTE("accounts:execute"),
        CUSTOMERS_WRITE("customers:write"),
        CUSTOMERS_EXECUTE("customers:execute"),
        PRICES_READ("prices:read"),
        QUOTES_EXECUTE("quotes:execute"),
        TRADES_EXECUTE("trades:execute"),
        TRANSFERS_EXECUTE("transfers:execute"),
        REWARDS_EXECUTE("rewards:execute"),
        REWARDS_READ("rewards:read"),
        EXTERNAL_BANK_ACCOUNTS_WRITE("external_bank_accounts:write"),
        EXTERNAL_BANK_ACCOUNTS_EXECUTE("external_bank_accounts:execute"),
        WORKFLOWS_EXECUTE("workflows:execute"),
        DEPOSIT_ADDRESSES_EXECUTE("deposit_addresses:execute");

        private String value;

        private ScopesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ScopesEnum fromValue(String value) {
            for (ScopesEnum b : ScopesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

