/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_id.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonPropertyOrder(value={"name", "client_id", "scopes", "created_at", "secret"})
@JsonTypeName(value="ApplicationWithSecret")
public class ApplicationWithSecretIdpModel {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_CLIENT_ID = "client_id";
    private String clientId;
    public static final String JSON_PROPERTY_SCOPES = "scopes";
    private List<ScopesEnum> scopes = new ArrayList<ScopesEnum>();
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_SECRET = "secret";
    private String secret;

    public ApplicationWithSecretIdpModel name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Name provided for the OAuth2 application.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public ApplicationWithSecretIdpModel clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The OAuth2 application's client ID.")
    @JsonProperty(value="client_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="client_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public ApplicationWithSecretIdpModel scopes(List<ScopesEnum> scopes) {
        this.scopes = scopes;
        return this;
    }

    public ApplicationWithSecretIdpModel addScopesItem(ScopesEnum scopesItem) {
        this.scopes.add(scopesItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="List of the scopes granted to the OAuth2 application.")
    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<ScopesEnum> getScopes() {
        return this.scopes;
    }

    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setScopes(List<ScopesEnum> scopes) {
        this.scopes = scopes;
    }

    public ApplicationWithSecretIdpModel createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="ISO8601 datetime the application was created at.")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public ApplicationWithSecretIdpModel secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The OAuth2 application's secret.")
    @JsonProperty(value="secret")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSecret() {
        return this.secret;
    }

    @JsonProperty(value="secret")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSecret(String secret) {
        this.secret = secret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationWithSecretIdpModel applicationWithSecret = (ApplicationWithSecretIdpModel)o;
        return Objects.equals(this.name, applicationWithSecret.name) && Objects.equals(this.clientId, applicationWithSecret.clientId) && Objects.equals(this.scopes, applicationWithSecret.scopes) && Objects.equals(this.createdAt, applicationWithSecret.createdAt) && Objects.equals(this.secret, applicationWithSecret.secret);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.clientId, this.scopes, this.createdAt, this.secret);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationWithSecretIdpModel {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ScopesEnum {
        ACCOUNTS_EXECUTE("accounts:execute"),
        ACCOUNTS_READ("accounts:read"),
        BANK_APPLICATIONS_EXECUTE("bank_applications:execute"),
        BANKS_EXECUTE("banks:execute"),
        BANKS_READ("banks:read"),
        BANKS_WRITE("banks:write"),
        CUSTOMERS_EXECUTE("customers:execute"),
        CUSTOMERS_READ("customers:read"),
        CUSTOMERS_WRITE("customers:write"),
        DEPOSIT_ADDRESSES_EXECUTE("deposit_addresses:execute"),
        DEPOSIT_ADDRESSES_READ("deposit_addresses:read"),
        EXTERNAL_BANK_ACCOUNTS_EXECUTE("external_bank_accounts:execute"),
        EXTERNAL_BANK_ACCOUNTS_READ("external_bank_accounts:read"),
        EXTERNAL_BANK_ACCOUNTS_WRITE("external_bank_accounts:write"),
        EXTERNAL_WALLETS_EXECUTE("external_wallets:execute"),
        EXTERNAL_WALLETS_READ("external_wallets:read"),
        ORGANIZATION_APPLICATIONS_EXECUTE("organization_applications:execute"),
        ORGANIZATIONS_READ("organizations:read"),
        ORGANIZATIONS_WRITE("organizations:write"),
        PRICES_READ("prices:read"),
        QUOTES_EXECUTE("quotes:execute"),
        QUOTES_READ("quotes:read"),
        REWARDS_EXECUTE("rewards:execute"),
        REWARDS_READ("rewards:read"),
        TRADES_EXECUTE("trades:execute"),
        TRADES_READ("trades:read"),
        TRANSFERS_EXECUTE("transfers:execute"),
        TRANSFERS_READ("transfers:read"),
        WORKFLOWS_EXECUTE("workflows:execute"),
        WORKFLOWS_READ("workflows:read");

        private String value;

        private ScopesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ScopesEnum fromValue(String value) {
            for (ScopesEnum b : ScopesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

