/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_organization.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"guid", "response", "subscription_event_guid", "subscription_guid", "state", "next_attempt_at", "attempt_count", "completed_at", "failed_at", "created_at", "updated_at"})
@JsonTypeName(value="SubscriptionDelivery")
public class SubscriptionDeliveryOrganizationModel {
    public static final String JSON_PROPERTY_GUID = "guid";
    private String guid;
    public static final String JSON_PROPERTY_RESPONSE = "response";
    private JsonNullable<String> response = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SUBSCRIPTION_EVENT_GUID = "subscription_event_guid";
    private String subscriptionEventGuid;
    public static final String JSON_PROPERTY_SUBSCRIPTION_GUID = "subscription_guid";
    private String subscriptionGuid;
    public static final String JSON_PROPERTY_STATE = "state";
    private StateEnum state;
    public static final String JSON_PROPERTY_NEXT_ATTEMPT_AT = "next_attempt_at";
    private JsonNullable<OffsetDateTime> nextAttemptAt = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ATTEMPT_COUNT = "attempt_count";
    private BigInteger attemptCount;
    public static final String JSON_PROPERTY_COMPLETED_AT = "completed_at";
    private JsonNullable<OffsetDateTime> completedAt = JsonNullable.undefined();
    public static final String JSON_PROPERTY_FAILED_AT = "failed_at";
    private JsonNullable<OffsetDateTime> failedAt = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private OffsetDateTime updatedAt;

    public SubscriptionDeliveryOrganizationModel guid(String guid) {
        this.guid = guid;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Auto-generated unique identifier for the subscription delivery.")
    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public SubscriptionDeliveryOrganizationModel response(String response) {
        this.response = JsonNullable.of((Object)response);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The response of the subscription delivery.")
    @JsonIgnore
    public String getResponse() {
        return (String)this.response.orElse(null);
    }

    @JsonProperty(value="response")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getResponse_JsonNullable() {
        return this.response;
    }

    @JsonProperty(value="response")
    public void setResponse_JsonNullable(JsonNullable<String> response) {
        this.response = response;
    }

    public void setResponse(String response) {
        this.response = JsonNullable.of((Object)response);
    }

    public SubscriptionDeliveryOrganizationModel subscriptionEventGuid(String subscriptionEventGuid) {
        this.subscriptionEventGuid = subscriptionEventGuid;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The subscription event guid of the subscription delivery.")
    @JsonProperty(value="subscription_event_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSubscriptionEventGuid() {
        return this.subscriptionEventGuid;
    }

    @JsonProperty(value="subscription_event_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSubscriptionEventGuid(String subscriptionEventGuid) {
        this.subscriptionEventGuid = subscriptionEventGuid;
    }

    public SubscriptionDeliveryOrganizationModel subscriptionGuid(String subscriptionGuid) {
        this.subscriptionGuid = subscriptionGuid;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The subscription guid of the subscription delivery.")
    @JsonProperty(value="subscription_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSubscriptionGuid() {
        return this.subscriptionGuid;
    }

    @JsonProperty(value="subscription_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSubscriptionGuid(String subscriptionGuid) {
        this.subscriptionGuid = subscriptionGuid;
    }

    public SubscriptionDeliveryOrganizationModel state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The state of the subscription delivery.")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StateEnum getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setState(StateEnum state) {
        this.state = state;
    }

    public SubscriptionDeliveryOrganizationModel nextAttemptAt(OffsetDateTime nextAttemptAt) {
        this.nextAttemptAt = JsonNullable.of((Object)nextAttemptAt);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the next attempt will be made.")
    @JsonIgnore
    public OffsetDateTime getNextAttemptAt() {
        return (OffsetDateTime)this.nextAttemptAt.orElse(null);
    }

    @JsonProperty(value="next_attempt_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getNextAttemptAt_JsonNullable() {
        return this.nextAttemptAt;
    }

    @JsonProperty(value="next_attempt_at")
    public void setNextAttemptAt_JsonNullable(JsonNullable<OffsetDateTime> nextAttemptAt) {
        this.nextAttemptAt = nextAttemptAt;
    }

    public void setNextAttemptAt(OffsetDateTime nextAttemptAt) {
        this.nextAttemptAt = JsonNullable.of((Object)nextAttemptAt);
    }

    public SubscriptionDeliveryOrganizationModel attemptCount(BigInteger attemptCount) {
        this.attemptCount = attemptCount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The number of attempts made to deliver the event.")
    @JsonProperty(value="attempt_count")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigInteger getAttemptCount() {
        return this.attemptCount;
    }

    @JsonProperty(value="attempt_count")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAttemptCount(BigInteger attemptCount) {
        this.attemptCount = attemptCount;
    }

    public SubscriptionDeliveryOrganizationModel completedAt(OffsetDateTime completedAt) {
        this.completedAt = JsonNullable.of((Object)completedAt);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the event was delivered.")
    @JsonIgnore
    public OffsetDateTime getCompletedAt() {
        return (OffsetDateTime)this.completedAt.orElse(null);
    }

    @JsonProperty(value="completed_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getCompletedAt_JsonNullable() {
        return this.completedAt;
    }

    @JsonProperty(value="completed_at")
    public void setCompletedAt_JsonNullable(JsonNullable<OffsetDateTime> completedAt) {
        this.completedAt = completedAt;
    }

    public void setCompletedAt(OffsetDateTime completedAt) {
        this.completedAt = JsonNullable.of((Object)completedAt);
    }

    public SubscriptionDeliveryOrganizationModel failedAt(OffsetDateTime failedAt) {
        this.failedAt = JsonNullable.of((Object)failedAt);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the event delivery was marked as failed.")
    @JsonIgnore
    public OffsetDateTime getFailedAt() {
        return (OffsetDateTime)this.failedAt.orElse(null);
    }

    @JsonProperty(value="failed_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getFailedAt_JsonNullable() {
        return this.failedAt;
    }

    @JsonProperty(value="failed_at")
    public void setFailedAt_JsonNullable(JsonNullable<OffsetDateTime> failedAt) {
        this.failedAt = failedAt;
    }

    public void setFailedAt(OffsetDateTime failedAt) {
        this.failedAt = JsonNullable.of((Object)failedAt);
    }

    public SubscriptionDeliveryOrganizationModel createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was created at.")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public SubscriptionDeliveryOrganizationModel updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was last updated at.")
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionDeliveryOrganizationModel subscriptionDelivery = (SubscriptionDeliveryOrganizationModel)o;
        return Objects.equals(this.guid, subscriptionDelivery.guid) && SubscriptionDeliveryOrganizationModel.equalsNullable(this.response, subscriptionDelivery.response) && Objects.equals(this.subscriptionEventGuid, subscriptionDelivery.subscriptionEventGuid) && Objects.equals(this.subscriptionGuid, subscriptionDelivery.subscriptionGuid) && Objects.equals((Object)this.state, (Object)subscriptionDelivery.state) && SubscriptionDeliveryOrganizationModel.equalsNullable(this.nextAttemptAt, subscriptionDelivery.nextAttemptAt) && Objects.equals(this.attemptCount, subscriptionDelivery.attemptCount) && SubscriptionDeliveryOrganizationModel.equalsNullable(this.completedAt, subscriptionDelivery.completedAt) && SubscriptionDeliveryOrganizationModel.equalsNullable(this.failedAt, subscriptionDelivery.failedAt) && Objects.equals(this.createdAt, subscriptionDelivery.createdAt) && Objects.equals(this.updatedAt, subscriptionDelivery.updatedAt);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.guid, SubscriptionDeliveryOrganizationModel.hashCodeNullable(this.response), this.subscriptionEventGuid, this.subscriptionGuid, this.state, SubscriptionDeliveryOrganizationModel.hashCodeNullable(this.nextAttemptAt), this.attemptCount, SubscriptionDeliveryOrganizationModel.hashCodeNullable(this.completedAt), SubscriptionDeliveryOrganizationModel.hashCodeNullable(this.failedAt), this.createdAt, this.updatedAt});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubscriptionDeliveryOrganizationModel {\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    response: ").append(this.toIndentedString(this.response)).append("\n");
        sb.append("    subscriptionEventGuid: ").append(this.toIndentedString(this.subscriptionEventGuid)).append("\n");
        sb.append("    subscriptionGuid: ").append(this.toIndentedString(this.subscriptionGuid)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    nextAttemptAt: ").append(this.toIndentedString(this.nextAttemptAt)).append("\n");
        sb.append("    attemptCount: ").append(this.toIndentedString(this.attemptCount)).append("\n");
        sb.append("    completedAt: ").append(this.toIndentedString(this.completedAt)).append("\n");
        sb.append("    failedAt: ").append(this.toIndentedString(this.failedAt)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        STORING("storing"),
        COMPLETED("completed"),
        FAILING("failing"),
        FAILED("failed");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

