/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_organization.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"guid", "event_type", "object_guid", "environment", "organization_guid", "created_at", "updated_at"})
@JsonTypeName(value="SubscriptionEvent")
public class SubscriptionEventOrganizationModel {
    public static final String JSON_PROPERTY_GUID = "guid";
    private String guid;
    public static final String JSON_PROPERTY_EVENT_TYPE = "event_type";
    private String eventType;
    public static final String JSON_PROPERTY_OBJECT_GUID = "object_guid";
    private String objectGuid;
    public static final String JSON_PROPERTY_ENVIRONMENT = "environment";
    private String environment;
    public static final String JSON_PROPERTY_ORGANIZATION_GUID = "organization_guid";
    private String organizationGuid;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private OffsetDateTime updatedAt;

    public SubscriptionEventOrganizationModel guid(String guid) {
        this.guid = guid;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Auto-generated unique identifier for the subscription event.")
    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public SubscriptionEventOrganizationModel eventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The type of the subscription event. One of trade.storing, trade.pending, trade.cancelled, trade.completed, trade.settling, trade.failed, transfer.storing, transfer.pending, transfer.holding, transfer.reviewing, transfer.completed, transfer.failed, identity_verification.storing, identity_verification.pending, identity_verification.reviewing, identity_verification.waiting, identity_verification.expired, or identity_verification.completed.")
    @JsonProperty(value="event_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEventType() {
        return this.eventType;
    }

    @JsonProperty(value="event_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public SubscriptionEventOrganizationModel objectGuid(String objectGuid) {
        this.objectGuid = objectGuid;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The object guid for which the event is received.")
    @JsonProperty(value="object_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getObjectGuid() {
        return this.objectGuid;
    }

    @JsonProperty(value="object_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setObjectGuid(String objectGuid) {
        this.objectGuid = objectGuid;
    }

    public SubscriptionEventOrganizationModel environment(String environment) {
        this.environment = environment;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The environment that the subscription event is configured for; one of sandbox or production.")
    @JsonProperty(value="environment")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEnvironment() {
        return this.environment;
    }

    @JsonProperty(value="environment")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public SubscriptionEventOrganizationModel organizationGuid(String organizationGuid) {
        this.organizationGuid = organizationGuid;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The organization guid of the subscription event.")
    @JsonProperty(value="organization_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getOrganizationGuid() {
        return this.organizationGuid;
    }

    @JsonProperty(value="organization_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOrganizationGuid(String organizationGuid) {
        this.organizationGuid = organizationGuid;
    }

    public SubscriptionEventOrganizationModel createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="ISO8601 datetime the record was created at.")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public SubscriptionEventOrganizationModel updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was last updated at.")
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionEventOrganizationModel subscriptionEvent = (SubscriptionEventOrganizationModel)o;
        return Objects.equals(this.guid, subscriptionEvent.guid) && Objects.equals(this.eventType, subscriptionEvent.eventType) && Objects.equals(this.objectGuid, subscriptionEvent.objectGuid) && Objects.equals(this.environment, subscriptionEvent.environment) && Objects.equals(this.organizationGuid, subscriptionEvent.organizationGuid) && Objects.equals(this.createdAt, subscriptionEvent.createdAt) && Objects.equals(this.updatedAt, subscriptionEvent.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.guid, this.eventType, this.objectGuid, this.environment, this.organizationGuid, this.createdAt, this.updatedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubscriptionEventOrganizationModel {\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString(this.eventType)).append("\n");
        sb.append("    objectGuid: ").append(this.toIndentedString(this.objectGuid)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString(this.environment)).append("\n");
        sb.append("    organizationGuid: ").append(this.toIndentedString(this.organizationGuid)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

