/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_organization.client.auth;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lapp/cybrid/cybrid_api_organization/client/auth/ApiKeyAuth;", "Lokhttp3/Interceptor;", "location", "", "paramName", "apiKey", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "cybrid-api-organization-kotlin"})
public final class ApiKeyAuth
implements Interceptor {
    @NotNull
    private final String location;
    @NotNull
    private final String paramName;
    @NotNull
    private String apiKey;

    public ApiKeyAuth(@NotNull String location, @NotNull String paramName, @NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)paramName, (String)"paramName");
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        this.location = location;
        this.paramName = paramName;
        this.apiKey = apiKey;
    }

    public /* synthetic */ ApiKeyAuth(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            string3 = "";
        }
        this(string, string2, string3);
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request request = chain.request();
        if (Intrinsics.areEqual((Object)"query", (Object)this.location)) {
            String newQuery = request.url().uri().getQuery();
            String paramValue = this.paramName + '=' + this.apiKey;
            newQuery = newQuery == null ? paramValue : newQuery + '&' + paramValue;
            URI newUri = null;
            try {
                URI oldUri = request.url().uri();
                newUri = new URI(oldUri.getScheme(), oldUri.getAuthority(), oldUri.getPath(), newQuery, oldUri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
            Request.Builder builder = request.newBuilder();
            URL uRL = newUri.toURL();
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"newUri.toURL()");
            request = builder.url(uRL).build();
        } else if (Intrinsics.areEqual((Object)"header", (Object)this.location)) {
            request = request.newBuilder().addHeader(this.paramName, this.apiKey).build();
        } else if (Intrinsics.areEqual((Object)"cookie", (Object)this.location)) {
            request = request.newBuilder().addHeader("Cookie", this.paramName + '=' + this.apiKey).build();
        }
        return chain.proceed(request);
    }

    public ApiKeyAuth() {
        this(null, null, null, 7, null);
    }
}

