/*
 * Decompiled with CFR 0.152.
 */
package app.dokt.generator.documentation.md;

import app.dokt.generator.documentation.Documentation;
import app.dokt.generator.documentation.md.MarkDownTable;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0001H\u0016J\u0018\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u000eH\u0016J\u0018\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\u0016\u001a\u00020\u0001H\u0016J\b\u0010\u0017\u001a\u00020\u0001H\u0016J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u0019\u001a\u00020\u00012\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u000eH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lapp/dokt/generator/documentation/md/MarkDownDocumentation;", "Lapp/dokt/generator/documentation/Documentation;", "out", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "(Ljava/lang/Appendable;)V", "<set-?>", "", "level", "getLevel", "()I", "bold", "", "text", "", "decrementLevel", "definition", "term", "escape", "any", "heading", "phrase", "horizontalRule", "incrementLevel", "italic", "ordered", "list", "", "paragraph", "lines", "table", "Lapp/dokt/generator/documentation/md/MarkDownTable;", "dokt-generator"})
public final class MarkDownDocumentation
implements Documentation {
    @NotNull
    private final Appendable out;
    private int level;

    public MarkDownDocumentation(@NotNull Appendable out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.out = out;
        this.level = 1;
    }

    public final int getLevel() {
        return this.level;
    }

    @Override
    @NotNull
    public String bold(@NotNull Object text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return "**" + text + "**";
    }

    @Override
    @NotNull
    public Documentation decrementLevel() {
        if (this.level > 1) {
            int n = this.level;
            this.level = n + -1;
        }
        return this;
    }

    @Override
    @NotNull
    public Documentation definition(@NotNull Object term, @NotNull Object definition) {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        Appendable appendable = this.out.append(this.escape(term));
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(value)");
        Appendable appendable2 = appendable.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)appendable2, (String)"append('\\n')");
        appendable = appendable2.append(Intrinsics.stringPlus((String)": ", (Object)this.escape(definition)));
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(value)");
        appendable2 = appendable.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)appendable2, (String)"append('\\n')");
        Appendable appendable3 = appendable2.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)appendable3, (String)"append('\\n')");
        return this;
    }

    private final String escape(Object any) {
        return StringsKt.replace$default((String)any.toString(), (String)"<", (String)"\\<", (boolean)false, (int)4, null);
    }

    @Override
    @NotNull
    public Documentation heading(@NotNull Object phrase) {
        Intrinsics.checkNotNullParameter((Object)phrase, (String)"phrase");
        return this.heading(phrase, this.level);
    }

    @Override
    @NotNull
    public Documentation heading(@NotNull Object phrase, int level) {
        Intrinsics.checkNotNullParameter((Object)phrase, (String)"phrase");
        String text = this.escape(phrase);
        int n = level;
        if (n == 1) {
            Appendable appendable = this.out.append(text);
            Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(value)");
            Appendable appendable2 = appendable.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)appendable2, (String)"append('\\n')");
            int n2 = text.length();
            int n3 = 0;
            while (n3 < n2) {
                int n4;
                int it = n4 = n3++;
                boolean bl = false;
                this.out.append('=');
            }
            Appendable appendable3 = this.out.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)appendable3, (String)"append('\\n')");
        } else if (n == 2) {
            Appendable appendable = this.out.append(text);
            Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(value)");
            Appendable appendable4 = appendable.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)appendable4, (String)"append('\\n')");
            int n5 = text.length();
            int n6 = 0;
            while (n6 < n5) {
                int n7;
                int it = n7 = n6++;
                boolean bl = false;
                this.out.append('-');
            }
            Appendable appendable5 = this.out.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)appendable5, (String)"append('\\n')");
        } else {
            boolean bl = 3 <= n ? n < 7 : false;
            if (bl) {
                int n8 = 0;
                while (n8 < level) {
                    int n9;
                    int it = n9 = n8++;
                    boolean bl2 = false;
                    this.out.append('#');
                }
                Appendable appendable = this.out;
                CharSequence charSequence = Intrinsics.stringPlus((String)" ", (Object)text);
                Appendable appendable6 = appendable.append(charSequence);
                Intrinsics.checkNotNullExpressionValue((Object)appendable6, (String)"append(value)");
                Appendable appendable7 = appendable6.append('\n');
                Intrinsics.checkNotNullExpressionValue((Object)appendable7, (String)"append('\\n')");
            } else {
                throw new IllegalArgumentException(level + " isn't valid heading level!");
            }
        }
        Appendable appendable = this.out.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append('\\n')");
        return this;
    }

    @Override
    @NotNull
    public Documentation horizontalRule() {
        Appendable appendable = this.out.append("___________________________________________________________________________");
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(value)");
        Appendable appendable2 = appendable.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)appendable2, (String)"append('\\n')");
        Appendable appendable3 = appendable2.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)appendable3, (String)"append('\\n')");
        return this;
    }

    @Override
    @NotNull
    public Documentation incrementLevel() {
        if (this.level < 6) {
            int n = this.level;
            this.level = n + 1;
        }
        return this;
    }

    @Override
    @NotNull
    public String italic(@NotNull Object text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return "" + '*' + text + '*';
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Documentation ordered(@NotNull List<? extends Object> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Iterable $this$forEachIndexed$iv = list;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void item;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv;
            int index = n;
            boolean bl = false;
            Appendable appendable = this.out.append(index + 1 + ". " + this.escape(item));
            Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(value)");
            Appendable appendable2 = appendable.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)appendable2, (String)"append('\\n')");
        }
        Appendable appendable = this.out.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append('\\n')");
        return this;
    }

    @Override
    @NotNull
    public Documentation paragraph(@NotNull Object lines) {
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        Appendable appendable = this.out.append(this.escape(lines));
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(value)");
        Appendable appendable2 = appendable.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)appendable2, (String)"append('\\n')");
        Appendable appendable3 = appendable2.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)appendable3, (String)"append('\\n')");
        return this;
    }

    @Override
    @NotNull
    public MarkDownTable table() {
        return new MarkDownTable(this.out);
    }

    @Override
    @NotNull
    public Documentation heading1(@NotNull Object phrase) {
        return Documentation.DefaultImpls.heading1(this, phrase);
    }

    @Override
    @NotNull
    public Documentation heading2(@NotNull Object phrase) {
        return Documentation.DefaultImpls.heading2(this, phrase);
    }

    @Override
    @NotNull
    public Documentation heading3(@NotNull Object phrase) {
        return Documentation.DefaultImpls.heading3(this, phrase);
    }

    @Override
    @NotNull
    public Documentation heading4(@NotNull Object phrase) {
        return Documentation.DefaultImpls.heading4(this, phrase);
    }

    @Override
    @NotNull
    public Documentation heading5(@NotNull Object phrase) {
        return Documentation.DefaultImpls.heading5(this, phrase);
    }

    @Override
    @NotNull
    public Documentation heading6(@NotNull Object phrase) {
        return Documentation.DefaultImpls.heading6(this, phrase);
    }

    @Override
    public void level(@NotNull Function0<Unit> action) {
        Documentation.DefaultImpls.level(this, action);
    }
}

