/*
 * Decompiled with CFR 0.152.
 */
package app.dokt.generator.domain.model;

import app.dokt.generator.code.Packaged;
import app.dokt.generator.domain.BoundedContext;
import app.dokt.generator.domain.DomainException;
import app.dokt.generator.domain.DomainServiceInterface;
import app.dokt.generator.domain.ValueObject;
import app.dokt.generator.domain.model.AggregateRootModel;
import app.dokt.generator.domain.model.BuildingBlockModel;
import app.dokt.generator.domain.model.ModuleModel;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003BA\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007\u00a2\u0006\u0002\u0010\u000fR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0014R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lapp/dokt/generator/domain/model/BoundedContextModel;", "Lapp/dokt/generator/domain/model/BuildingBlockModel;", "Lapp/dokt/generator/domain/model/ModuleModel;", "Lapp/dokt/generator/domain/BoundedContext;", "aggregateRoot", "Lapp/dokt/generator/domain/model/AggregateRootModel;", "exceptions", "", "Lapp/dokt/generator/domain/DomainException;", "module", "", "serviceInterfaces", "Lapp/dokt/generator/domain/DomainServiceInterface;", "valueObjects", "Lapp/dokt/generator/domain/ValueObject;", "(Lapp/dokt/generator/domain/model/AggregateRootModel;Ljava/util/List;Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getAggregateRoot", "()Lapp/dokt/generator/domain/model/AggregateRootModel;", "aggregateRoots", "getAggregateRoots", "()Ljava/util/List;", "displayName", "getDisplayName", "()Ljava/lang/String;", "getExceptions", "getServiceInterfaces", "sharedKernel", "", "getSharedKernel", "()Z", "getValueObjects", "dokt-generator"})
public final class BoundedContextModel
extends BuildingBlockModel<ModuleModel>
implements BoundedContext {
    @Nullable
    private final AggregateRootModel aggregateRoot;
    @NotNull
    private final List<DomainException> exceptions;
    @NotNull
    private final List<DomainServiceInterface> serviceInterfaces;
    @NotNull
    private final List<ValueObject> valueObjects;
    @NotNull
    private final List<AggregateRootModel> aggregateRoots;
    private final boolean sharedKernel;
    @NotNull
    private final String displayName;

    public BoundedContextModel(@Nullable AggregateRootModel aggregateRoot, @NotNull List<? extends DomainException> exceptions, @NotNull String module, @NotNull List<? extends DomainServiceInterface> serviceInterfaces, @NotNull List<? extends ValueObject> valueObjects) {
        String string;
        Intrinsics.checkNotNullParameter(exceptions, (String)"exceptions");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(serviceInterfaces, (String)"serviceInterfaces");
        Intrinsics.checkNotNullParameter(valueObjects, (String)"valueObjects");
        super((Packaged)new ModuleModel(module));
        this.aggregateRoot = aggregateRoot;
        this.exceptions = exceptions;
        this.serviceInterfaces = serviceInterfaces;
        this.valueObjects = valueObjects;
        this.aggregateRoots = this.getAggregateRoot() == null ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)this.getAggregateRoot());
        this.sharedKernel = Intrinsics.areEqual((Object)this.getName(), (Object)"shared");
        if (this.getSharedKernel()) {
            string = "Shared Kernel";
        } else {
            AggregateRootModel aggregateRootModel = this.getAggregateRoot();
            string = aggregateRootModel == null ? null : aggregateRootModel.getDisplayName();
            if (string == null) {
                string = this.getName();
            }
        }
        this.displayName = string;
    }

    @Override
    @Nullable
    public AggregateRootModel getAggregateRoot() {
        return this.aggregateRoot;
    }

    @Override
    @NotNull
    public List<DomainException> getExceptions() {
        return this.exceptions;
    }

    @Override
    @NotNull
    public List<DomainServiceInterface> getServiceInterfaces() {
        return this.serviceInterfaces;
    }

    @Override
    @NotNull
    public List<ValueObject> getValueObjects() {
        return this.valueObjects;
    }

    @NotNull
    public List<AggregateRootModel> getAggregateRoots() {
        return this.aggregateRoots;
    }

    @Override
    public boolean getSharedKernel() {
        return this.sharedKernel;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return this.displayName;
    }
}

