package app.dokt.gradle

import app.dokt.generator.application.Application
import app.dokt.generator.code.KotlinSources
import app.dokt.generator.domain.model.BoundedContextModelReader
import org.gradle.api.Project
import org.gradle.kotlin.dsl.provideDelegate
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet
import java.io.File
import java.nio.file.Path

class GradleApplication(private val project: Project) : Application {
    override val boundedContexts by lazy { BoundedContextModelReader.readContexts(sources) }

    override val description get() = project.description

    override val displayName get() = project.description

    override val domainSources by lazy { domainSourcesPath.toString() }

    private val domainSourcesPath: Path by lazy {
        project.projectDir.toPath().resolve("src").resolve(KotlinSourceSet.COMMON_MAIN_SOURCE_SET_NAME)
            .resolve("kotlin")
    }

    override val generated by lazy { generatedPath.toString() }

    val generatedFile: File by lazy { generatedPath.toFile() }

    private val generatedPath by lazy { project.buildDir.toPath().resolve("generated") }

    override val generatedSources by lazy {
        generatedPath.resolve(KotlinSourceSet.COMMON_MAIN_SOURCE_SET_NAME).toString()
    }

    override val generatedTestSources by lazy {
        generatedPath.resolve(KotlinSourceSet.COMMON_TEST_SOURCE_SET_NAME).toString()
    }

    override val group get() = project.group.toString()

    override val name: String get() = project.name

    private val sources by lazy { KotlinSources(domainSourcesPath) }
}
