@file:Suppress("MemberVisibilityCanBePrivate")

package dev.entao.web.base

/**
 * Created by entaoyang@163.com on 2018/3/19.
 */

object Mimes {

	const val JSON = "application/json"
	const val HTML = "text/html"
	const val PLAIN = "text/plain"
	const val XML = "application/xml"
	const val STREAM = "application/octet-stream"
	const val OCTET_STREAM = "application/octet-stream"

	private val map = HashMap<String, String>(1024)

	//Mimes.of("xml") => "application/xml"
	fun ofExt(ext: String): String {
		return map[ext.trim('.').lowerCased] ?: OCTET_STREAM
	}

	fun ofFile(filename: String): String {
		val ext = filename.substringAfterLast('.', "")
		if (ext.isNotEmpty()) {
			return ofExt(ext)
		}
		return OCTET_STREAM
	}

	init {
		map["xpi"] = "application/x-xpinstall"
		map["xdf"] = "application/xcap-diff+xml"
		map["xenc"] = "application/xenc+xml"
		map["xhtml"] = "application/xhtml+xml"
		map["xml"] = "application/xml"
		map["dtd"] = "application/xml-dtd"
		map["xop"] = "application/xop+xml"
		map["xslt"] = "application/xslt+xml"
		map["xspf"] = "application/xspf+xml"
		map["mxml"] = "application/xv+xml"
		map["yang"] = "application/yang"
		map["yin"] = "application/yin+xml"
		map["zip"] = "application/zip"
		map["adp"] = "audio/adpcm"
		map["au"] = "audio/basic"
		map["mid"] = "audio/midi"
		map["mp4a"] = "audio/mp4"
		map["mpga"] = "audio/mpeg"
		map["oga"] = "audio/ogg"
		map["uva"] = "audio/vnd.dece.audio"
		map["eol"] = "audio/vnd.digital-winds"
		map["dra"] = "audio/vnd.dra"
		map["dts"] = "audio/vnd.dts"
		map["dtshd"] = "audio/vnd.dts.hd"
		map["lvp"] = "audio/vnd.lucent.voice"
		map["pya"] = "audio/vnd.ms-playready.media.pya"
		map["ecelp4800"] = "audio/vnd.nuera.ecelp4800"
		map["ecelp7470"] = "audio/vnd.nuera.ecelp7470"
		map["ecelp9600"] = "audio/vnd.nuera.ecelp9600"
		map["rip"] = "audio/vnd.rip"
		map["weba"] = "audio/webm"
		map["aac"] = "audio/x-aac"
		map["aif"] = "audio/x-aiff"
		map["m3u"] = "audio/x-mpegurl"
		map["wax"] = "audio/x-ms-wax"
		map["wma"] = "audio/x-ms-wma"
		map["ram"] = "audio/x-pn-realaudio"
		map["rmp"] = "audio/x-pn-realaudio-plugin"
		map["wav"] = "audio/x-wav"
		map["cdx"] = "chemical/x-cdx"
		map["cif"] = "chemical/x-cif"
		map["cmdf"] = "chemical/x-cmdf"
		map["cml"] = "chemical/x-cml"
		map["csml"] = "chemical/x-csml"
		map["xyz"] = "chemical/x-xyz"
		map["bmp"] = "image/bmp"
		map["cgm"] = "image/cgm"
		map["g3"] = "image/g3fax"
		map["djvu"] = "image/vnd.djvu"
		map["dwg"] = "image/vnd.dwg"
		map["dxf"] = "image/vnd.dxf"
		map["fbs"] = "image/vnd.fastbidsheet"
		map["/A"] = "application/andrew-inset"
		map["aw"] = "application/applixware"
		map["atom"] = "application/atom+xml"
		map["atomcat"] = "application/atomcat+xml"
		map["atomsvc"] = "application/atomsvc+xml"
		map["ccxml"] = "application/ccxml+xml"
		map["cdmia"] = "application/cdmi-capability"
		map["cdmic"] = "application/cdmi-container"
		map["cdmid"] = "application/cdmi-domain"
		map["cdmio"] = "application/cdmi-object"
		map["cdmiq"] = "application/cdmi-queue"
		map["cu"] = "application/cu-seeme"
		map["davmount"] = "application/davmount+xml"
		map["dssc"] = "application/dssc+der"
		map["xdssc"] = "application/dssc+xml"
		map["es"] = "application/ecmascript"
		map["emma"] = "application/emma+xml"
		map["epub"] = "application/epub+zip"
		map["exi"] = "application/exi"
		map["pfr"] = "application/font-tdpfr"
		map["stk"] = "application/hyperstudio"
		map["ipfix"] = "application/ipfix"
		map["jar"] = "application/java-archive"
		map["ser"] = "application/java-serialized-object"
		map["class"] = "application/java-vm"
		map["js"] = "application/javascript"
		map["json"] = "application/json"
		map["hqx"] = "application/mac-binhex40"
		map["cpt"] = "application/mac-compactpro"
		map["mads"] = "application/mads+xml"
		map["mrc"] = "application/marc"
		map["mrcx"] = "application/marcxml+xml"
		map["ma"] = "application/mathematica"
		map["mathml"] = "application/mathml+xml"
		map["mbox"] = "application/mbox"
		map["mscml"] = "application/mediaservercontrol+xml"
		map["meta4"] = "application/metalink4+xml"
		map["mets"] = "application/mets+xml"
		map["mods"] = "application/mods+xml"
		map["m21"] = "application/mp21"
		map["mp4"] = "application/mp4"
		map["doc"] = "application/msword"
		map["mxf"] = "application/mxf"
		map["bin"] = "application/octet-stream"
		map["oda"] = "application/oda"
		map["opf"] = "application/oebps-package+xml"
		map["ogx"] = "application/ogg"
		map["onetoc"] = "application/onenote"
		map["xer"] = "application/patch-ops-error+xml"
		map["pdf"] = "application/pdf"
//		map["pgp"]=                   "application/pgp-encrypted"
		map["pgp"] = "application/pgp-signature"
		map["prf"] = "application/pics-rules"
		map["p10"] = "application/pkcs10"
		map["p7m"] = "application/pkcs7-mime"
		map["p7s"] = "application/pkcs7-signature"
		map["p8"] = "application/pkcs8"
		map["ac"] = "application/pkix-attr-cert"
		map["cer"] = "application/pkix-cert"
		map["crl"] = "application/pkix-crl"
		map["pkipath"] = "application/pkix-pkipath"
		map["pki"] = "application/pkixcmp"
		map["pls"] = "application/pls+xml"
		map["ai"] = "application/postscript"
		map["cww"] = "application/prs.cww"
		map["pskcxml"] = "application/pskc+xml"
		map["rdf"] = "application/rdf+xml"
		map["rif"] = "application/reginfo+xml"
		map["rnc"] = "application/relax-ng-compact-syntax"
		map["rl"] = "application/resource-lists+xml"
		map["rld"] = "application/resource-lists-diff+xml"
		map["rs"] = "application/rls-services+xml"
		map["rsd"] = "application/rsd+xml"
		map["rss"] = "application/rss+xml"
		map["rtf"] = "application/rtf"
		map["sbml"] = "application/sbml+xml"
		map["scq"] = "application/scvp-cv-request"
		map["scs"] = "application/scvp-cv-response"
		map["spq"] = "application/scvp-vp-request"
		map["spp"] = "application/scvp-vp-response"
		map["sdp"] = "application/sdp"
		map["setpay"] = "application/set-payment-initiation"
		map["setreg"] = "application/set-registration-initiation"
		map["shf"] = "application/shf+xml"
		map["smi"] = "application/smil+xml"
		map["rq"] = "application/sparql-query"
		map["srx"] = "application/sparql-results+xml"
		map["gram"] = "application/srgs"
		map["grxml"] = "application/srgs+xml"
		map["sru"] = "application/sru+xml"
		map["ssml"] = "application/ssml+xml"
		map["tei"] = "application/tei+xml"
		map["tfi"] = "application/thraud+xml"
		map["tsd"] = "application/timestamped-data"
		map["plb"] = "application/vnd.3gpp.pic-bw-large"
		map["psb"] = "application/vnd.3gpp.pic-bw-small"
		map["pvb"] = "application/vnd.3gpp.pic-bw-var"
		map["tcap"] = "application/vnd.3gpp2.tcap"
		map["pwn"] = "application/vnd.3m.post-it-notes"
		map["aso"] = "application/vnd.accpac.simply.aso"
		map["imp"] = "application/vnd.accpac.simply.imp"
		map["acu"] = "application/vnd.acucobol"
		map["atc"] = "application/vnd.acucorp"
		map["air"] = "application/vnd.adobe.air-application-installer-package+zip"
		map["fxp"] = "application/vnd.adobe.fxp"
		map["xdp"] = "application/vnd.adobe.xdp+xml"
		map["xfdf"] = "application/vnd.adobe.xfdf"
		map["ahead"] = "application/vnd.ahead.space"
		map["azf"] = "application/vnd.airzip.filesecure.azf"
		map["azs"] = "application/vnd.airzip.filesecure.azs"
		map["azw"] = "application/vnd.amazon.ebook"
		map["acc"] = "application/vnd.americandynamics.acc"
		map["ami"] = "application/vnd.amiga.ami"
		map["apk"] = "application/vnd.android.package-archive"
		map["cii"] = "application/vnd.anser-web-certificate-issue-initiation"
		map["fti"] = "application/vnd.anser-web-funds-transfer-initiation"
		map["atx"] = "application/vnd.antix.game-component"
		map["mpkg"] = "application/vnd.apple.installer+xml"
		map["m3u8"] = "application/vnd.apple.mpegurl"
		map["swi"] = "application/vnd.aristanetworks.swi"
		map["aep"] = "application/vnd.audiograph"
		map["mpm"] = "application/vnd.blueice.multipass"
		map["bmi"] = "application/vnd.bmi"
		map["rep"] = "application/vnd.businessobjects"
		map["cdxml"] = "application/vnd.chemdraw+xml"
		map["mmd"] = "application/vnd.chipnuts.karaoke-mmd"
		map["cdy"] = "application/vnd.cinderella"
		map["cla"] = "application/vnd.claymore"
		map["rp9"] = "application/vnd.cloanto.rp9"
		map["c4g"] = "application/vnd.clonk.c4group"
		map["c11amc"] = "application/vnd.cluetrust.cartomobile-config"
		map["c11amz"] = "application/vnd.cluetrust.cartomobile-config-pkg"
		map["csp"] = "application/vnd.commonspace"
		map["cdbcmsg"] = "application/vnd.contact.cmsg"
		map["cmc"] = "application/vnd.cosmocaller"
		map["clkx"] = "application/vnd.crick.clicker"
		map["clkk"] = "application/vnd.crick.clicker.keyboard"
		map["clkp"] = "application/vnd.crick.clicker.palette"
		map["clkt"] = "application/vnd.crick.clicker.template"
		map["clkw"] = "application/vnd.crick.clicker.wordbank"
		map["wbs"] = "application/vnd.criticaltools.wbs+xml"
		map["pml"] = "application/vnd.ctc-posml"
		map["ppd"] = "application/vnd.cups-ppd"
		map["car"] = "application/vnd.curl.car"
		map["pcurl"] = "application/vnd.curl.pcurl"
		map["rdz"] = "application/vnd.data-vision.rdz"
		map["fe_launch"] = "application/vnd.denovo.fcselayout-link"
		map["dna"] = "application/vnd.dna"
		map["mlp"] = "application/vnd.dolby.mlp"
		map["dpg"] = "application/vnd.dpgraph"
		map["dfac"] = "application/vnd.dreamfactory"
		map["ait"] = "application/vnd.dvb.ait"
		map["svc"] = "application/vnd.dvb.service"
		map["geo"] = "application/vnd.dynageo"
		map["mag"] = "application/vnd.ecowin.chart"
		map["nml"] = "application/vnd.enliven"
		map["esf"] = "application/vnd.epson.esf"
		map["msf"] = "application/vnd.epson.msf"
		map["qam"] = "application/vnd.epson.quickanime"
		map["slt"] = "application/vnd.epson.salt"
		map["ssf"] = "application/vnd.epson.ssf"
		map["es3"] = "application/vnd.eszigno3+xml"
		map["ez2"] = "application/vnd.ezpix-album"
		map["ez3"] = "application/vnd.ezpix-package"
		map["fdf"] = "application/vnd.fdf"
		map["seed"] = "application/vnd.fdsn.seed"
		map["gph"] = "application/vnd.flographit"
		map["ftc"] = "application/vnd.fluxtime.clip"
		map["fm"] = "application/vnd.framemaker"
		map["fnc"] = "application/vnd.frogans.fnc"
		map["ltf"] = "application/vnd.frogans.ltf"
		map["fsc"] = "application/vnd.fsc.weblaunch"
		map["oas"] = "application/vnd.fujitsu.oasys"
		map["oa2"] = "application/vnd.fujitsu.oasys2"
		map["oa3"] = "application/vnd.fujitsu.oasys3"
		map["fg5"] = "application/vnd.fujitsu.oasysgp"
		map["bh2"] = "application/vnd.fujitsu.oasysprs"
		map["ddd"] = "application/vnd.fujixerox.ddd"
		map["xdw"] = "application/vnd.fujixerox.docuworks"
		map["xbd"] = "application/vnd.fujixerox.docuworks.binder"
		map["fzs"] = "application/vnd.fuzzysheet"
		map["txd"] = "application/vnd.genomatix.tuxedo"
		map["ggb"] = "application/vnd.geogebra.file"
		map["ggt"] = "application/vnd.geogebra.tool"
		map["gex"] = "application/vnd.geometry-explorer"
		map["gxt"] = "application/vnd.geonext"
		map["g2w"] = "application/vnd.geoplan"
		map["g3w"] = "application/vnd.geospace"
		map["gmx"] = "application/vnd.gmx"
		map["kml"] = "application/vnd.google-earth.kml+xml"
		map["kmz"] = "application/vnd.google-earth.kmz"
		map["gqf"] = "application/vnd.grafeq"
		map["gac"] = "application/vnd.groove-account"
		map["ghf"] = "application/vnd.groove-help"
		map["gim"] = "application/vnd.groove-identity-message"
		map["grv"] = "application/vnd.groove-injector"
		map["gtm"] = "application/vnd.groove-tool-message"
		map["tpl"] = "application/vnd.groove-tool-template"
		map["vcg"] = "application/vnd.groove-vcard"
		map["hal"] = "application/vnd.hal+xml"
		map["zmm"] = "application/vnd.handheld-entertainment+xml"
		map["hbci"] = "application/vnd.hbci"
		map["les"] = "application/vnd.hhe.lesson-player"
		map["hpgl"] = "application/vnd.hp-hpgl"
		map["hpid"] = "application/vnd.hp-hpid"
		map["hps"] = "application/vnd.hp-hps"
		map["jlt"] = "application/vnd.hp-jlyt"
		map["pcl"] = "application/vnd.hp-pcl"
		map["pclxl"] = "application/vnd.hp-pclxl"
		map["sfd-hdstx"] = "application/vnd.hydrostatix.sof-data"
		map["x3d"] = "application/vnd.hzn-3d-crossword"
		map["mpy"] = "application/vnd.ibm.minipay"
		map["afp"] = "application/vnd.ibm.modcap"
		map["irm"] = "application/vnd.ibm.rights-management"
		map["sc"] = "application/vnd.ibm.secure-container"
		map["icc"] = "application/vnd.iccprofile"
		map["igl"] = "application/vnd.igloader"
		map["ivp"] = "application/vnd.immervision-ivp"
		map["ivu"] = "application/vnd.immervision-ivu"
		map["igm"] = "application/vnd.insors.igm"
		map["xpw"] = "application/vnd.intercon.formnet"
		map["i2g"] = "application/vnd.intergeo"
		map["qbo"] = "application/vnd.intu.qbo"
		map["qfx"] = "application/vnd.intu.qfx"
		map["rcprofile"] = "application/vnd.ipunplugged.rcprofile"
		map["irp"] = "application/vnd.irepository.package+xml"
		map["xpr"] = "application/vnd.is-xpr"
		map["fcs"] = "application/vnd.isac.fcs"
		map["jam"] = "application/vnd.jam"
		map["rms"] = "application/vnd.jcp.javame.midlet-rms"
		map["jisp"] = "application/vnd.jisp"
		map["joda"] = "application/vnd.joost.joda-archive"
		map["ktz"] = "application/vnd.kahootz"
		map["karbon"] = "application/vnd.kde.karbon"
		map["chrt"] = "application/vnd.kde.kchart"
		map["kfo"] = "application/vnd.kde.kformula"
		map["flw"] = "application/vnd.kde.kivio"
		map["kon"] = "application/vnd.kde.kontour"
		map["kpr"] = "application/vnd.kde.kpresenter"
		map["ksp"] = "application/vnd.kde.kspread"
		map["kwd"] = "application/vnd.kde.kword"
		map["htke"] = "application/vnd.kenameaapp"
		map["kia"] = "application/vnd.kidspiration"
		map["kne"] = "application/vnd.kinar"
		map["skp"] = "application/vnd.koan"
		map["sse"] = "application/vnd.kodak-descriptor"
		map["lasxml"] = "application/vnd.las.las+xml"
		map["lbd"] = "application/vnd.llamagraphics.life-balance.desktop"
		map["lbe"] = "application/vnd.llamagraphics.life-balance.exchange+xml"
		map["123"] = "application/vnd.lotus-1-2-3"
		map["apr"] = "application/vnd.lotus-approach"
		map["pre"] = "application/vnd.lotus-freelance"
		map["nsf"] = "application/vnd.lotus-notes"
		map["org"] = "application/vnd.lotus-organizer"
		map["scm"] = "application/vnd.lotus-screencam"
		map["lwp"] = "application/vnd.lotus-wordpro"
		map["portpkg"] = "application/vnd.macports.portpkg"
		map["mcd"] = "application/vnd.mcd"
		map["mc1"] = "application/vnd.medcalcdata"
		map["cdkey"] = "application/vnd.mediastation.cdkey"
		map["mwf"] = "application/vnd.mfer"
		map["mfm"] = "application/vnd.mfmp"
		map["flo"] = "application/vnd.micrografx.flo"
		map["igx"] = "application/vnd.micrografx.igx"
		map["mif"] = "application/vnd.mif"
		map["daf"] = "application/vnd.mobius.daf"
		map["dis"] = "application/vnd.mobius.dis"
		map["mbk"] = "application/vnd.mobius.mbk"
		map["mqy"] = "application/vnd.mobius.mqy"
		map["msl"] = "application/vnd.mobius.msl"
		map["plc"] = "application/vnd.mobius.plc"
		map["txf"] = "application/vnd.mobius.txf"
		map["mpn"] = "application/vnd.mophun.application"
		map["mpc"] = "application/vnd.mophun.certificate"
		map["xul"] = "application/vnd.mozilla.xul+xml"
		map["cil"] = "application/vnd.ms-artgalry"
		map["cab"] = "application/vnd.ms-cab-compressed"
		map["xls"] = "application/vnd.ms-excel"
		map["xlam"] = "application/vnd.ms-excel.addin.macroenabled.12"
		map["xlsb"] = "application/vnd.ms-excel.sheet.binary.macroenabled.12"
		map["xlsm"] = "application/vnd.ms-excel.sheet.macroenabled.12"
		map["xltm"] = "application/vnd.ms-excel.template.macroenabled.12"
		map["eot"] = "application/vnd.ms-fontobject"
		map["chm"] = "application/vnd.ms-htmlhelp"
		map["ims"] = "application/vnd.ms-ims"
		map["lrm"] = "application/vnd.ms-lrm"
		map["thmx"] = "application/vnd.ms-officetheme"
		map["cat"] = "application/vnd.ms-pki.seccat"
		map["stl"] = "application/vnd.ms-pki.stl"
		map["ppt"] = "application/vnd.ms-powerpoint"
		map["ppam"] = "application/vnd.ms-powerpoint.addin.macroenabled.12"
		map["pptm"] = "application/vnd.ms-powerpoint.presentation.macroenabled.12"
		map["sldm"] = "application/vnd.ms-powerpoint.slide.macroenabled.12"
		map["ppsm"] = "application/vnd.ms-powerpoint.slideshow.macroenabled.12"
		map["potm"] = "application/vnd.ms-powerpoint.template.macroenabled.12"
		map["mpp"] = "application/vnd.ms-project"
		map["docm"] = "application/vnd.ms-word.document.macroenabled.12"
		map["dotm"] = "application/vnd.ms-word.template.macroenabled.12"
		map["wps"] = "application/vnd.ms-works"
		map["wpl"] = "application/vnd.ms-wpl"
		map["xps"] = "application/vnd.ms-xpsdocument"
		map["mseq"] = "application/vnd.mseq"
		map["mus"] = "application/vnd.musician"
		map["msty"] = "application/vnd.muvee.style"
		map["nlu"] = "application/vnd.neurolanguage.nlu"
		map["nnd"] = "application/vnd.noblenet-directory"
		map["nns"] = "application/vnd.noblenet-sealer"
		map["nnw"] = "application/vnd.noblenet-web"
		map["ngdat"] = "application/vnd.nokia.n-gage.data"
		map["n-gage"] = "application/vnd.nokia.n-gage.symbian.install"
		map["rpst"] = "application/vnd.nokia.radio-preset"
		map["rpss"] = "application/vnd.nokia.radio-presets"
		map["edm"] = "application/vnd.novadigm.edm"
		map["edx"] = "application/vnd.novadigm.edx"
		map["ext"] = "application/vnd.novadigm.ext"
		map["odc"] = "application/vnd.oasis.opendocument.chart"
		map["otc"] = "application/vnd.oasis.opendocument.chart-template"
		map["odb"] = "application/vnd.oasis.opendocument.database"
		map["odf"] = "application/vnd.oasis.opendocument.formula"
		map["odft"] = "application/vnd.oasis.opendocument.formula-template"
		map["odg"] = "application/vnd.oasis.opendocument.graphics"
		map["otg"] = "application/vnd.oasis.opendocument.graphics-template"
		map["odi"] = "application/vnd.oasis.opendocument.image"
		map["oti"] = "application/vnd.oasis.opendocument.image-template"
		map["odp"] = "application/vnd.oasis.opendocument.presentation"
		map["otp"] = "application/vnd.oasis.opendocument.presentation-template"
		map["ods"] = "application/vnd.oasis.opendocument.spreadsheet"
		map["ots"] = "application/vnd.oasis.opendocument.spreadsheet-template"
		map["odt"] = "application/vnd.oasis.opendocument.text"
		map["odm"] = "application/vnd.oasis.opendocument.text-master"
		map["ott"] = "application/vnd.oasis.opendocument.text-template"
		map["oth"] = "application/vnd.oasis.opendocument.text-web"
		map["xo"] = "application/vnd.olpc-sugar"
		map["dd2"] = "application/vnd.oma.dd2+xml"
		map["oxt"] = "application/vnd.openofficeorg.extension"
		map["pptx"] = "application/vnd.openxmlformats-officedocument.presentationml.presentation"
		map["sldx"] = "application/vnd.openxmlformats-officedocument.presentationml.slide"
		map["ppsx"] = "application/vnd.openxmlformats-officedocument.presentationml.slideshow"
		map["potx"] = "application/vnd.openxmlformats-officedocument.presentationml.template"
		map["xlsx"] = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"
		map["xltx"] = "application/vnd.openxmlformats-officedocument.spreadsheetml.template"
		map["docx"] = "application/vnd.openxmlformats-officedocument.wordprocessingml.document"
		map["dotx"] = "application/vnd.openxmlformats-officedocument.wordprocessingml.template"
		map["mgp"] = "application/vnd.osgeo.mapguide.package"
		map["dp"] = "application/vnd.osgi.dp"
		map["pdb"] = "application/vnd.palm"
		map["paw"] = "application/vnd.pawaafile"
		map["str"] = "application/vnd.pg.format"
		map["ei6"] = "application/vnd.pg.osasli"
		map["efif"] = "application/vnd.picsel"
		map["wg"] = "application/vnd.pmi.widget"
		map["plf"] = "application/vnd.pocketlearn"
		map["pbd"] = "application/vnd.powerbuilder6"
		map["box"] = "application/vnd.previewsystems.box"
		map["mgz"] = "application/vnd.proteus.magazine"
		map["qps"] = "application/vnd.publishare-delta-tree"
		map["ptid"] = "application/vnd.pvi.ptid1"
		map["qxd"] = "application/vnd.quark.quarkxpress"
		map["bed"] = "application/vnd.realvnc.bed"
		map["mxl"] = "application/vnd.recordare.musicxml"
		map["musicxml"] = "application/vnd.recordare.musicxml+xml"
		map["cryptonote"] = "application/vnd.rig.cryptonote"
		map["cod"] = "application/vnd.rim.cod"
		map["rm"] = "application/vnd.rn-realmedia"
		map["link66"] = "application/vnd.route66.link66+xml"
		map["st"] = "application/vnd.sailingtracker.track"
		map["see"] = "application/vnd.seemail"
		map["sema"] = "application/vnd.sema"
		map["semd"] = "application/vnd.semd"
		map["semf"] = "application/vnd.semf"
		map["ifm"] = "application/vnd.shana.informed.formdata"
		map["itp"] = "application/vnd.shana.informed.formtemplate"
		map["iif"] = "application/vnd.shana.informed.interchange"
		map["ipk"] = "application/vnd.shana.informed.package"
		map["twd"] = "application/vnd.simtech-mindmapper"
		map["mmf"] = "application/vnd.smaf"
		map["teacher"] = "application/vnd.smart.teacher"
		map["sdkm"] = "application/vnd.solent.sdkm+xml"
		map["dxp"] = "application/vnd.spotfire.dxp"
		map["sfs"] = "application/vnd.spotfire.sfs"
		map["sdc"] = "application/vnd.stardivision.calc"
		map["sda"] = "application/vnd.stardivision.draw"
		map["sdd"] = "application/vnd.stardivision.impress"
		map["smf"] = "application/vnd.stardivision.math"
		map["sdw"] = "application/vnd.stardivision.writer"
		map["sgl"] = "application/vnd.stardivision.writer-global"
		map["sm"] = "application/vnd.stepmania.stepchart"
		map["sxc"] = "application/vnd.sun.xml.calc"
		map["stc"] = "application/vnd.sun.xml.calc.template"
		map["sxd"] = "application/vnd.sun.xml.draw"
		map["std"] = "application/vnd.sun.xml.draw.template"
		map["sxi"] = "application/vnd.sun.xml.impress"
		map["sti"] = "application/vnd.sun.xml.impress.template"
		map["sxm"] = "application/vnd.sun.xml.math"
		map["sxw"] = "application/vnd.sun.xml.writer"
		map["sxg"] = "application/vnd.sun.xml.writer.global"
		map["stw"] = "application/vnd.sun.xml.writer.template"
		map["sus"] = "application/vnd.sus-calendar"
		map["svd"] = "application/vnd.svd"
		map["sis"] = "application/vnd.symbian.install"
		map["xsm"] = "application/vnd.syncml+xml"
		map["bdm"] = "application/vnd.syncml.dm+wbxml"
		map["xdm"] = "application/vnd.syncml.dm+xml"
		map["tao"] = "application/vnd.tao.intent-module-archive"
		map["tmo"] = "application/vnd.tmobile-livetv"
		map["tpt"] = "application/vnd.trid.tpt"
		map["mxs"] = "application/vnd.triscape.mxs"
		map["tra"] = "application/vnd.trueapp"
		map["ufd"] = "application/vnd.ufdl"
		map["utz"] = "application/vnd.uiq.theme"
		map["umj"] = "application/vnd.umajin"
		map["unityweb"] = "application/vnd.unity"
		map["uoml"] = "application/vnd.uoml+xml"
		map["vcx"] = "application/vnd.vcx"
		map["vsd"] = "application/vnd.visio"
		map["vsdx"] = "application/vnd.visio2013"
		map["vis"] = "application/vnd.visionary"
		map["vsf"] = "application/vnd.vsf"
		map["wbxml"] = "application/vnd.wap.wbxml"
		map["wmlc"] = "application/vnd.wap.wmlc"
		map["wmlsc"] = "application/vnd.wap.wmlscriptc"
		map["wtb"] = "application/vnd.webturbo"
		map["nbp"] = "application/vnd.wolfram.player"
		map["wpd"] = "application/vnd.wordperfect"
		map["wqd"] = "application/vnd.wqd"
		map["stf"] = "application/vnd.wt.stf"
		map["xar"] = "application/vnd.xara"
		map["xfdl"] = "application/vnd.xfdl"
		map["hvd"] = "application/vnd.yamaha.hv-dic"
		map["hvs"] = "application/vnd.yamaha.hv-script"
		map["hvp"] = "application/vnd.yamaha.hv-voice"
		map["osf"] = "application/vnd.yamaha.openscoreformat"
		map["osfpvg"] = "application/vnd.yamaha.openscoreformat.osfpvg+xml"
		map["saf"] = "application/vnd.yamaha.smaf-audio"
		map["spf"] = "application/vnd.yamaha.smaf-phrase"
		map["cmp"] = "application/vnd.yellowriver-custom-menu"
		map["zir"] = "application/vnd.zul"
		map["zaz"] = "application/vnd.zzazz.deck+xml"
		map["vxml"] = "application/voicexml+xml"
		map["wgt"] = "application/widget"
		map["hlp"] = "application/winhlp"
		map["wsdl"] = "application/wsdl+xml"
		map["wspolicy"] = "application/wspolicy+xml"
		map["7z"] = "application/x-7z-compressed"
		map["abw"] = "application/x-abiword"
		map["ace"] = "application/x-ace-compressed"
		map["aab"] = "application/x-authorware-bin"
		map["aam"] = "application/x-authorware-map"
		map["aas"] = "application/x-authorware-seg"
		map["bcpio"] = "application/x-bcpio"
		map["torrent"] = "application/x-bittorrent"
		map["bz"] = "application/x-bzip"
		map["bz2"] = "application/x-bzip2"
		map["vcd"] = "application/x-cdlink"
		map["chat"] = "application/x-chat"
		map["pgn"] = "application/x-chess-pgn"
		map["cpio"] = "application/x-cpio"
		map["csh"] = "application/x-csh"
		map["deb"] = "application/x-debian-package"
		map["dir"] = "application/x-director"
		map["wad"] = "application/x-doom"
		map["ncx"] = "application/x-dtbncx+xml"
		map["dtb"] = "application/x-dtbook+xml"
		map["res"] = "application/x-dtbresource+xml"
		map["dvi"] = "application/x-dvi"
		map["bdf"] = "application/x-font-bdf"
		map["gsf"] = "application/x-font-ghostscript"
		map["psf"] = "application/x-font-linux-psf"
		map["otf"] = "application/x-font-otf"
		map["pcf"] = "application/x-font-pcf"
		map["snf"] = "application/x-font-snf"
		map["ttf"] = "application/x-font-ttf"
		map["pfa"] = "application/x-font-type1"
		map["woff"] = "application/x-font-woff"
		map["spl"] = "application/x-futuresplash"
		map["gnumeric"] = "application/x-gnumeric"
		map["gtar"] = "application/x-gtar"
		map["hdf"] = "application/x-hdf"
		map["jnlp"] = "application/x-java-jnlp-file"
		map["latex"] = "application/x-latex"
		map["prc"] = "application/x-mobipocket-ebook"
		map["application"] = "application/x-ms-application"
		map["wmd"] = "application/x-ms-wmd"
		map["wmz"] = "application/x-ms-wmz"
		map["xbap"] = "application/x-ms-xbap"
		map["mdb"] = "application/x-msaccess"
		map["obd"] = "application/x-msbinder"
		map["crd"] = "application/x-mscardfile"
		map["clp"] = "application/x-msclip"
		map["exe"] = "application/x-msdownload"
		map["mvb"] = "application/x-msmediaview"
		map["wmf"] = "application/x-msmetafile"
		map["mny"] = "application/x-msmoney"
		map["pub"] = "application/x-mspublisher"
		map["scd"] = "application/x-msschedule"
		map["trm"] = "application/x-msterminal"
		map["wri"] = "application/x-mswrite"
		map["nc"] = "application/x-netcdf"
		map["p12"] = "application/x-pkcs12"
		map["p7b"] = "application/x-pkcs7-certificates"
		map["p7r"] = "application/x-pkcs7-certreqresp"
		map["rar"] = "application/x-rar-compressed"
		map["sh"] = "application/x-sh"
		map["shar"] = "application/x-shar"
		map["swf"] = "application/x-shockwave-flash"
		map["xap"] = "application/x-silverlight-app"
		map["sit"] = "application/x-stuffit"
		map["qt"] = "video/quicktime"
		map["uvh"] = "video/vnd.dece.hd"
		map["mp4"] = "video/mp4"
		map["mpeg"] = "video/mpeg"
		map["ogv"] = "video/ogg"
		map["c"] = "text/x-c"
		map["f"] = "text/x-fortran"
		map["p"] = "text/x-pascal"
		map["java"] = "text/x-java-source"
		map["etx"] = "text/x-setext"
		map["uu"] = "text/x-uuencode"
		map["vcs"] = "text/x-vcalendar"
		map["vcf"] = "text/x-vcard"
		map["3gp"] = "video/3gpp"
		map["3g2"] = "video/3gpp2"
		map["h261"] = "video/h261"
		map["h263"] = "video/h263"
		map["h264"] = "video/h264"
		map["jpgv"] = "video/jpeg"
		map["jpm"] = "video/jpm"
		map["mj2"] = "video/mj2"
		map["uvm"] = "video/vnd.dece.mobile"
		map["uvp"] = "video/vnd.dece.pd"
		map["uvs"] = "video/vnd.dece.sd"
		map["uvv"] = "video/vnd.dece.video"
		map["fvt"] = "video/vnd.fvt"
		map["mxu"] = "video/vnd.mpegurl"
		map["pyv"] = "video/vnd.ms-playready.media.pyv"
		map["uvu"] = "video/vnd.uvvu.mp4"
		map["viv"] = "video/vnd.vivo"
		map["webm"] = "video/webm"
		map["f4v"] = "video/x-f4v"
		map["fli"] = "video/x-fli"
		map["flv"] = "video/x-flv"
		map["m4v"] = "video/x-m4v"
		map["asf"] = "video/x-ms-asf"
		map["wm"] = "video/x-ms-wm"
		map["wmv"] = "video/x-ms-wmv"
		map["wmx"] = "video/x-ms-wmx"
		map["wvx"] = "video/x-ms-wvx"
		map["avi"] = "video/x-msvideo"
		map["movie"] = "video/x-sgi-movie"
		map["ice"] = "x-conference/x-cooltalk"
		map["par"] = "text/plain-bas"
		map["yaml"] = "text/yaml"
		map["dmg"] = "application/x-apple-diskimage"
		map["tfm"] = "application/x-tex-tfm"
		map["texinfo"] = "application/x-texinfo"
		map["ustar"] = "application/x-ustar"
		map["src"] = "application/x-wais-source"
		map["der"] = "application/x-x509-ca-cert"
		map["fig"] = "application/x-xfig"
		map["sitx"] = "application/x-stuffitx"
		map["sv4cpio"] = "application/x-sv4cpio"
		map["sv4crc"] = "application/x-sv4crc"
		map["tar"] = "application/x-tar"
		map["tcl"] = "application/x-tcl"
		map["tex"] = "application/x-tex"
		map["gif"] = "image/gif"
		map["ief"] = "image/ief"
		map["jpeg"] = "image/jpeg"
		map["jpg"] = "image/jpeg"
		map["pjpeg"] = "image/pjpeg"
		map["ktx"] = "image/ktx"
		map["png"] = "image/png"
//		map["png"]=                   "image/x-png"
//		map["png"]=                   "image/x-citrix-png"
		map["btif"] = "image/prs.btif"
		map["svg"] = "image/svg+xml"
		map["tiff"] = "image/tiff"
		map["psd"] = "image/vnd.adobe.photoshop"
		map["uvi"] = "image/vnd.dece.graphic"
		map["sub"] = "image/vnd.dvb.subtitle"
		map["eml"] = "message/rfc822"
		map["igs"] = "model/iges"
		map["msh"] = "model/mesh"
		map["dae"] = "model/vnd.collada+xml"
		map["dwf"] = "model/vnd.dwf"
		map["gdl"] = "model/vnd.gdl"
		map["gtw"] = "model/vnd.gtw"
		map["mts"] = "model/vnd.mts"
		map["vtu"] = "model/vnd.vtu"
		map["wrl"] = "model/vrml"
		map["ics"] = "text/calendar"
		map["css"] = "text/css"
		map["csv"] = "text/csv"
		map["html"] = "text/html"
		map["n3"] = "text/n3"
		map["txt"] = "text/plain"
		map["dsc"] = "text/prs.lines.tag"
		map["rtx"] = "text/richtext"
		map["sgml"] = "text/sgml"
		map["tsv"] = "text/tab-separated-values"
		map["t"] = "text/troff"
		map["ttl"] = "text/turtle"
		map["uri"] = "text/uri-list"
		map["curl"] = "text/vnd.curl"
		map["dcurl"] = "text/vnd.curl.dcurl"
		map["scurl"] = "text/vnd.curl.scurl"
		map["mcurl"] = "text/vnd.curl.mcurl"
		map["fly"] = "text/vnd.fly"
		map["flx"] = "text/vnd.fmi.flexstor"
		map["gv"] = "text/vnd.graphviz"
		map["3dml"] = "text/vnd.in3d.3dml"
		map["spot"] = "text/vnd.in3d.spot"
		map["jad"] = "text/vnd.sun.j2me.app-descriptor"
		map["wml"] = "text/vnd.wap.wml"
		map["wmls"] = "text/vnd.wap.wmlscript"
		map["s"] = "text/x-asm"
		map["fpx"] = "image/vnd.fpx"
		map["fst"] = "image/vnd.fst"
		map["mmr"] = "image/vnd.fujixerox.edmics-mmr"
		map["rlc"] = "image/vnd.fujixerox.edmics-rlc"
		map["mdi"] = "image/vnd.ms-modi"
		map["npx"] = "image/vnd.net-fpx"
		map["wbmp"] = "image/vnd.wap.wbmp"
		map["xif"] = "image/vnd.xiff"
		map["webp"] = "image/webp"
		map["ras"] = "image/x-cmu-raster"
		map["cmx"] = "image/x-cmx"
		map["fh"] = "image/x-freehand"
		map["ico"] = "image/x-icon"
		map["pcx"] = "image/x-pcx"
		map["pic"] = "image/x-pict"
		map["pnm"] = "image/x-portable-anymap"
		map["pbm"] = "image/x-portable-bitmap"
		map["pgm"] = "image/x-portable-graymap"
		map["ppm"] = "image/x-portable-pixmap"
		map["rgb"] = "image/x-rgb"
		map["xbm"] = "image/x-xbitmap"
		map["xpm"] = "image/x-xpixmap"
		map["xwd"] = "image/x-xwindowdump"

	}
}