/*
 * Decompiled with CFR 0.152.
 */
package dev.entao.web.base;

import dev.entao.web.base.BaseUtilsKt;
import dev.entao.web.base.ChinaComparator;
import dev.entao.web.base.DateXKt;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u0086\u0001\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000b\u001a'\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u001b\"\u00020\u000b\u00a2\u0006\u0002\u0010\u001c\u001a'\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u001b\"\u00020\u000b\u00a2\u0006\u0002\u0010\u001c\u001a#\u0010\u001e\u001a\u00020\u001f2\u0016\u0010 \u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00160\u001b\"\u0004\u0018\u00010\u0016\u00a2\u0006\u0002\u0010!\u001a\u001a\u0010\"\u001a\u00020\u001f2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001f0$H\u0086\b\u00f8\u0001\u0000\u001a\u0010\u0010%\u001a\u00020\u000b2\b\b\u0002\u0010&\u001a\u00020\u000b\u001a\u0010\u0010'\u001a\u00020\u001f*\b\u0012\u0004\u0012\u00020\u000b0(\u001a,\u0010)\u001a\u00020\u001f\"\u0004\b\u0000\u0010**\b\u0012\u0004\u0012\u0002H*0(2\u0014\u0010#\u001a\u0010\u0012\u0004\u0012\u0002H*\u0012\u0006\u0012\u0004\u0018\u00010\u000b0+\u001a\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000b0-*\b\u0012\u0004\u0012\u00020\u000b0.\u001a2\u0010/\u001a\b\u0012\u0004\u0012\u0002H*0-\"\u0004\b\u0000\u0010**\b\u0012\u0004\u0012\u0002H*0.2\u0014\u0010#\u001a\u0010\u0012\u0004\u0012\u0002H*\u0012\u0006\u0012\u0004\u0018\u00010\u000b0+\u001a\u0017\u00100\u001a\u00020\u000b*\u0004\u0018\u00010\u000b2\u0006\u00101\u001a\u00020\u000bH\u0086\u0004\u001a\n\u00102\u001a\u000203*\u000203\u001a\u0012\u00104\u001a\u00020\u000b*\u0002052\u0006\u00106\u001a\u00020\u0001\u001a\u0012\u00107\u001a\u00020\u000b*\u00020\u000b2\u0006\u00106\u001a\u00020\u0001\u001a\u0018\u00108\u001a\u0004\u0018\u000109*\u0006\u0012\u0002\b\u00030:2\u0006\u0010;\u001a\u00020\u000b\u001a\u0018\u0010<\u001a\u0004\u0018\u00010\u000b*\u0006\u0012\u0002\b\u00030:2\u0006\u0010;\u001a\u00020\u000b\u001a;\u0010=\u001a\u0002H>\"\n\b\u0000\u0010**\u0004\u0018\u00010?\"\u0004\b\u0001\u0010>*\u0002H*2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u0002H*\u0012\u0004\u0012\u0002H>0+H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010@\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\"\u0015\u0010\n\u001a\u00020\u000b*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0015\u0010\n\u001a\u00020\u000b*\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000f\"\u0015\u0010\u0010\u001a\u00020\u000b*\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006A"}, d2={"GB", "", "KB", "MB", "chinaCollator", "Ljava/text/Collator;", "getChinaCollator", "()Ljava/text/Collator;", "chinaCollator$delegate", "Lkotlin/Lazy;", "fileSize", "", "getFileSize", "(I)Ljava/lang/String;", "", "(J)Ljava/lang/String;", "hexText", "Ljava/util/UUID;", "getHexText", "(Ljava/util/UUID;)Ljava/lang/String;", "dateDisplay", "v", "", "format", "joinPath", "path", "ps", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "joinURL", "printX", "", "vs", "([Ljava/lang/Object;)V", "safe", "block", "Lkotlin/Function0;", "tempFileName", "ext", "chinaSort", "", "chinaSortBy", "T", "Lkotlin/Function1;", "chinaSorted", "", "", "chinaSortedBy", "emp", "other", "ensureDirs", "Ljava/io/File;", "formatDot", "", "n", "keep", "resourceBytes", "", "Lkotlin/reflect/KClass;", "name", "resourceText", "useX", "R", "Ljava/lang/AutoCloseable;", "(Ljava/lang/AutoCloseable;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "WebBasic"})
public final class BaseUtilsKt {
    public static final int KB = 1024;
    public static final int MB = 0x100000;
    public static final int GB = 0x40000000;
    @NotNull
    private static final Lazy chinaCollator$delegate = LazyKt.lazy((Function0)chinaCollator.2.INSTANCE);

    public static final void safe(@NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$safe = false;
        try {
            block.invoke();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @NotNull
    public static final String tempFileName(@NotNull String ext) {
        String string;
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        if (((CharSequence)ext).length() == 0 || StringsKt.startsWith$default((CharSequence)ext, (char)'.', (boolean)false, (int)2, null)) {
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID()");
            string = BaseUtilsKt.getHexText(uUID) + ext;
        } else {
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID()");
            string = BaseUtilsKt.getHexText(uUID) + "." + ext;
        }
        return string;
    }

    public static /* synthetic */ String tempFileName$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return BaseUtilsKt.tempFileName(string);
    }

    @NotNull
    public static final String getHexText(@NotNull UUID $this$hexText) {
        Intrinsics.checkNotNullParameter((Object)$this$hexText, (String)"<this>");
        String string = "%x%x";
        Object[] objectArray = new Object[]{$this$hexText.getMostSignificantBits(), $this$hexText.getLeastSignificantBits()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    @NotNull
    public static final String dateDisplay(@NotNull Object v, @NotNull String format) {
        String string;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Object object = v;
        if (object instanceof Date) {
            String string2 = new SimpleDateFormat(format, Locale.getDefault()).format((Date)v);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SimpleDateFormat(format,\u2026e.getDefault()).format(v)");
        } else if (object instanceof Long) {
            String string3 = new SimpleDateFormat(format, Locale.getDefault()).format(new Date(((Number)v).longValue()));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"SimpleDateFormat(format,\u2026format(java.util.Date(v))");
        } else {
            string = object instanceof LocalDate ? DateXKt.format((LocalDate)v, format) : (object instanceof LocalDateTime ? DateXKt.format((LocalDateTime)v, format) : (object instanceof LocalTime ? DateXKt.format((LocalTime)v, format) : v.toString()));
        }
        return string;
    }

    @NotNull
    public static final String getFileSize(int $this$fileSize) {
        return BaseUtilsKt.getFileSize((long)$this$fileSize);
    }

    @NotNull
    public static final String getFileSize(long $this$fileSize) {
        return $this$fileSize > 0x40000000L ? BaseUtilsKt.keep(String.valueOf((double)$this$fileSize * 1.0 / (double)0x40000000), 2) + "G" : ($this$fileSize > 0x100000L ? BaseUtilsKt.keep(String.valueOf((double)$this$fileSize * 1.0 / (double)0x100000), 2) + "M" : ($this$fileSize > 1024L ? BaseUtilsKt.keep(String.valueOf((double)$this$fileSize * 1.0 / (double)1024), 2) + "K" : $this$fileSize + "\u5b57\u8282"));
    }

    @NotNull
    public static final String keep(@NotNull String $this$keep, int n) {
        Intrinsics.checkNotNullParameter((Object)$this$keep, (String)"<this>");
        int idx = StringsKt.indexOf$default((CharSequence)$this$keep, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (idx < 0 || idx + n + 1 >= $this$keep.length()) {
            return $this$keep;
        }
        String string = $this$keep.substring(0, idx + n + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    @NotNull
    public static final String formatDot(double $this$formatDot, int n) {
        String string;
        if (n > 0) {
            String string2 = "%." + n + "f";
            Object[] objectArray = new Object[]{$this$formatDot};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
        } else {
            string = String.valueOf((int)$this$formatDot);
        }
        return string;
    }

    @NotNull
    public static final String joinPath(@NotNull String path, String ... ps) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)ps, (String)"ps");
        Object sb = path;
        for (String p : ps) {
            char[] cArray = new char[]{'/', '\\'};
            sb = StringsKt.trimEnd((String)sb, (char[])cArray);
            sb = (String)sb + File.separatorChar;
            cArray = new char[]{'/', '\\'};
            sb = (String)sb + StringsKt.trimStart((String)p, (char[])cArray);
        }
        return sb;
    }

    @NotNull
    public static final String joinURL(@NotNull String path, String ... ps) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)ps, (String)"ps");
        Object sb = path;
        for (String p : ps) {
            char[] cArray = new char[]{'/'};
            sb = StringsKt.trimEnd((String)sb, (char[])cArray);
            sb = (String)sb + "/";
            cArray = new char[]{'/'};
            sb = (String)sb + StringsKt.trimStart((String)p, (char[])cArray);
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final byte[] resourceBytes(@NotNull KClass<?> $this$resourceBytes, @NotNull String name) {
        Intrinsics.checkNotNullParameter($this$resourceBytes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        InputStream inputStream = JvmClassMappingKt.getJavaClass($this$resourceBytes).getClassLoader().getResourceAsStream(name);
        if (inputStream == null) {
            return null;
        }
        InputStream i = inputStream;
        Closeable closeable = i;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            byte[] byArray = ByteStreamsKt.readBytes((InputStream)it);
            return byArray;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final String resourceText(@NotNull KClass<?> $this$resourceText, @NotNull String name) {
        Intrinsics.checkNotNullParameter($this$resourceText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        InputStream inputStream = JvmClassMappingKt.getJavaClass($this$resourceText).getClassLoader().getResourceAsStream(name);
        if (inputStream == null) {
            return null;
        }
        InputStream i = inputStream;
        Closeable closeable = i;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            String string = new String(ByteStreamsKt.readBytes((InputStream)it), Charsets.UTF_8);
            return string;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final File ensureDirs(@NotNull File $this$ensureDirs) {
        Intrinsics.checkNotNullParameter((Object)$this$ensureDirs, (String)"<this>");
        if (!$this$ensureDirs.exists()) {
            $this$ensureDirs.mkdirs();
        }
        return $this$ensureDirs;
    }

    public static final void printX(Object ... vs2) {
        Intrinsics.checkNotNullParameter((Object)vs2, (String)"vs");
        String s2 = ArraysKt.joinToString$default((Object[])vs2, (CharSequence)" ", null, null, (int)0, null, (Function1)printX.s.1.INSTANCE, (int)30, null);
        System.out.println((Object)s2);
    }

    @NotNull
    public static final Collator getChinaCollator() {
        Lazy lazy = chinaCollator$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-chinaCollator>(...)");
        return (Collator)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T extends AutoCloseable, R> R useX(T $this$useX, @NotNull Function1<? super T, ? extends R> block) {
        Object object;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$useX = false;
        boolean closed = false;
        try {
            object = block.invoke($this$useX);
        }
        catch (Exception e) {
            try {
                closed = true;
                try {
                    T t = $this$useX;
                    if (t != null) {
                        t.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
            catch (Throwable throwable) {
                InlineMarker.finallyStart((int)1);
                if (!closed) {
                    T t = $this$useX;
                    if (t != null) {
                        t.close();
                    }
                }
                InlineMarker.finallyEnd((int)1);
                throw throwable;
            }
        }
        InlineMarker.finallyStart((int)1);
        T t = $this$useX;
        if (t != null) {
            t.close();
        }
        InlineMarker.finallyEnd((int)1);
        return (R)object;
    }

    public static final void chinaSort(@NotNull List<String> $this$chinaSort) {
        Intrinsics.checkNotNullParameter($this$chinaSort, (String)"<this>");
        CollectionsKt.sortWith($this$chinaSort, (Comparator)BaseUtilsKt.getChinaCollator());
    }

    @NotNull
    public static final List<String> chinaSorted(@NotNull Iterable<String> $this$chinaSorted) {
        Intrinsics.checkNotNullParameter($this$chinaSorted, (String)"<this>");
        return CollectionsKt.sortedWith($this$chinaSorted, (Comparator)BaseUtilsKt.getChinaCollator());
    }

    public static final <T> void chinaSortBy(@NotNull List<T> $this$chinaSortBy, @NotNull Function1<? super T, String> block) {
        Intrinsics.checkNotNullParameter($this$chinaSortBy, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        ChinaComparator<? super T> cmp = new ChinaComparator<T>(block);
        CollectionsKt.sortWith($this$chinaSortBy, (Comparator)cmp);
    }

    @NotNull
    public static final <T> List<T> chinaSortedBy(@NotNull Iterable<? extends T> $this$chinaSortedBy, @NotNull Function1<? super T, String> block) {
        Intrinsics.checkNotNullParameter($this$chinaSortedBy, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        ChinaComparator<? super T> cmp = new ChinaComparator<T>(block);
        return CollectionsKt.sortedWith($this$chinaSortedBy, (Comparator)cmp);
    }

    @NotNull
    public static final String emp(@Nullable String $this$emp, @NotNull String other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if ($this$emp == null || ((CharSequence)$this$emp).length() == 0) {
            return other;
        }
        return $this$emp;
    }
}

