/*
 * Decompiled with CFR 0.152.
 */
package dev.entao.web.base;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0002\b\r\u0018\u0000 ]2\u00020\u0001:\u0001]B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010H\u001a\u00020\u00002\u0006\u0010I\u001a\u00020\u0014J\u000e\u0010J\u001a\u00020\u00002\u0006\u0010I\u001a\u00020\u0014J\u000e\u0010K\u001a\u00020\u00002\u0006\u0010I\u001a\u00020\u0014J\u000e\u0010L\u001a\u00020\u00002\u0006\u0010I\u001a\u00020\u0014J\u000e\u0010M\u001a\u00020\u00002\u0006\u0010I\u001a\u00020\u0014J\u000e\u0010N\u001a\u00020\u00002\u0006\u0010I\u001a\u00020\u0014J\u000e\u0010O\u001a\u00020\u00002\u0006\u0010I\u001a\u00020\u0014J\u000e\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020QJ\u0006\u0010S\u001a\u00020QJ\u0006\u0010T\u001a\u00020QJ\u0006\u0010U\u001a\u00020QJ\u000e\u0010V\u001a\u00020Q2\u0006\u0010W\u001a\u00020\u0003J\u0006\u0010X\u001a\u00020QJ\u0006\u0010Y\u001a\u00020QJ\u0006\u0010Z\u001a\u00020QJ\u0006\u0010[\u001a\u00020QJ\u0006\u0010\\\u001a\u00020QR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R$\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00148F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R$\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00148F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R$\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00148F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u0017\"\u0004\b\u001f\u0010\u0019R\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\"R\u0011\u0010#\u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\"R\u0011\u0010$\u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\"R\u0011\u0010%\u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\"R\u0011\u0010&\u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\"R\u0011\u0010'\u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\"R\u0011\u0010(\u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\"R$\u0010)\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R$\u0010.\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00148F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b/\u0010\u0017\"\u0004\b0\u0010\u0019R$\u00101\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00148F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b2\u0010\u0017\"\u0004\b3\u0010\u0019R$\u00104\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00148F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b5\u0010\u0017\"\u0004\b6\u0010\u0019R$\u00107\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00148F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b8\u0010\u0017\"\u0004\b9\u0010\u0019R\u0011\u0010:\u001a\u00020;8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u0011\u0010>\u001a\u00020?8F\u00a2\u0006\u0006\u001a\u0004\b@\u0010AR$\u0010B\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00148F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bC\u0010\u0017\"\u0004\bD\u0010\u0019R$\u0010E\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00148F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bF\u0010\u0017\"\u0004\bG\u0010\u0019\u00a8\u0006^"}, d2={"Ldev/entao/web/base/DateX;", "", "tm", "", "timeZone", "Ljava/util/TimeZone;", "(JLjava/util/TimeZone;)V", "calendar", "Ljava/util/Calendar;", "getCalendar", "()Ljava/util/Calendar;", "date", "Ljava/util/Date;", "getDate", "()Ljava/util/Date;", "dateSQL", "Ljava/sql/Date;", "getDateSQL", "()Ljava/sql/Date;", "value", "", "day", "getDay", "()I", "setDay", "(I)V", "dayOfYear", "getDayOfYear", "setDayOfYear", "hour", "getHour", "setHour", "isFriday", "", "()Z", "isMonday", "isSaturday", "isSunday", "isThursday", "isTuesday", "isWednesday", "longValue", "getLongValue", "()J", "setLongValue", "(J)V", "millSecond", "getMillSecond", "setMillSecond", "minute", "getMinute", "setMinute", "month", "getMonth", "setMonth", "second", "getSecond", "setSecond", "time", "Ljava/sql/Time;", "getTime", "()Ljava/sql/Time;", "timestamp", "Ljava/sql/Timestamp;", "getTimestamp", "()Ljava/sql/Timestamp;", "week", "getWeek", "setWeek", "year", "getYear", "setYear", "addDay", "n", "addHour", "addMillSecond", "addMinute", "addMonth", "addSecond", "addYear", "format", "", "pattern", "formatDate", "formatDateTime", "formatDateTimeX", "formatDuration", "seconds", "formatShort", "formatTemp", "formatTime", "formatTimeX", "formatTimestamp", "Companion", "WebBasic"})
public final class DateX {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Calendar calendar;
    public static final int MINUTE_MILL = 60000;
    public static final int HOUR_MILL = 3600000;
    @NotNull
    public static final String FORMAT_DATE = "yyyy-MM-dd";
    @NotNull
    public static final String FORMAT_DATE8 = "yyyyMMdd";
    @NotNull
    public static final String FORMAT_TIME = "HH:mm:ss";
    @NotNull
    public static final String FORMAT_TIME_X = "HH:mm:ss.SSS";
    @NotNull
    public static final String FORMAT_DATE_TIME = "yyyy-MM-dd HH:mm:ss";
    @NotNull
    public static final String FORMAT_DATE_TIME_NO_SEC = "yyyy-MM-dd HH:mm";
    @NotNull
    public static final String FORMAT_DATE_TIME_X = "yyyy-MM-dd HH:mm:ss.SSS";
    @NotNull
    public static final String FORMAT_TIMESTAMP = "yyyy-MM-dd HH:mm:ss.SSS";

    public DateX(long tm, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        Calendar calendar = Calendar.getInstance(timeZone);
        Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"getInstance(timeZone)");
        this.calendar = calendar;
        this.calendar.setTimeInMillis(tm);
    }

    public /* synthetic */ DateX(long l, TimeZone timeZone, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = System.currentTimeMillis();
        }
        if ((n & 2) != 0) {
            TimeZone timeZone2 = TimeZone.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)timeZone2, (String)"getDefault()");
            timeZone = timeZone2;
        }
        this(l, timeZone);
    }

    @NotNull
    public final Calendar getCalendar() {
        return this.calendar;
    }

    @NotNull
    public final Date getDate() {
        return new Date(this.getLongValue());
    }

    @NotNull
    public final java.sql.Date getDateSQL() {
        return new java.sql.Date(this.getLongValue());
    }

    @NotNull
    public final Time getTime() {
        return new Time(this.getLongValue());
    }

    @NotNull
    public final Timestamp getTimestamp() {
        return new Timestamp(this.getLongValue());
    }

    public final long getLongValue() {
        return this.calendar.getTimeInMillis();
    }

    public final void setLongValue(long value) {
        this.calendar.setTimeInMillis(value);
    }

    public final int getYear() {
        return this.calendar.get(1);
    }

    public final void setYear(int value) {
        this.calendar.set(1, value);
    }

    public final int getMonth() {
        return this.calendar.get(2);
    }

    public final void setMonth(int value) {
        this.calendar.set(2, value);
    }

    public final int getDay() {
        return this.calendar.get(5);
    }

    public final void setDay(int value) {
        this.calendar.set(5, value);
    }

    public final int getDayOfYear() {
        return this.calendar.get(6);
    }

    public final void setDayOfYear(int value) {
        this.calendar.set(6, value);
    }

    public final int getHour() {
        return this.calendar.get(11);
    }

    public final void setHour(int value) {
        this.calendar.set(11, value);
    }

    public final int getMinute() {
        return this.calendar.get(12);
    }

    public final void setMinute(int value) {
        this.calendar.set(12, value);
    }

    public final int getSecond() {
        return this.calendar.get(13);
    }

    public final void setSecond(int value) {
        this.calendar.set(13, value);
    }

    public final int getMillSecond() {
        return this.calendar.get(14);
    }

    public final void setMillSecond(int value) {
        this.calendar.set(14, value);
    }

    public final int getWeek() {
        return this.calendar.get(7);
    }

    public final void setWeek(int value) {
        this.calendar.set(7, value);
    }

    public final boolean isSunday() {
        return this.getWeek() == 1;
    }

    public final boolean isMonday() {
        return this.getWeek() == 2;
    }

    public final boolean isTuesday() {
        return this.getWeek() == 3;
    }

    public final boolean isWednesday() {
        return this.getWeek() == 4;
    }

    public final boolean isThursday() {
        return this.getWeek() == 5;
    }

    public final boolean isFriday() {
        return this.getWeek() == 6;
    }

    public final boolean isSaturday() {
        return this.getWeek() == 7;
    }

    @NotNull
    public final DateX addYear(int n) {
        this.calendar.add(1, n);
        return this;
    }

    @NotNull
    public final DateX addMonth(int n) {
        this.calendar.add(2, n);
        return this;
    }

    @NotNull
    public final DateX addDay(int n) {
        this.calendar.add(5, n);
        return this;
    }

    @NotNull
    public final DateX addHour(int n) {
        this.calendar.add(11, n);
        return this;
    }

    @NotNull
    public final DateX addMinute(int n) {
        this.calendar.add(12, n);
        return this;
    }

    @NotNull
    public final DateX addSecond(int n) {
        this.calendar.add(13, n);
        return this;
    }

    @NotNull
    public final DateX addMillSecond(int n) {
        this.calendar.add(14, n);
        return this;
    }

    @NotNull
    public final String formatDateTime() {
        return this.format(FORMAT_DATE_TIME);
    }

    @NotNull
    public final String formatDateTimeX() {
        return this.format("yyyy-MM-dd HH:mm:ss.SSS");
    }

    @NotNull
    public final String formatDate() {
        return this.format(FORMAT_DATE);
    }

    @NotNull
    public final String formatTime() {
        return this.format(FORMAT_TIME);
    }

    @NotNull
    public final String formatTimeX() {
        return this.format(FORMAT_TIME_X);
    }

    @NotNull
    public final String formatTimestamp() {
        return this.format("yyyy-MM-dd HH:mm:ss.SSS");
    }

    @NotNull
    public final String format(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return Companion.format(this.getLongValue(), pattern);
    }

    @NotNull
    public final String formatShort() {
        DateX now = new DateX(0L, null, 3, null);
        if (now.getYear() != this.getYear()) {
            return this.formatDate();
        }
        if (now.getDayOfYear() != this.getDayOfYear()) {
            return this.format("M-d");
        }
        return this.format("H:mm");
    }

    @NotNull
    public final String formatDuration(long seconds) {
        if (seconds < 60L) {
            return seconds + "\u79d2";
        }
        if (seconds < 3600L) {
            return seconds / (long)60 + "\u5206" + seconds % (long)60 + "\u79d2";
        }
        return seconds / (long)3600 + "\u65f6" + seconds % (long)3600 / (long)60 + "\u5206" + seconds % (long)60 + "\u79d2";
    }

    @NotNull
    public final String formatTemp() {
        return this.format("yyyyMMdd_HHmmss_SSS");
    }

    public DateX() {
        this(0L, null, 3, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004J\u0016\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rJ\u001e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\rJ \u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\r2\b\b\u0002\u0010\u001a\u001a\u00020\rJ\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0004J\u0012\u0010 \u001a\u0004\u0018\u00010\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0004J\u0012\u0010!\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0004J\u0012\u0010\"\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0004J\u0012\u0010#\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0004J\u0012\u0010$\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Ldev/entao/web/base/DateX$Companion;", "", "()V", "FORMAT_DATE", "", "FORMAT_DATE8", "FORMAT_DATE_TIME", "FORMAT_DATE_TIME_NO_SEC", "FORMAT_DATE_TIME_X", "FORMAT_TIME", "FORMAT_TIMESTAMP", "FORMAT_TIME_X", "HOUR_MILL", "", "MINUTE_MILL", "format", "date", "", "pattern", "makeDate", "year", "month", "day", "makeTime", "hour", "minute", "second", "parse", "Ldev/entao/web/base/DateX;", "dateStr", "parseDate", "s", "parseDateTime", "parseDateTimeX", "parseTime", "parseTimeX", "parseTimestamp", "WebBasic"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String format(long date, @NotNull String pattern) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            SimpleDateFormat ff = new SimpleDateFormat(pattern, Locale.getDefault());
            String string = ff.format(new Date(date));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ff.format(Date(date))");
            return string;
        }

        public final long makeDate(int year, int month, int day) {
            Calendar c2 = Calendar.getInstance(Locale.getDefault());
            c2.setTimeInMillis(0L);
            c2.set(year, month, day);
            return c2.getTimeInMillis();
        }

        public final long makeDate(int year, int month) {
            Calendar c2 = Calendar.getInstance(Locale.getDefault());
            c2.setTimeInMillis(0L);
            c2.set(year, month, 1);
            return c2.getTimeInMillis();
        }

        public final long makeTime(int hour, int minute, int second) {
            Calendar c2 = Calendar.getInstance(Locale.getDefault());
            c2.setTimeInMillis(0L);
            c2.set(0, 0, 0, hour, minute, second);
            return c2.getTimeInMillis();
        }

        public static /* synthetic */ long makeTime$default(Companion companion, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 4) != 0) {
                n3 = 0;
            }
            return companion.makeTime(n, n2, n3);
        }

        @Nullable
        public final DateX parse(@NotNull String format, @NotNull String dateStr) {
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            Intrinsics.checkNotNullParameter((Object)dateStr, (String)"dateStr");
            SimpleDateFormat ff = new SimpleDateFormat(format, Locale.getDefault());
            try {
                Date d = ff.parse(dateStr);
                if (d != null) {
                    return new DateX(d.getTime(), null, 2, null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        @Nullable
        public final DateX parseTime(@Nullable String s2) {
            if (s2 == null || s2.length() < 6) {
                return null;
            }
            return this.parse(DateX.FORMAT_TIME, s2);
        }

        @Nullable
        public final DateX parseTimeX(@Nullable String s2) {
            if (s2 == null || s2.length() < 6) {
                return null;
            }
            return this.parse(DateX.FORMAT_TIME_X, s2);
        }

        @Nullable
        public final DateX parseDate(@Nullable String s2) {
            if (s2 == null || s2.length() < 6) {
                return null;
            }
            return this.parse(DateX.FORMAT_DATE, s2);
        }

        @Nullable
        public final DateX parseDateTime(@Nullable String s2) {
            if (s2 == null || s2.length() < 6) {
                return null;
            }
            return this.parse(DateX.FORMAT_DATE_TIME, s2);
        }

        @Nullable
        public final DateX parseDateTimeX(@Nullable String s2) {
            if (s2 == null || s2.length() < 6) {
                return null;
            }
            return this.parse("yyyy-MM-dd HH:mm:ss.SSS", s2);
        }

        @Nullable
        public final DateX parseTimestamp(@Nullable String s2) {
            if (s2 == null || s2.length() < 6) {
                return null;
            }
            return this.parse("yyyy-MM-dd HH:mm:ss.SSS", s2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

