/*
 * Decompiled with CFR 0.152.
 */
package dev.entao.web.base;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003J\u000e\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003J\u0006\u0010\u0010\u001a\u00020\u0000J\u0006\u0010\u0011\u001a\u00020\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Ldev/entao/web/base/DesCbc;", "", "key", "", "([B)V", "algo", "", "getAlgo", "()Ljava/lang/String;", "setAlgo", "(Ljava/lang/String;)V", "getKey", "()[B", "decode", "data", "encode", "noPadding", "pkcs5", "WebBasic"})
public final class DesCbc {
    @NotNull
    private final byte[] key;
    @NotNull
    private String algo;

    public DesCbc(@NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.key = key;
        this.algo = "DES/CBC/NoPadding";
    }

    @NotNull
    public final byte[] getKey() {
        return this.key;
    }

    @NotNull
    public final String getAlgo() {
        return this.algo;
    }

    public final void setAlgo(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.algo = string;
    }

    @NotNull
    public final DesCbc noPadding() {
        this.algo = "DES/CBC/NoPadding";
        return this;
    }

    @NotNull
    public final DesCbc pkcs5() {
        this.algo = "DES/CBC/PKCS5Padding";
        return this;
    }

    @NotNull
    public final byte[] encode(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        SecretKey securekey = SecretKeyFactory.getInstance("DES").generateSecret(new DESKeySpec(this.key));
        Cipher cipher = Cipher.getInstance(this.algo);
        cipher.init(1, (Key)securekey, new IvParameterSpec(this.key));
        byte[] byArray = cipher.doFinal(data);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cipher.doFinal(data)");
        return byArray;
    }

    @NotNull
    public final byte[] decode(@NotNull byte[] data) throws Exception {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        SecretKey securekey = SecretKeyFactory.getInstance("DES").generateSecret(new DESKeySpec(this.key));
        Cipher cipher = Cipher.getInstance(this.algo);
        cipher.init(2, (Key)securekey, new IvParameterSpec(this.key));
        byte[] byArray = cipher.doFinal(data);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cipher.doFinal(data)");
        return byArray;
    }
}

