/*
 * Decompiled with CFR 0.152.
 */
package dev.entao.web.base;

import dev.entao.web.base.StringExtKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/entao/web/base/Hex;", "", "()V", "DICT", "", "decode", "", "hexString", "encode", "bytes", "b", "", "toByte", "ch", "", "WebBasic"})
public final class Hex {
    @NotNull
    public static final Hex INSTANCE = new Hex();
    @NotNull
    private static final String DICT = "0123456789ABCDEF";

    private Hex() {
    }

    @NotNull
    public final String encode(int b) {
        char[] arr = new char[]{DICT.charAt(0xF & b >>> 4), DICT.charAt(0xF & b)};
        return new String(arr);
    }

    @NotNull
    public final String encode(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        StringBuilder ret = new StringBuilder(2 * bytes.length);
        int n = bytes.length;
        for (int i = 0; i < n; ++i) {
            byte a2;
            byte n2 = a2 = bytes[i];
            ret.append(DICT.charAt(0xF & n2 >>> 4));
            ret.append(DICT.charAt(0xF & n2));
        }
        String string = ret.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ret.toString()");
        return string;
    }

    @Nullable
    public final byte[] decode(@Nullable String hexString) {
        if (hexString == null) {
            return null;
        }
        int strLen = hexString.length();
        if (strLen == 0) {
            return new byte[0];
        }
        if (strLen % 2 != 0) {
            throw new IllegalArgumentException("\u5b57\u7b26\u4e32\u957f\u5ea6\u5fc5\u987b\u662f2\u7684\u500d\u6570");
        }
        String s2 = StringExtKt.getUpperCased(hexString);
        byte[] bytes = new byte[strLen / 2];
        for (int i = 0; i < strLen; i += 2) {
            int hi = this.toByte(s2.charAt(i));
            int lo = this.toByte(s2.charAt(i + 1));
            int n = hi << 4 & 0xF0 | lo & 0xF;
            bytes[i / 2] = (byte)n;
        }
        return bytes;
    }

    public final int toByte(char ch) {
        boolean bl = '0' <= ch ? ch < ':' : false;
        if (bl) {
            return ch - 48;
        }
        boolean bl2 = 'A' <= ch ? ch < 'G' : false;
        if (bl2) {
            return ch - 65 + 10;
        }
        boolean bl3 = 'a' <= ch ? ch < 'g' : false;
        if (bl3) {
            return ch - 97 + 10;
        }
        throw new IllegalArgumentException("\u4e0d\u5408\u6cd5\u7684\u5b57\u7b26" + ch);
    }
}

