/*
 * Decompiled with CFR 0.152.
 */
package dev.entao.web.base;

import dev.entao.web.base.Progress;
import dev.entao.web.base.ProgressKt;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a8\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u001a\n\u0010\r\u001a\u00020\u0001*\u00020\u000e\u00a8\u0006\u000f"}, d2={"copyStream", "", "input", "Ljava/io/InputStream;", "closeIs", "", "os", "Ljava/io/OutputStream;", "closeOs", "total", "", "progress", "Ldev/entao/web/base/Progress;", "closeSafe", "Ljava/lang/AutoCloseable;", "WebBasic"})
public final class IOUtilsKt {
    public static final void closeSafe(@NotNull AutoCloseable $this$closeSafe) {
        Intrinsics.checkNotNullParameter((Object)$this$closeSafe, (String)"<this>");
        try {
            $this$closeSafe.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copyStream(@NotNull InputStream input, boolean closeIs, @NotNull OutputStream os, boolean closeOs, int total, @Nullable Progress progress) throws IOException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        try {
            Progress progress2 = progress;
            if (progress2 != null) {
                progress2.onStart(total);
            }
            byte[] buf = new byte[4096];
            long pre = System.currentTimeMillis();
            int recv = 0;
            int n = input.read(buf);
            while (n != -1) {
                long curr;
                os.write(buf, 0, n);
                recv += n;
                if (progress != null && (curr = System.currentTimeMillis()) - pre > (long)ProgressKt.getPROGRESS_DELAY()) {
                    pre = curr;
                    progress.onProgress(recv, total, total > 0 ? recv * 100 / total : 0);
                }
                n = input.read(buf);
            }
            os.flush();
            Progress progress3 = progress;
            if (progress3 != null) {
                progress3.onProgress(recv, total, total > 0 ? recv * 100 / total : 0);
            }
            Progress progress4 = progress;
            if (progress4 != null) {
                progress4.onFinish(true);
            }
        }
        catch (Exception ex) {
            Progress progress5 = progress;
            if (progress5 != null) {
                progress5.onFinish(false);
            }
        }
        finally {
            if (closeIs) {
                IOUtilsKt.closeSafe(input);
            }
            if (closeOs) {
                IOUtilsKt.closeSafe(os);
            }
        }
    }
}

