/*
 * Decompiled with CFR 0.152.
 */
package dev.entao.web.base;

import dev.entao.web.base.DateX;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\t\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\u000eJ\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u001a\u001a\u00020\u000eJ\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00000\u00062\u0006\u0010\u001a\u001a\u00020\u000eR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00000\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00000\u00068F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014\u00a8\u0006\u001b"}, d2={"Ldev/entao/web/base/NodeInfo;", "", "node", "Lorg/w3c/dom/Node;", "(Lorg/w3c/dom/Node;)V", "elements", "", "getElements", "()Ljava/util/List;", "getNode", "()Lorg/w3c/dom/Node;", "nodes", "getNodes", "text", "", "getText", "()Ljava/lang/String;", "textDate", "", "getTextDate", "()J", "textDateTime", "getTextDateTime", "attr", "key", "element", "tagName", "WebBasic"})
public final class NodeInfo {
    @NotNull
    private final Node node;

    public NodeInfo(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.node = node;
    }

    @NotNull
    public final Node getNode() {
        return this.node;
    }

    @Nullable
    public final NodeInfo element(@NotNull String tagName) {
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        if (this.node instanceof Element) {
            NodeList nodeList = ((Element)this.node).getElementsByTagName(tagName);
            if (nodeList == null) {
                return null;
            }
            NodeList ls2 = nodeList;
            if (ls2.getLength() > 0) {
                Node node = ls2.item(0);
                Intrinsics.checkNotNullExpressionValue((Object)node, (String)"ls.item(0)");
                return new NodeInfo(node);
            }
        }
        return null;
    }

    @NotNull
    public final List<NodeInfo> elements(@NotNull String tagName) {
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        ArrayList es = new ArrayList();
        if (this.node instanceof Element) {
            NodeList nodeList = ((Element)this.node).getElementsByTagName(tagName);
            if (nodeList == null) {
                return es;
            }
            NodeList ls2 = nodeList;
            int n = ls2.getLength();
            for (int i = 0; i < n; ++i) {
                Node e = ls2.item(i);
                Collection collection = es;
                Intrinsics.checkNotNullExpressionValue((Object)e, (String)"e");
                collection.add(new NodeInfo(e));
            }
        }
        return es;
    }

    @NotNull
    public final List<NodeInfo> getElements() {
        ArrayList ls2 = new ArrayList();
        NodeList nodes = this.node.getChildNodes();
        int n = nodes.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            ((Collection)ls2).add(new NodeInfo(node));
        }
        return ls2;
    }

    @NotNull
    public final List<NodeInfo> getNodes() {
        ArrayList ls2 = new ArrayList();
        NodeList nodes = this.node.getChildNodes();
        int n = nodes.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodes.item(i);
            Collection collection = ls2;
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"node");
            collection.add(new NodeInfo(node));
        }
        return ls2;
    }

    @Nullable
    public final String attr(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (this.node instanceof Element) {
            return ((Element)this.node).getAttribute(key);
        }
        return null;
    }

    @Nullable
    public final String getText() {
        return this.node.getTextContent();
    }

    public final long getTextDateTime() {
        String string = this.getText();
        if (string == null) {
            return 0L;
        }
        String s2 = string;
        DateX dateX = DateX.Companion.parseDateTime(s2);
        return dateX != null ? dateX.getLongValue() : 0L;
    }

    public final long getTextDate() {
        String string = this.getText();
        if (string == null) {
            return 0L;
        }
        String s2 = string;
        DateX dateX = DateX.Companion.parseDate(s2);
        return dateX != null ? dateX.getLongValue() : 0L;
    }
}

