/*
 * Decompiled with CFR 0.152.
 */
package dev.entao.web.base;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0000\u001a\f\u0010\u0019\u001a\u00020\u001a*\u0004\u0018\u00010\u0001\u001a\u0014\u0010\u001b\u001a\u00020\u0001*\u0004\u0018\u00010\u00012\u0006\u0010\u001c\u001a\u00020\u0001\u001a\n\u0010\u001d\u001a\u00020\u0001*\u00020\u0001\u001a\u0012\u0010\u001d\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001a\u001a\u0014\u0010\u001f\u001a\u00020\u001a*\u0004\u0018\u00010\u00012\u0006\u0010 \u001a\u00020!\u001a\u0014\u0010\"\u001a\u00020\u001a*\u0004\u0018\u00010\u00012\u0006\u0010 \u001a\u00020!\u001a\u0012\u0010#\u001a\u00020\u0001*\u00020\u00012\u0006\u0010$\u001a\u00020%\u001a\n\u0010&\u001a\u00020\u001a*\u00020\u0001\u001a\u0012\u0010'\u001a\u00020\u0001*\u00020(2\u0006\u0010$\u001a\u00020%\u001a\u0012\u0010'\u001a\u00020\u0001*\u00020)2\u0006\u0010$\u001a\u00020%\u001a\f\u0010*\u001a\u00020\u001a*\u0004\u0018\u00010\u0001\u001a\u0014\u0010+\u001a\u00020\u0001*\u0004\u0018\u00010\u00012\u0006\u0010\u001c\u001a\u00020\u0001\u001a;\u0010,\u001a\u00020\u0001*\u00020\u00012*\u0010-\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00010/0.\"\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00010/\u00a2\u0006\u0002\u00100\u001a\u001a\u00101\u001a\u00020\u0001*\u00020\u00012\u0006\u00102\u001a\u00020%2\u0006\u00103\u001a\u00020%\u001a\u001c\u00104\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u00105\u001a\u00020!2\u0006\u00106\u001a\u00020!\u001a\u0012\u00107\u001a\u00020\u0001*\u00020\u00012\u0006\u0010$\u001a\u00020%\u001a\u0015\u00108\u001a\u00020\u0001*\u00020\u00012\u0006\u0010$\u001a\u00020%H\u0086\u0006\u001a\u0014\u00109\u001a\u00020\u0001*\u00020\u00012\b\b\u0002\u0010:\u001a\u00020%\u001a\u0018\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00010<*\u00020\u00012\u0006\u0010$\u001a\u00020%\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0014\u0010\u0006\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\"\u0014\u0010\b\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0003\"\u0014\u0010\n\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0003\"\u0015\u0010\f\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0015\u0010\u000f\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000e\"\u0015\u0010\u0011\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000e\"\u0015\u0010\u0013\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000e\"\u0015\u0010\u0015\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000e\"\u0015\u0010\u0017\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000e\u00a8\u0006="}, d2={"REG_EMAIL", "", "getREG_EMAIL", "()Ljava/lang/String;", "REG_FLOAT", "getREG_FLOAT", "REG_ID", "getREG_ID", "REG_INTEGER", "getREG_INTEGER", "REG_PHONE", "getREG_PHONE", "base64Decoded", "getBase64Decoded", "(Ljava/lang/String;)Ljava/lang/String;", "base64Encoded", "getBase64Encoded", "lowerCased", "getLowerCased", "upperCased", "getUpperCased", "urlDecoded", "getUrlDecoded", "urlEncoded", "getUrlEncoded", "empty", "", "emptyOr", "s", "escapeHtml", "forView", "hasChar", "ch", "", "hasCharLast", "head", "n", "", "matchIp4", "maxFraction", "", "", "notEmpty", "nullOr", "replaceChars", "charValuePair", "", "Lkotlin/Pair;", "(Ljava/lang/String;[Lkotlin/Pair;)Ljava/lang/String;", "substr", "from", "size", "substringBetween", "a", "b", "tail", "times", "trimColumns", "tabSize", "truck", "", "WebBasic"})
public final class StringExtKt {
    @NotNull
    private static final String REG_ID = "\\w+";
    @NotNull
    private static final String REG_PHONE = "1\\d{10}";
    @NotNull
    private static final String REG_EMAIL = "^(\\w)+(\\.\\w+)*@(\\w)+((\\.\\w+)+)$";
    @NotNull
    private static final String REG_INTEGER = "\\d+";
    @NotNull
    private static final String REG_FLOAT = "[.\\d]+";

    @NotNull
    public static final String getREG_ID() {
        return REG_ID;
    }

    @NotNull
    public static final String getREG_PHONE() {
        return REG_PHONE;
    }

    @NotNull
    public static final String getREG_EMAIL() {
        return REG_EMAIL;
    }

    @NotNull
    public static final String getREG_INTEGER() {
        return REG_INTEGER;
    }

    @NotNull
    public static final String getREG_FLOAT() {
        return REG_FLOAT;
    }

    @NotNull
    public static final String times(@NotNull String $this$times, int n) {
        Intrinsics.checkNotNullParameter((Object)$this$times, (String)"<this>");
        StringBuilder sb = new StringBuilder($this$times.length() * n + 1);
        for (int i = 0; i < n; ++i) {
            sb.append($this$times);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public static final String maxFraction(float $this$maxFraction, int n) {
        return StringExtKt.maxFraction((double)$this$maxFraction, n);
    }

    @NotNull
    public static final String maxFraction(double $this$maxFraction, int n) {
        if (n <= 0) {
            return String.valueOf((long)$this$maxFraction);
        }
        DecimalFormat f = new DecimalFormat();
        f.setMaximumFractionDigits(n);
        f.setGroupingUsed(false);
        String string = f.format($this$maxFraction);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"f.format(this)");
        return string;
    }

    public static final boolean matchIp4(@NotNull String $this$matchIp4) {
        Intrinsics.checkNotNullParameter((Object)$this$matchIp4, (String)"<this>");
        CharSequence charSequence = $this$matchIp4;
        return new Regex("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}").matches(charSequence);
    }

    @NotNull
    public static final String replaceChars(@NotNull String $this$replaceChars, Pair<Character, String> ... charValuePair) {
        Intrinsics.checkNotNullParameter((Object)$this$replaceChars, (String)"<this>");
        Intrinsics.checkNotNullParameter(charValuePair, (String)"charValuePair");
        StringBuilder sb = new StringBuilder($this$replaceChars.length() + 8);
        int n = $this$replaceChars.length();
        for (int i = 0; i < n; ++i) {
            Pair<Character, String> p;
            char ch;
            block3: {
                Pair<Character, String> pair;
                ch = $this$replaceChars.charAt(i);
                Pair<Character, String>[] pairArray = charValuePair;
                int n2 = pairArray.length;
                for (int j = 0; j < n2; ++j) {
                    Pair<Character, String> pair2;
                    Pair<Character, String> it = pair2 = pairArray[j];
                    boolean bl = false;
                    if (!(((Character)it.getFirst()).charValue() == ch)) continue;
                    pair = pair2;
                    break block3;
                }
                pair = p = null;
            }
            if (p != null) {
                sb.append((String)p.getSecond());
                continue;
            }
            sb.append(ch);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public static final String trimColumns(@NotNull String $this$trimColumns, int tabSize) {
        Intrinsics.checkNotNullParameter((Object)$this$trimColumns, (String)"<this>");
        List lines = StringsKt.lines((CharSequence)$this$trimColumns);
        int n = 1000;
        for (String line : lines) {
            if (((CharSequence)((Object)StringsKt.trim((CharSequence)line)).toString()).length() == 0) continue;
            int w = 0;
            int n2 = line.length();
            for (int i = 0; i < n2; ++i) {
                char c2 = line.charAt(i);
                if (c2 == ' ') {
                    ++w;
                    continue;
                }
                if (c2 != '\t') break;
                w += tabSize;
            }
            n = Math.min(n, w);
        }
        ArrayList ls2 = new ArrayList();
        for (String line : lines) {
            int w = 0;
            int index = 0;
            int n3 = line.length();
            for (int i = 0; i < n3; ++i) {
                char c3 = line.charAt(i);
                if (w >= n) break;
                ++index;
                if (c3 == ' ') {
                    ++w;
                    continue;
                }
                if (c3 != '\t') break;
                w += tabSize;
            }
            Collection collection = ls2;
            String string = line.substring(index);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            collection.add(string);
        }
        return CollectionsKt.joinToString$default((Iterable)ls2, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    public static /* synthetic */ String trimColumns$default(String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 4;
        }
        return StringExtKt.trimColumns(string, n);
    }

    @NotNull
    public static final String getUrlEncoded(@NotNull String $this$urlEncoded) {
        Intrinsics.checkNotNullParameter((Object)$this$urlEncoded, (String)"<this>");
        String string = URLEncoder.encode($this$urlEncoded, Charsets.UTF_8.name());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(this, Charsets.UTF_8.name())");
        return string;
    }

    @NotNull
    public static final String getUrlDecoded(@NotNull String $this$urlDecoded) {
        Intrinsics.checkNotNullParameter((Object)$this$urlDecoded, (String)"<this>");
        String string = URLDecoder.decode($this$urlDecoded, Charsets.UTF_8.name());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(this, Charsets.UTF_8.name())");
        return string;
    }

    @NotNull
    public static final String getBase64Decoded(@NotNull String $this$base64Decoded) {
        Intrinsics.checkNotNullParameter((Object)$this$base64Decoded, (String)"<this>");
        if (((CharSequence)$this$base64Decoded).length() == 0) {
            return "";
        }
        byte[] ba = Base64.getUrlDecoder().decode($this$base64Decoded);
        Intrinsics.checkNotNullExpressionValue((Object)ba, (String)"ba");
        return new String(ba, Charsets.UTF_8);
    }

    @NotNull
    public static final String getBase64Encoded(@NotNull String $this$base64Encoded) {
        Intrinsics.checkNotNullParameter((Object)$this$base64Encoded, (String)"<this>");
        if (((CharSequence)$this$base64Encoded).length() == 0) {
            return "";
        }
        Base64.Encoder encoder = Base64.getUrlEncoder();
        String string = $this$base64Encoded;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        String string2 = encoder.encodeToString(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUrlEncoder().encodeToString(this.toByteArray())");
        return string2;
    }

    @NotNull
    public static final String substr(@NotNull String $this$substr, int from2, int size) {
        Intrinsics.checkNotNullParameter((Object)$this$substr, (String)"<this>");
        int a2 = from2 >= 0 ? from2 : 0;
        int b = a2 + size < $this$substr.length() ? a2 + size : $this$substr.length();
        String string = $this$substr.substring(a2, b);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    @Nullable
    public static final String substringBetween(@NotNull String $this$substringBetween, char a2, char b) {
        int nB;
        Intrinsics.checkNotNullParameter((Object)$this$substringBetween, (String)"<this>");
        int nA = StringsKt.indexOf$default((CharSequence)$this$substringBetween, (char)a2, (int)0, (boolean)false, (int)6, null);
        if (nA >= 0 && (nB = StringsKt.indexOf$default((CharSequence)$this$substringBetween, (char)b, (int)(nA + 1), (boolean)false, (int)4, null)) >= 0) {
            String string = $this$substringBetween.substring(nA + 1, nB);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return string;
        }
        return null;
    }

    public static final boolean empty(@Nullable String $this$empty) {
        return $this$empty == null || ((CharSequence)$this$empty).length() == 0;
    }

    public static final boolean notEmpty(@Nullable String $this$notEmpty) {
        return $this$notEmpty != null && ((CharSequence)$this$notEmpty).length() > 0;
    }

    @NotNull
    public static final String emptyOr(@Nullable String $this$emptyOr, @NotNull String s2) {
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
        return $this$emptyOr == null || ((CharSequence)$this$emptyOr).length() == 0 ? s2 : $this$emptyOr;
    }

    @NotNull
    public static final String nullOr(@Nullable String $this$nullOr, @NotNull String s2) {
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
        String string = $this$nullOr;
        if (string == null) {
            string = s2;
        }
        return string;
    }

    public static final boolean hasCharLast(@Nullable String $this$hasCharLast, char ch) {
        String string = $this$hasCharLast;
        return (string != null ? StringsKt.lastIndexOf$default((CharSequence)string, (char)ch, (int)0, (boolean)false, (int)6, null) : -1) >= 0;
    }

    public static final boolean hasChar(@Nullable String $this$hasChar, char ch) {
        String string = $this$hasChar;
        return (string != null ? StringsKt.indexOf$default((CharSequence)string, (char)ch, (int)0, (boolean)false, (int)6, null) : -1) >= 0;
    }

    @NotNull
    public static final String head(@NotNull String $this$head, int n) {
        Intrinsics.checkNotNullParameter((Object)$this$head, (String)"<this>");
        if (n <= 0) {
            return "";
        }
        if ($this$head.length() <= n) {
            return $this$head;
        }
        String string = $this$head.substring(0, n);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    @NotNull
    public static final String tail(@NotNull String $this$tail, int n) {
        Intrinsics.checkNotNullParameter((Object)$this$tail, (String)"<this>");
        if (n <= 0) {
            return "";
        }
        if ($this$tail.length() < n) {
            return $this$tail;
        }
        String string = $this$tail.substring($this$tail.length() - n);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        return string;
    }

    @NotNull
    public static final List<String> truck(@NotNull String $this$truck, int n) {
        Intrinsics.checkNotNullParameter((Object)$this$truck, (String)"<this>");
        ArrayList<String> ls2 = new ArrayList<String>();
        if ($this$truck.length() <= n) {
            ls2.add($this$truck);
        } else {
            int x = $this$truck.length() / n;
            int y = $this$truck.length() % n;
            int i = 1;
            if (i <= x) {
                while (true) {
                    int start = (i - 1) * n;
                    String string = $this$truck.substring(start, start + n);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    ls2.add(string);
                    if (i == x) break;
                    ++i;
                }
            }
            if (y != 0) {
                String string = $this$truck.substring(x * n);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                ls2.add(string);
            }
        }
        return ls2;
    }

    @NotNull
    public static final String escapeHtml(@NotNull String $this$escapeHtml) {
        Intrinsics.checkNotNullParameter((Object)$this$escapeHtml, (String)"<this>");
        StringBuffer sb = new StringBuffer((int)((double)$this$escapeHtml.length() * 1.1));
        CharSequence $this$forEach$iv = $this$escapeHtml;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$forEach$iv.charAt(i);
            boolean bl = false;
            char c2 = it;
            if (c2 == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c2 == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c2 == '\"') {
                sb.append("&quot;");
                continue;
            }
            if (c2 == '\'') {
                sb.append("&#x27;");
                continue;
            }
            if (c2 == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c2 == '/') {
                sb.append("&#x2F;");
                continue;
            }
            sb.append(it);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public static final String escapeHtml(@NotNull String $this$escapeHtml, boolean forView) {
        Intrinsics.checkNotNullParameter((Object)$this$escapeHtml, (String)"<this>");
        if (!forView) {
            return StringExtKt.escapeHtml($this$escapeHtml);
        }
        StringBuffer sb = new StringBuffer((int)((double)$this$escapeHtml.length() * 1.1));
        char CR = '\r';
        char LF = '\n';
        char SP = ' ';
        String BR = "<br/>";
        for (int i = 0; i < $this$escapeHtml.length(); ++i) {
            char c2 = $this$escapeHtml.charAt(i);
            char c3 = c2;
            if (c3 == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c3 == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c3 == '\"') {
                sb.append("&quot;");
                continue;
            }
            if (c3 == '\'') {
                sb.append("&#x27;");
                continue;
            }
            if (c3 == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c3 == '/') {
                sb.append("&#x2F;");
                continue;
            }
            if (c3 == SP) {
                sb.append("&nbsp;");
                continue;
            }
            if (c3 == CR) {
                Character nextChar;
                Character c4 = nextChar = i + 1 < $this$escapeHtml.length() ? Character.valueOf($this$escapeHtml.charAt(i + 1)) : null;
                char c5 = LF;
                if (c4 == null || c4.charValue() != c5) {
                    sb.append(BR);
                }
                continue;
            }
            if (c3 == LF) {
                sb.append(BR);
                continue;
            }
            sb.append(c2);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public static final String getLowerCased(@NotNull String $this$lowerCased) {
        Intrinsics.checkNotNullParameter((Object)$this$lowerCased, (String)"<this>");
        String string = $this$lowerCased;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
        return string2;
    }

    @NotNull
    public static final String getUpperCased(@NotNull String $this$upperCased) {
        Intrinsics.checkNotNullParameter((Object)$this$upperCased, (String)"<this>");
        String string = $this$upperCased;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        String string2 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(locale)");
        return string2;
    }
}

