/*
 * Decompiled with CFR 0.152.
 */
package dev.entao.web.base;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\bJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\bJ \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ldev/entao/web/base/Thumb;", "", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "getFile", "()Ljava/io/File;", "maxEdge", "", "maxHeight", "maxWidth", "minEdge", "oldHeight", "oldImg", "Ljava/awt/image/BufferedImage;", "oldWidth", "n", "saveToFile", "", "newW", "newH", "newFile", "toFile", "WebBasic"})
public final class Thumb {
    @NotNull
    private final File file;
    @Nullable
    private BufferedImage oldImg;
    private int oldWidth;
    private int oldHeight;
    private int maxEdge;
    private int minEdge;
    private int maxWidth;
    private int maxHeight;

    public Thumb(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        try {
            BufferedImage bufferedImage = this.oldImg = ImageIO.read(this.file);
            System.out.println(bufferedImage != null ? Boolean.valueOf(bufferedImage.isAlphaPremultiplied()) : null);
            BufferedImage bufferedImage2 = this.oldImg;
            this.oldWidth = bufferedImage2 != null ? bufferedImage2.getWidth() : 0;
            BufferedImage bufferedImage3 = this.oldImg;
            this.oldHeight = bufferedImage3 != null ? bufferedImage3.getHeight() : 0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final Thumb maxEdge(int n) {
        this.maxEdge = n;
        return this;
    }

    @NotNull
    public final Thumb minEdge(int n) {
        this.minEdge = n;
        return this;
    }

    @NotNull
    public final Thumb maxWidth(int n) {
        this.maxWidth = n;
        return this;
    }

    @NotNull
    public final Thumb maxHeight(int n) {
        this.maxHeight = n;
        return this;
    }

    private final boolean saveToFile(int newW, int newH, File newFile) {
        if (newW >= this.oldWidth && newH >= this.oldHeight) {
            File f = FilesKt.copyTo$default((File)this.file, (File)newFile, (boolean)true, (int)0, (int)4, null);
            return f.exists();
        }
        try {
            BufferedImage bufferedImage = this.oldImg;
            if (bufferedImage == null) {
                return false;
            }
            BufferedImage img = bufferedImage;
            BufferedImage dst = new BufferedImage(newW, newH, img.getType());
            Graphics g = dst.getGraphics();
            g.drawImage(img, 0, 0, newW, newH, null);
            Object[] objectArray = new Integer[]{2, 3, 6, 7};
            String a2 = CollectionsKt.listOf((Object[])objectArray).contains(img.getType()) ? "png" : "jpg";
            return ImageIO.write((RenderedImage)dst, a2, newFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public final boolean toFile(@NotNull File newFile) {
        Intrinsics.checkNotNullParameter((Object)newFile, (String)"newFile");
        if (this.oldWidth <= 0 || this.oldHeight <= 0) {
            return false;
        }
        int newW = 0;
        int newH = 0;
        if (this.maxWidth > 0) {
            newW = this.maxWidth;
            newH = newW * this.oldHeight / this.oldWidth;
        } else if (this.maxHeight > 0) {
            newH = this.maxHeight;
            newW = newH * this.oldWidth / this.oldHeight;
        } else if (this.maxEdge > 0) {
            if (this.oldWidth > this.oldHeight) {
                newW = this.maxEdge;
                newH = newW * this.oldHeight / this.oldWidth;
            } else {
                newH = this.maxEdge;
                newW = newH * this.oldWidth / this.oldHeight;
            }
        } else if (this.minEdge > 0) {
            if (this.oldWidth > this.oldHeight) {
                newH = this.minEdge;
                newW = newH * this.oldWidth / this.oldHeight;
            } else {
                newW = this.minEdge;
                newH = newW * this.oldHeight / this.oldWidth;
            }
        }
        if (newW > 0 && newH > 0) {
            return this.saveToFile(newW, newH, newFile);
        }
        return false;
    }
}

