/*
 * Decompiled with CFR 0.152.
 */
package dev.entao.web.http;

import dev.entao.web.base.BaseUtilsKt;
import dev.entao.web.base.IOUtilsKt;
import dev.entao.web.http.FileParam;
import dev.entao.web.http.HttpReq;
import dev.entao.web.http.SizeStream;
import dev.entao.web.log.LogExKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\bJ\u0016\u0010\u000b\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u000eJ/\u0010\u000b\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u000e2\u0017\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\n0\u0010\u00a2\u0006\u0002\b\u0011J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ldev/entao/web/http/HttpMultipart;", "Ldev/entao/web/http/HttpReq;", "url", "", "(Ljava/lang/String;)V", "BOUNDARY", "fileList", "Ljava/util/ArrayList;", "Ldev/entao/web/http/FileParam;", "dumpReq", "", "file", "fileParam", "key", "Ljava/io/File;", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "onSend", "connection", "Ljava/net/HttpURLConnection;", "preConnect", "sendMultipart", "os", "Ljava/io/OutputStream;", "WebBasic"})
public final class HttpMultipart
extends HttpReq {
    @NotNull
    private final String BOUNDARY;
    @NotNull
    private final ArrayList<FileParam> fileList;

    public HttpMultipart(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        super(url, "POST");
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID()");
        this.BOUNDARY = BaseUtilsKt.getHexText(uUID);
        this.fileList = new ArrayList();
        this.getHeaders().setContentType("multipart/form-data; boundary=" + this.BOUNDARY);
    }

    @NotNull
    public final HttpMultipart file(@NotNull FileParam fileParam) {
        Intrinsics.checkNotNullParameter((Object)fileParam, (String)"fileParam");
        this.fileList.add(fileParam);
        return this;
    }

    @NotNull
    public final HttpMultipart file(@NotNull String key, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileParam p = new FileParam(key, file, null, null, 12, null);
        return this.file(p);
    }

    @NotNull
    public final HttpMultipart file(@NotNull String key, @NotNull File file, @NotNull Function1<? super FileParam, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        FileParam p = new FileParam(key, file, null, null, 12, null);
        block.invoke((Object)p);
        return this.file(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onSend(@NotNull HttpURLConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Closeable closeable = connection.getOutputStream();
        Throwable throwable = null;
        try {
            OutputStream it = (OutputStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.sendMultipart(it);
            it.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Override
    public void dumpReq() {
        super.dumpReq();
        for (FileParam fp : this.fileList) {
            Object[] objectArray = new Object[]{"--file:", fp};
            LogExKt.logd(objectArray);
        }
    }

    @Override
    protected void preConnect(@NotNull HttpURLConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        super.preConnect(connection);
        if (this.fileList.size() > 0) {
            SizeStream os = new SizeStream();
            this.sendMultipart(os);
            connection.setFixedLengthStreamingMode(os.getSize());
        }
    }

    private final void sendMultipart(OutputStream os) throws IOException {
        if (this.getAllArgs().size() > 0) {
            for (Map.Entry entry : this.getAllArgs().entrySet()) {
                String[] stringArray = new String[]{"--", this.BOUNDARY};
                this.writeln(os, stringArray);
                stringArray = new String[]{"Content-Disposition: form-data; name=\"" + entry.getKey() + "\""};
                this.writeln(os, stringArray);
                stringArray = new String[]{"Content-Type:text/plain;charset=utf-8"};
                this.writeln(os, stringArray);
                this.writeln(os, new String[0]);
                stringArray = new String[1];
                Object v = entry.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"e.value");
                stringArray[0] = (String)v;
                this.writeln(os, stringArray);
            }
        }
        if (this.fileList.size() > 0) {
            for (FileParam fileParam : this.fileList) {
                String[] stringArray = new String[]{"--", this.BOUNDARY};
                this.writeln(os, stringArray);
                stringArray = new String[]{"Content-Disposition:form-data;name=\"" + fileParam.getKey() + "\";filename=\"" + fileParam.getFilename() + "\""};
                this.writeln(os, stringArray);
                stringArray = new String[]{"Content-Type:" + fileParam.getMime()};
                this.writeln(os, stringArray);
                stringArray = new String[]{"Content-Transfer-Encoding: binary"};
                this.writeln(os, stringArray);
                this.writeln(os, new String[0]);
                int total = (int)fileParam.getFile().length();
                if (os instanceof SizeStream) {
                    ((SizeStream)os).incSize(total);
                } else {
                    IOUtilsKt.copyStream(new FileInputStream(fileParam.getFile()), true, os, false, total, fileParam.getProgress());
                }
                this.writeln(os, new String[0]);
            }
        }
        String[] stringArray = new String[]{"--", this.BOUNDARY, "--"};
        this.writeln(os, stringArray);
    }
}

