/*
 * Decompiled with CFR 0.152.
 */
package dev.entao.web.http;

import dev.entao.web.base.IOUtilsKt;
import dev.entao.web.http.HttpKt;
import dev.entao.web.http.HttpReq;
import dev.entao.web.json.YsonObject;
import dev.entao.web.log.LogExKt;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0003J\u001f\u0010\n\u001a\u00020\u00002\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000fJ\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0003R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ldev/entao/web/http/HttpRaw;", "Ldev/entao/web/http/HttpReq;", "url", "", "(Ljava/lang/String;)V", "rawData", "", "data", "contentType", "json", "jsonObject", "block", "Lkotlin/Function1;", "Ldev/entao/web/json/YsonObject;", "", "Lkotlin/ExtensionFunctionType;", "onSend", "connection", "Ljava/net/HttpURLConnection;", "xml", "WebBasic"})
public final class HttpRaw
extends HttpReq {
    private byte[] rawData;

    public HttpRaw(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        super(url, "POST");
    }

    @NotNull
    public final HttpRaw data(@NotNull String contentType, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.getHeaders().setContentType(contentType);
        this.rawData = data;
        return this;
    }

    @NotNull
    public final HttpRaw jsonObject(@NotNull Function1<? super YsonObject, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        YsonObject yo = new YsonObject(null, 1, null);
        block.invoke((Object)yo);
        return this.json(yo.toString());
    }

    @NotNull
    public final HttpRaw json(@NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        byte[] byArray = json.getBytes(this.getCharsetUTF8());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return this.data("application/json;charset=utf-8", byArray);
    }

    @NotNull
    public final HttpRaw xml(@NotNull String xml) {
        Intrinsics.checkNotNullParameter((Object)xml, (String)"xml");
        byte[] byArray = xml.getBytes(this.getCharsetUTF8());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return this.data("application/xml;charset=utf-8", byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onSend(@NotNull HttpURLConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        OutputStream os = connection.getOutputStream();
        try {
            byte[] byArray = this.rawData;
            if (this.rawData == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"rawData");
                byArray = null;
            }
            os.write(byArray);
            if (this.getDumpReq() && HttpKt.allowDump(this.getHeaders().getContentType())) {
                Object[] objectArray = new Object[2];
                objectArray[0] = "--body:";
                byte[] byArray2 = this.rawData;
                if (this.rawData == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"rawData");
                    byArray2 = null;
                }
                byte[] byArray3 = byArray2;
                Charset charset = Charsets.UTF_8;
                objectArray[1] = new String(byArray3, charset);
                LogExKt.logd(objectArray);
            }
            os.flush();
        }
        finally {
            Intrinsics.checkNotNullExpressionValue((Object)os, (String)"os");
            IOUtilsKt.closeSafe(os);
        }
    }
}

