/*
 * Decompiled with CFR 0.152.
 */
package dev.entao.web.http;

import dev.entao.web.base.IOUtilsKt;
import dev.entao.web.base.Progress;
import dev.entao.web.base.StringExtKt;
import dev.entao.web.http.HttpGet;
import dev.entao.web.http.HttpHeaders;
import dev.entao.web.http.HttpRaw;
import dev.entao.web.http.HttpResult;
import dev.entao.web.log.LogExKt;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0004\n\u0000\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010/\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u0001J7\u00102\u001a\u00020\u00002*\u00102\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030403\"\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000304\u00a2\u0006\u0002\u00105J\u001a\u00102\u001a\u00020\u00002\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000307J\b\u00108\u001a\u00020\u0003H\u0004J\u0006\u00109\u001a\u00020\u0003J\u0018\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020&2\b\u0010\u001f\u001a\u0004\u0018\u00010 J\b\u0010\u0011\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020;2\u0006\u0010?\u001a\u00020@H\u0002J\u0010\u0010A\u001a\u00020=2\u0006\u0010?\u001a\u00020@H$J\u0010\u0010B\u001a\u00020=2\u0006\u0010?\u001a\u00020@H\u0014J\u0006\u0010C\u001a\u00020;J'\u0010D\u001a\u00020=2\u0006\u0010E\u001a\u00020F2\u0012\u0010G\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000303\"\u00020\u0003\u00a2\u0006\u0002\u0010HJ'\u0010I\u001a\u00020=2\u0006\u0010E\u001a\u00020F2\u0012\u0010G\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000303\"\u00020\u0003\u00a2\u0006\u0002\u0010HJ\u0015\u0010/\u001a\u00020=*\u00020\u00032\u0006\u0010J\u001a\u00020\u0012H\u0086\u0004J\u0015\u0010/\u001a\u00020=*\u00020\u00032\u0006\u0010J\u001a\u00020KH\u0086\u0004J\u0015\u0010/\u001a\u00020=*\u00020\u00032\u0006\u0010J\u001a\u00020\u0003H\u0086\u0004R\u0014\u0010\u0006\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\bR\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001c\u0010%\u001a\u0004\u0018\u00010&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\b\u00a8\u0006L"}, d2={"Ldev/entao/web/http/HttpReq;", "", "url", "", "method", "(Ljava/lang/String;Ljava/lang/String;)V", "UTF8", "getUTF8", "()Ljava/lang/String;", "allArgs", "Ljava/util/LinkedHashMap;", "getAllArgs", "()Ljava/util/LinkedHashMap;", "charsetUTF8", "Ljava/nio/charset/Charset;", "getCharsetUTF8", "()Ljava/nio/charset/Charset;", "dumpReq", "", "getDumpReq", "()Z", "setDumpReq", "(Z)V", "dumpResp", "getDumpResp", "setDumpResp", "headers", "Ldev/entao/web/http/HttpHeaders;", "getHeaders", "()Ldev/entao/web/http/HttpHeaders;", "getMethod", "progress", "Ldev/entao/web/base/Progress;", "getProgress", "()Ldev/entao/web/base/Progress;", "setProgress", "(Ldev/entao/web/base/Progress;)V", "saveToFile", "Ljava/io/File;", "getSaveToFile", "()Ljava/io/File;", "setSaveToFile", "(Ljava/io/File;)V", "timeoutConnect", "", "timeoutRead", "getUrl", "arg", "key", "value", "args", "", "Lkotlin/Pair;", "([Lkotlin/Pair;)Ldev/entao/web/http/HttpReq;", "map", "", "buildArgs", "buildGetUrl", "download", "Ldev/entao/web/http/HttpResult;", "saveto", "", "onResponse", "connection", "Ljava/net/HttpURLConnection;", "onSend", "preConnect", "request", "write", "os", "Ljava/io/OutputStream;", "arr", "(Ljava/io/OutputStream;[Ljava/lang/String;)V", "writeln", "v", "", "WebBasic"})
public abstract class HttpReq {
    @NotNull
    private final String url;
    @NotNull
    private final String method;
    @NotNull
    private final String UTF8;
    @NotNull
    private final Charset charsetUTF8;
    @NotNull
    private final HttpHeaders headers;
    @NotNull
    private final LinkedHashMap<String, String> allArgs;
    private int timeoutConnect;
    private int timeoutRead;
    @Nullable
    private File saveToFile;
    @Nullable
    private Progress progress;
    private boolean dumpReq;
    private boolean dumpResp;

    public HttpReq(@NotNull String url, @NotNull String method) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        this.url = url;
        this.method = method;
        this.UTF8 = "UTF-8";
        this.charsetUTF8 = Charsets.UTF_8;
        this.headers = new HttpHeaders();
        this.allArgs = new LinkedHashMap();
        this.timeoutConnect = 10000;
        this.timeoutRead = 10000;
        this.headers.setUserAgent("sweet http client");
        this.headers.setAccept("application/json,text/plain,text/html,*/*");
        this.headers.setAcceptCharset("UTF-8,*");
        this.headers.setConnection("close");
    }

    public /* synthetic */ HttpReq(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = "GET";
        }
        this(string, string2);
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final String getMethod() {
        return this.method;
    }

    @NotNull
    public final String getUTF8() {
        return this.UTF8;
    }

    @NotNull
    public final Charset getCharsetUTF8() {
        return this.charsetUTF8;
    }

    @NotNull
    public final HttpHeaders getHeaders() {
        return this.headers;
    }

    @NotNull
    protected final LinkedHashMap<String, String> getAllArgs() {
        return this.allArgs;
    }

    @Nullable
    public final File getSaveToFile() {
        return this.saveToFile;
    }

    public final void setSaveToFile(@Nullable File file) {
        this.saveToFile = file;
    }

    @Nullable
    public final Progress getProgress() {
        return this.progress;
    }

    public final void setProgress(@Nullable Progress progress) {
        this.progress = progress;
    }

    public final boolean getDumpReq() {
        return this.dumpReq;
    }

    public final void setDumpReq(boolean bl) {
        this.dumpReq = bl;
    }

    public final boolean getDumpResp() {
        return this.dumpResp;
    }

    public final void setDumpResp(boolean bl) {
        this.dumpResp = bl;
    }

    public final void arg(@NotNull String $this$arg, @NotNull String v) {
        Intrinsics.checkNotNullParameter((Object)$this$arg, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this.arg($this$arg, (Object)v);
    }

    public final void arg(@NotNull String $this$arg, @NotNull Number v) {
        Intrinsics.checkNotNullParameter((Object)$this$arg, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this.arg($this$arg, (Object)v);
    }

    public final void arg(@NotNull String $this$arg, boolean v) {
        Intrinsics.checkNotNullParameter((Object)$this$arg, (String)"<this>");
        this.arg($this$arg, (Object)v);
    }

    @NotNull
    public final HttpReq arg(@NotNull String key, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ((Map)this.allArgs).put(key, value.toString());
        return this;
    }

    @NotNull
    public final HttpReq args(Pair<String, String> ... args) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        for (Pair<String, String> pair : args) {
            String k = (String)pair.component1();
            String v = (String)pair.component2();
            ((Map)this.allArgs).put(k, v);
        }
        return this;
    }

    @NotNull
    public final HttpReq args(@NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        this.allArgs.putAll(map);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final String buildArgs() {
        void $this$mapTo$iv$iv;
        Map $this$map$iv = this.allArgs;
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringExtKt.getUrlEncoded((String)it.getKey()) + "=" + StringExtKt.getUrlEncoded((String)it.getValue()));
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final String buildGetUrl() throws MalformedURLException {
        String sArgs = this.buildArgs();
        if (((CharSequence)sArgs).length() == 0) {
            return this.url;
        }
        StringBuilder sb = new StringBuilder(this.url.length() + sArgs.length() + 8);
        sb.append(this.url);
        if (!StringsKt.contains$default((CharSequence)sb, (char)'?', (boolean)false, (int)2, null)) {
            sb.append('?');
        }
        if (StringsKt.last((CharSequence)sb) != '?') {
            sb.append('&');
        }
        sb.append(sArgs);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    public void dumpReq() {
        Object[] objectArray;
        String v;
        String k;
        if (!this.dumpReq) {
            return;
        }
        Object[] objectArray2 = new Object[]{"Http Request:", this.url};
        LogExKt.logd(objectArray2);
        for (Map.Entry entry : ((Map)this.headers.getAllMap()).entrySet()) {
            k = (String)entry.getKey();
            v = (String)entry.getValue();
            objectArray = new Object[]{"--head:", k, "=", v};
            LogExKt.logd(objectArray);
        }
        for (Map.Entry entry : ((Map)this.allArgs).entrySet()) {
            k = (String)entry.getKey();
            v = (String)entry.getValue();
            objectArray = new Object[]{"--arg:", k, "=", v};
            LogExKt.logd(objectArray);
        }
    }

    public final void write(@NotNull OutputStream os, String ... arr) throws IOException {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        Intrinsics.checkNotNullParameter((Object)arr, (String)"arr");
        for (String s2 : arr) {
            byte[] byArray = s2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            os.write(byArray);
        }
    }

    public final void writeln(@NotNull OutputStream os, String ... arr) throws IOException {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        Intrinsics.checkNotNullParameter((Object)arr, (String)"arr");
        for (String s2 : arr) {
            byte[] byArray = s2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            os.write(byArray);
        }
        byte[] byArray = "\r\n".getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        os.write(byArray);
    }

    protected void preConnect(@NotNull HttpURLConnection connection) throws ProtocolException, UnsupportedEncodingException {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        HttpURLConnection.setFollowRedirects(true);
        connection.setDoOutput(!Intrinsics.areEqual((Object)this.method, (Object)"GET"));
        connection.setDoInput(true);
        connection.setConnectTimeout(this.timeoutConnect);
        connection.setReadTimeout(this.timeoutRead);
        connection.setRequestMethod(this.method);
        connection.setUseCaches(false);
        for (Map.Entry<String, String> e : this.headers.getAllMap().entrySet()) {
            connection.setRequestProperty(e.getKey(), e.getValue());
        }
    }

    private final HttpResult onResponse(HttpURLConnection connection) throws IOException {
        HttpResult httpResult;
        HttpResult $this$onResponse_u24lambda_u2d1 = httpResult = new HttpResult(this.url);
        boolean bl = false;
        $this$onResponse_u24lambda_u2d1.setCode(connection.getResponseCode());
        $this$onResponse_u24lambda_u2d1.setMsg(connection.getResponseMessage());
        $this$onResponse_u24lambda_u2d1.setContentType(connection.getContentType());
        $this$onResponse_u24lambda_u2d1.setHeaders(connection.getHeaderFields());
        $this$onResponse_u24lambda_u2d1.setContentLength(connection.getContentLength());
        HttpResult result = httpResult;
        int total = connection.getContentLength();
        try {
            File saveFile;
            File file = saveFile = this.saveToFile;
            if (file != null) {
                File it = bl = file;
                boolean bl2 = false;
                File dir = it.getParentFile();
                if (dir != null && !dir.exists() && !dir.mkdirs()) {
                    Object[] objectArray = new Object[]{"\u521b\u5efa\u76ee\u5f55\u5931\u8d25"};
                    LogExKt.loge(objectArray);
                    throw new IOException("\u521b\u5efa\u76ee\u5f55\u5931\u8d25!");
                }
            }
            OutputStream os = saveFile != null ? (OutputStream)new FileOutputStream(saveFile) : (OutputStream)new ByteArrayOutputStream(total > 0 ? total : 64);
            InputStream input = connection.getInputStream();
            String mayGzip = connection.getContentEncoding();
            if (mayGzip != null && StringsKt.contains$default((CharSequence)mayGzip, (CharSequence)"gzip", (boolean)false, (int)2, null)) {
                input = new GZIPInputStream(input);
            }
            InputStream inputStream = input;
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"input");
            IOUtilsKt.copyStream(inputStream, true, os, true, total, this.progress);
            if (os instanceof ByteArrayOutputStream) {
                result.setBuffer(((ByteArrayOutputStream)os).toByteArray());
            }
        }
        catch (Exception ex) {
            result.setException(ex);
        }
        return result;
    }

    protected abstract void onSend(@NotNull HttpURLConnection var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final HttpResult request() {
        HttpURLConnection connection = null;
        try {
            HttpURLConnection httpURLConnection;
            this.dumpReq();
            if (this instanceof HttpGet || this instanceof HttpRaw) {
                URLConnection uRLConnection = new URL(this.buildGetUrl()).openConnection();
                Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
                httpURLConnection = (HttpURLConnection)uRLConnection;
            } else {
                URLConnection uRLConnection = new URL(this.url).openConnection();
                Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
                httpURLConnection = (HttpURLConnection)uRLConnection;
            }
            connection = httpURLConnection;
            this.preConnect(connection);
            connection.connect();
            this.onSend(connection);
            HttpResult r2 = this.onResponse(connection);
            if (this.dumpResp) {
                r2.dump$WebBasic();
            }
            HttpResult httpResult = r2;
            connection.disconnect();
            return httpResult;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Object[] objectArray = new Object[]{ex};
            LogExKt.loge(objectArray);
            HttpResult result = new HttpResult(this.url);
            result.setException(ex);
            HttpResult httpResult = result;
            return httpResult;
        }
        finally {
            block8: {
                HttpURLConnection httpURLConnection = connection;
                if (httpURLConnection == null) break block8;
                httpURLConnection.disconnect();
            }
        }
    }

    @NotNull
    public final HttpResult download(@NotNull File saveto, @Nullable Progress progress) {
        Intrinsics.checkNotNullParameter((Object)saveto, (String)"saveto");
        this.saveToFile = saveto;
        this.progress = progress;
        return this.request();
    }
}

