/*
 * Decompiled with CFR 0.152.
 */
package dev.entao.web.http;

import dev.entao.web.http.HttpCodeKt;
import dev.entao.web.http.HttpKt;
import dev.entao.web.http.HttpResult;
import dev.entao.web.json.YsonArray;
import dev.entao.web.json.YsonObject;
import dev.entao.web.log.LogExKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010<\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010=\u001a\u00020\u0016J\r\u0010>\u001a\u00020?H\u0000\u00a2\u0006\u0002\b@J\u000e\u0010A\u001a\u00020\u00062\u0006\u0010B\u001a\u00020CJ'\u0010D\u001a\u0004\u0018\u0001HE\"\u0004\b\u0000\u0010E2\u0012\u0010F\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002HE0G\u00a2\u0006\u0002\u0010HJ\b\u0010I\u001a\u0004\u0018\u00010JJ\b\u0010K\u001a\u0004\u0018\u00010LR\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0012\"\u0004\b\u001b\u0010\u0014R\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010\u0004R\u0013\u0010 \u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001eR\"\u0010\"\u001a\n\u0018\u00010#j\u0004\u0018\u0001`$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R.\u0010)\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030+\u0018\u00010*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001c\u00100\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u001e\"\u0004\b2\u0010\u0004R\u001a\u00103\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\b\"\u0004\b5\u00106R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\u001eR\u0013\u00108\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b9\u0010\fR\u0013\u0010:\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b;\u0010\u001e\u00a8\u0006M"}, d2={"Ldev/entao/web/http/HttpResult;", "", "url", "", "(Ljava/lang/String;)V", "OK", "", "getOK", "()Z", "buffer", "", "getBuffer", "()[B", "setBuffer", "([B)V", "code", "", "getCode", "()I", "setCode", "(I)V", "contentCharset", "Ljava/nio/charset/Charset;", "getContentCharset", "()Ljava/nio/charset/Charset;", "contentLength", "getContentLength", "setContentLength", "contentType", "getContentType", "()Ljava/lang/String;", "setContentType", "errorMessage", "getErrorMessage", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getException", "()Ljava/lang/Exception;", "setException", "(Ljava/lang/Exception;)V", "headers", "", "", "getHeaders", "()Ljava/util/Map;", "setHeaders", "(Ljava/util/Map;)V", "msg", "getMsg", "setMsg", "needDecode", "getNeedDecode", "setNeedDecode", "(Z)V", "getUrl", "valueBytes", "getValueBytes", "valueText", "getValueText", "bufferToString", "charset", "dump", "", "dump$WebBasic", "saveTo", "file", "Ljava/io/File;", "textTo", "T", "block", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "ysonArray", "Ldev/entao/web/json/YsonArray;", "ysonObject", "Ldev/entao/web/json/YsonObject;", "WebBasic"})
public final class HttpResult {
    @NotNull
    private final String url;
    @Nullable
    private byte[] buffer;
    private int code;
    @Nullable
    private String msg;
    @Nullable
    private String contentType;
    private int contentLength;
    @Nullable
    private Map<String, ? extends List<String>> headers;
    @Nullable
    private Exception exception;
    private boolean needDecode;

    public HttpResult(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.url = url;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @Nullable
    public final byte[] getBuffer() {
        return this.buffer;
    }

    public final void setBuffer(@Nullable byte[] byArray) {
        this.buffer = byArray;
    }

    public final int getCode() {
        return this.code;
    }

    public final void setCode(int n) {
        this.code = n;
    }

    @Nullable
    public final String getMsg() {
        return this.msg;
    }

    public final void setMsg(@Nullable String string) {
        this.msg = string;
    }

    @Nullable
    public final String getContentType() {
        return this.contentType;
    }

    public final void setContentType(@Nullable String string) {
        this.contentType = string;
    }

    public final int getContentLength() {
        return this.contentLength;
    }

    public final void setContentLength(int n) {
        this.contentLength = n;
    }

    @Nullable
    public final Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public final void setHeaders(@Nullable Map<String, ? extends List<String>> map) {
        this.headers = map;
    }

    @Nullable
    public final Exception getException() {
        return this.exception;
    }

    public final void setException(@Nullable Exception exception) {
        this.exception = exception;
    }

    public final boolean getNeedDecode() {
        return this.needDecode;
    }

    public final void setNeedDecode(boolean bl) {
        this.needDecode = bl;
    }

    public final boolean getOK() {
        int n = this.code;
        return 200 <= n ? n < 300 : false;
    }

    @Nullable
    public final String getErrorMessage() {
        Exception ex = this.exception;
        return ex == null ? HttpCodeKt.httpMsgByCode(this.code) : (ex instanceof NoRouteToHostException ? "NO Router To Host" : (ex instanceof TimeoutException ? "Request Timeout" : (ex instanceof SocketTimeoutException ? "Request Timeout" : (ex instanceof SocketException ? "Socket Error" : (ex instanceof FileNotFoundException ? "File Not Found" : ex.getLocalizedMessage())))));
    }

    @Nullable
    public final Charset getContentCharset() {
        String string = this.contentType;
        if (string == null) {
            return null;
        }
        String ct = string;
        String string2 = ct.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String code = ((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)StringsKt.substringAfter((String)StringsKt.substringAfter((String)string2, (String)"charset", (String)""), (String)"=", (String)""), (String)";", null, (int)2, null))).toString();
        if (((CharSequence)code).length() > 0) {
            String string3 = code.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            return Charset.forName(string3);
        }
        return null;
    }

    @Nullable
    public final String bufferToString(@NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        if (this.buffer == null) {
            return null;
        }
        byte[] r2 = this.buffer;
        Charset charset2 = this.getContentCharset();
        if (charset2 == null) {
            charset2 = charset;
        }
        Charset ch = charset2;
        String s2 = new String(r2, ch);
        if (this.needDecode) {
            String string = URLDecoder.decode(s2, ch.name());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(s, ch.name())");
            s2 = string;
        }
        return s2;
    }

    public static /* synthetic */ String bufferToString$default(HttpResult httpResult, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return httpResult.bufferToString(charset);
    }

    public final void dump$WebBasic() {
        Object[] objectArray;
        Object[] objectArray2 = new Object[]{">>Response:", this.url};
        LogExKt.logd(objectArray2);
        objectArray2 = new Object[3];
        objectArray2[0] = "  >>status:";
        objectArray2[1] = this.code;
        String string = this.msg;
        if (string == null) {
            string = "";
        }
        objectArray2[2] = string;
        LogExKt.logd(objectArray2);
        Map<String, ? extends List<String>> map = this.headers;
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                Object[] objectArray3;
                String k = (String)entry.getKey();
                List v = (List)entry.getValue();
                if (v.size() == 1) {
                    objectArray3 = new Object[]{"  >>head:", k, "=", CollectionsKt.first((List)v)};
                    LogExKt.logd(objectArray3);
                    continue;
                }
                objectArray3 = new Object[]{"  >>head:", k, "=", "[" + CollectionsKt.joinToString$default((Iterable)v, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + "]"};
                LogExKt.logd(objectArray3);
            }
        }
        if (this.exception != null) {
            objectArray = new Object[2];
            objectArray[0] = "  >>Exception:";
            Exception exception = this.exception;
            objectArray[1] = exception != null ? exception.getLocalizedMessage() : null;
            LogExKt.logd(objectArray);
        }
        if (HttpKt.allowDump(this.contentType)) {
            objectArray = new Object[]{"  >>body:", HttpResult.bufferToString$default(this, null, 1, null)};
            LogExKt.logd(objectArray);
        }
    }

    @Nullable
    public final byte[] getValueBytes() {
        if (this.getOK()) {
            return this.buffer;
        }
        return null;
    }

    @Nullable
    public final String getValueText() {
        if (this.getOK()) {
            return this.bufferToString(Charsets.UTF_8);
        }
        return null;
    }

    @Nullable
    public final <T> T textTo(@NotNull Function1<? super String, ? extends T> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        String s2 = this.getValueText();
        if (s2 != null && ((CharSequence)s2).length() > 0) {
            try {
                return (T)block.invoke((Object)s2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Nullable
    public final YsonArray ysonArray() {
        return (YsonArray)this.textTo(ysonArray.1.INSTANCE);
    }

    @Nullable
    public final YsonObject ysonObject() {
        return (YsonObject)this.textTo(ysonObject.1.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean saveTo(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        byte[] byArray = this.getValueBytes();
        if (byArray == null) {
            return false;
        }
        byte[] data = byArray;
        File dir = file.getParentFile();
        if (dir != null && !dir.exists() && !dir.mkdirs()) {
            Object[] objectArray = new Object[]{"\u521b\u5efa\u76ee\u5f55\u5931\u8d25"};
            LogExKt.loge(objectArray);
            return false;
        }
        Closeable closeable = new FileOutputStream(file);
        Throwable throwable = null;
        try {
            FileOutputStream it = (FileOutputStream)closeable;
            boolean bl = false;
            it.write(data);
            it.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return false;
    }
}

