/*
 * Decompiled with CFR 0.152.
 */
package dev.entao.web.json;

import dev.entao.web.base.DateX;
import dev.entao.web.json.YsonConverter;
import dev.entao.web.json.YsonNum;
import dev.entao.web.json.YsonString;
import dev.entao.web.json.YsonValue;
import java.sql.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Ldev/entao/web/json/SQLDateYsonConverter;", "Ldev/entao/web/json/YsonConverter;", "()V", "fromYsonValue", "Ljava/sql/Date;", "yv", "Ldev/entao/web/json/YsonValue;", "toYsonValue", "v", "", "WebBasic"})
public final class SQLDateYsonConverter
implements YsonConverter {
    @NotNull
    public static final SQLDateYsonConverter INSTANCE = new SQLDateYsonConverter();

    private SQLDateYsonConverter() {
    }

    @Override
    @Nullable
    public Date fromYsonValue(@NotNull YsonValue yv) {
        Date date;
        Intrinsics.checkNotNullParameter((Object)yv, (String)"yv");
        YsonValue ysonValue = yv;
        if (ysonValue instanceof YsonString) {
            DateX dateX = DateX.Companion.parseDate(((YsonString)yv).getData());
            date = dateX != null ? dateX.getDateSQL() : null;
        } else {
            date = ysonValue instanceof YsonNum ? new Date(((YsonNum)yv).getData().longValue()) : null;
        }
        return date;
    }

    @Override
    @NotNull
    public YsonValue toYsonValue(@NotNull Object v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        String string = ((Date)v).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"v as Date).toString()");
        return new YsonString(string);
    }
}

