/*
 * Decompiled with CFR 0.152.
 */
package dev.entao.web.json;

import dev.entao.web.base.DateX;
import dev.entao.web.json.YsonConverter;
import dev.entao.web.json.YsonNum;
import dev.entao.web.json.YsonString;
import dev.entao.web.json.YsonValue;
import java.sql.Timestamp;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Ldev/entao/web/json/SQLTimestampYsonConverter;", "Ldev/entao/web/json/YsonConverter;", "()V", "fromYsonValue", "Ljava/sql/Timestamp;", "yv", "Ldev/entao/web/json/YsonValue;", "toYsonValue", "v", "", "WebBasic"})
public final class SQLTimestampYsonConverter
implements YsonConverter {
    @NotNull
    public static final SQLTimestampYsonConverter INSTANCE = new SQLTimestampYsonConverter();

    private SQLTimestampYsonConverter() {
    }

    @Override
    @Nullable
    public Timestamp fromYsonValue(@NotNull YsonValue yv) {
        Timestamp timestamp;
        Intrinsics.checkNotNullParameter((Object)yv, (String)"yv");
        YsonValue ysonValue = yv;
        if (ysonValue instanceof YsonString) {
            DateX dateX = DateX.Companion.parseTimestamp(((YsonString)yv).getData());
            timestamp = dateX != null ? dateX.getTimestamp() : null;
        } else {
            timestamp = ysonValue instanceof YsonNum ? new Timestamp(((YsonNum)yv).getData().longValue()) : null;
        }
        return timestamp;
    }

    @Override
    @NotNull
    public YsonValue toYsonValue(@NotNull Object v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        String string = ((Timestamp)v).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"v as Timestamp).toString()");
        return new YsonString(string);
    }
}

