/*
 * Decompiled with CFR 0.152.
 */
package dev.entao.web.json;

import dev.entao.web.json.YsonValue;
import java.sql.Blob;
import java.util.Arrays;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u0014\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Ldev/entao/web/json/YsonBlob;", "Ldev/entao/web/json/YsonValue;", "v", "Ljava/sql/Blob;", "(Ljava/sql/Blob;)V", "data", "", "([B)V", "getData", "()[B", "encoded", "", "getEncoded", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "", "preferBufferSize", "yson", "", "buf", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "Companion", "WebBasic"})
public final class YsonBlob
extends YsonValue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] data;

    public YsonBlob(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.data = data;
    }

    @NotNull
    public final byte[] getData() {
        return this.data;
    }

    public YsonBlob(@NotNull Blob v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        byte[] byArray = v.getBytes(1L, (int)v.length());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"v.getBytes(1, v.length().toInt())");
        this(byArray);
    }

    @Override
    public void yson(@NotNull StringBuilder buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        buf.append("\"");
        buf.append(this.getEncoded());
        buf.append("\"");
    }

    @NotNull
    public final String getEncoded() {
        return Companion.encode(this.data);
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof YsonBlob) {
            return Arrays.equals(((YsonBlob)other).data, this.data);
        }
        return false;
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    @Override
    public int preferBufferSize() {
        return this.data.length * 4 / 3 + 4;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004\u00a8\u0006\t"}, d2={"Ldev/entao/web/json/YsonBlob$Companion;", "", "()V", "decode", "", "s", "", "encode", "data", "WebBasic"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String encode(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            String string = Base64.getUrlEncoder().encodeToString(data);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrlEncoder().encodeToString(data)");
            return string;
        }

        @NotNull
        public final byte[] decode(@NotNull String s2) {
            Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
            byte[] byArray = Base64.getUrlDecoder().decode(s2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getUrlDecoder().decode(s)");
            return byArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

