/*
 * Decompiled with CFR 0.152.
 */
package dev.entao.web.json;

import dev.entao.web.json.YsonArray;
import dev.entao.web.json.YsonBool;
import dev.entao.web.json.YsonError;
import dev.entao.web.json.YsonNull;
import dev.entao.web.json.YsonNum;
import dev.entao.web.json.YsonObject;
import dev.entao.web.json.YsonParserKt;
import dev.entao.web.json.YsonString;
import dev.entao.web.json.YsonValue;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\bH\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000eJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020\u001aJ\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020\u001fJ\b\u0010(\u001a\u00020\u0018H\u0002J\u0010\u0010)\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\bH\u0002J\u0010\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u0003H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006,"}, d2={"Ldev/entao/web/json/YsonParser;", "", "text", "", "(Ljava/lang/String;)V", "current", "", "currentChar", "", "getCurrentChar", "()C", "data", "", "end", "", "getEnd", "()Z", "leftString", "getLeftString", "()Ljava/lang/String;", "getText", "isChar", "c", "next", "", "parse", "Ldev/entao/web/json/YsonValue;", "endParse", "parseArray", "Ldev/entao/web/json/YsonArray;", "parseFalse", "Ldev/entao/web/json/YsonBool;", "parseNull", "Ldev/entao/web/json/YsonNull;", "parseNumber", "parseObject", "Ldev/entao/web/json/YsonObject;", "parseString", "Ldev/entao/web/json/YsonString;", "parseTrue", "skipWhite", "tokenc", "tokens", "s", "WebBasic"})
public final class YsonParser {
    @NotNull
    private final String text;
    @NotNull
    private final char[] data;
    private int current;

    public YsonParser(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.text = text;
        char[] cArray = this.text.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        this.data = cArray;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    private final boolean getEnd() {
        return this.current >= this.data.length;
    }

    private final char getCurrentChar() {
        return this.data[this.current];
    }

    @NotNull
    public final String getLeftString() {
        if (this.current >= this.data.length) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int n = 0; n < 20 && this.current + n < this.data.length; ++n) {
            sb.append(this.data[this.current + n]);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public final YsonValue parse(boolean endParse) {
        YsonValue ysonValue;
        this.skipWhite();
        if (this.getEnd()) {
            throw new YsonError("\u7a7a\u7684\u5b57\u7b26\u4e32");
        }
        char ch = this.getCurrentChar();
        char c2 = ch;
        if (c2 == '{') {
            ysonValue = this.parseObject();
        } else if (c2 == '[') {
            ysonValue = this.parseArray();
        } else if (c2 == '\"') {
            ysonValue = this.parseString();
        } else if (c2 == 't') {
            ysonValue = this.parseTrue();
        } else if (c2 == 'f') {
            ysonValue = this.parseFalse();
        } else if (c2 == 'n') {
            ysonValue = this.parseNull();
        } else if (YsonParserKt.access$getNUM_START$p().contains(Character.valueOf(c2))) {
            ysonValue = this.parseNumber();
        } else {
            throw new YsonError("");
        }
        YsonValue v = ysonValue;
        this.skipWhite();
        if (endParse && !this.getEnd()) {
            throw new IllegalArgumentException("\u5e94\u8be5\u7ed3\u675f\u89e3\u6790:" + this.getLeftString());
        }
        return v;
    }

    @NotNull
    public final YsonArray parseArray() {
        this.skipWhite();
        this.tokenc('[');
        YsonArray ya = new YsonArray(null, 1, null);
        while (!this.getEnd()) {
            this.skipWhite();
            if (this.getCurrentChar() == ']') break;
            if (this.getCurrentChar() == ',') {
                this.next();
                continue;
            }
            YsonValue yv = this.parse(false);
            ya.getData().add(yv);
        }
        this.tokenc(']');
        return ya;
    }

    @NotNull
    public final YsonObject parseObject() {
        this.skipWhite();
        this.tokenc('{');
        YsonObject yo = new YsonObject(null, 1, null);
        while (!this.getEnd()) {
            this.skipWhite();
            if (this.getCurrentChar() == '}') break;
            if (this.getCurrentChar() == ',') {
                this.next();
                continue;
            }
            YsonString key = this.parseString();
            this.tokenc(':');
            YsonValue yv = this.parse(false);
            ((Map)yo.getData()).put(key.getData(), yv);
        }
        this.tokenc('}');
        return yo;
    }

    @NotNull
    public final YsonString parseString() {
        this.skipWhite();
        this.tokenc('\"');
        StringBuilder buf = new StringBuilder(64);
        boolean escing = false;
        while (!this.getEnd()) {
            char ch = this.getCurrentChar();
            if (!escing) {
                if (ch == '\"') break;
                this.next();
                if (ch == '\\') {
                    escing = true;
                    continue;
                }
                buf.append(ch);
                continue;
            }
            escing = false;
            this.next();
            char c2 = ch;
            if (((c2 == '\"' ? true : c2 == '\'') ? true : c2 == '\\') ? true : c2 == '/') {
                buf.append(ch);
                continue;
            }
            if (c2 == 'b') {
                buf.append('\b');
                continue;
            }
            if (c2 == 'f') {
                buf.append('\f');
                continue;
            }
            if (c2 == 'n') {
                buf.append('\n');
                continue;
            }
            if (c2 == 'r') {
                buf.append('\r');
                continue;
            }
            if (c2 == 't') {
                buf.append('\t');
                continue;
            }
            if (c2 == 'u') {
                if (this.current + 4 < this.text.length()) {
                    String string;
                    StringBuilder sb = new StringBuilder(4);
                    sb.append(this.text.charAt(this.current + 0));
                    sb.append(this.text.charAt(this.current + 1));
                    sb.append(this.text.charAt(this.current + 2));
                    sb.append(this.text.charAt(this.current + 3));
                    this.current += 4;
                    Intrinsics.checkNotNullExpressionValue((Object)sb.toString(), (String)"sb.toString()");
                    int n = 16;
                    int n2 = Integer.parseInt(string, CharsKt.checkRadix((int)n));
                    buf.append((char)n2);
                    continue;
                }
                throw new YsonError("\u671f\u671b\u662funicode\u5b57\u7b26");
            }
            buf.append(ch);
        }
        if (escing) {
            throw new YsonError("\u89e3\u6790\u9519\u8bef,\u8f6c\u4e49,");
        }
        this.tokenc('\"');
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buf.toString()");
        return new YsonString(string);
    }

    @NotNull
    public final YsonValue parseNumber() {
        this.skipWhite();
        StringBuilder buf = new StringBuilder(32);
        while (!this.getEnd()) {
            char c2 = this.getCurrentChar();
            if (!YsonParserKt.access$getNUMS$p().contains(Character.valueOf(c2))) break;
            buf.append(c2);
            this.next();
        }
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buf.toString()");
        String s2 = string;
        if (((CharSequence)s2).length() == 0) {
            throw new YsonError("\u975e\u6570\u5b57");
        }
        if (StringsKt.contains$default((CharSequence)s2, (char)'.', (boolean)false, (int)2, null)) {
            double d = Double.parseDouble(s2);
            return new YsonNum(d);
        }
        long n = Long.parseLong(s2);
        return new YsonNum(n);
    }

    @NotNull
    public final YsonBool parseTrue() {
        this.skipWhite();
        this.tokens("true");
        return YsonBool.Companion.getTrue();
    }

    @NotNull
    public final YsonBool parseFalse() {
        this.skipWhite();
        this.tokens("false");
        return YsonBool.Companion.getFalse();
    }

    @NotNull
    public final YsonNull parseNull() {
        this.skipWhite();
        this.tokens("null");
        return YsonNull.Companion.getInst();
    }

    private final void next() {
        ++this.current;
    }

    private final void skipWhite() {
        while (!this.getEnd()) {
            if (YsonParserKt.access$isWhite(this.getCurrentChar())) {
                this.next();
                continue;
            }
            return;
        }
    }

    private final boolean isChar(char c2) {
        return this.getCurrentChar() == c2;
    }

    private final void tokenc(char c2) {
        this.skipWhite();
        if (this.getCurrentChar() != c2) {
            throw new YsonError("\u671f\u671b\u662f\u5b57\u7b26" + c2, this.text, this.current);
        }
        this.next();
        this.skipWhite();
    }

    private final void tokens(String s2) {
        this.skipWhite();
        int n = s2.length();
        for (int i = 0; i < n; ++i) {
            char c2 = s2.charAt(i);
            if (this.getCurrentChar() != c2) {
                throw new YsonError("\u671f\u671b\u662f\u5b57\u7b26\u4e32" + s2, this.text, this.current);
            }
            this.next();
        }
        this.skipWhite();
    }
}

