/*
 * Decompiled with CFR 0.152.
 */
package dev.entao.web.log;

import dev.entao.web.base.IOUtilsKt;
import dev.entao.web.log.DirLogPrinter;
import dev.entao.web.log.LogItem;
import dev.entao.web.log.LogPrinter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000S\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0015\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u0018H\u0016J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000bH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001c\u001a\u00020\u000bH\u0002J\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0018H\u0016R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00050\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016\u00a8\u0006\""}, d2={"Ldev/entao/web/log/DirLogPrinter;", "Ldev/entao/web/log/LogPrinter;", "logdir", "Ljava/io/File;", "keepDays", "", "tagSeprateFile", "", "(Ljava/io/File;IZ)V", "installed", "keyDefault", "", "mapDay", "Ljava/util/HashMap;", "mapWriter", "Ljava/io/BufferedWriter;", "reg", "Lkotlin/text/Regex;", "timer", "Ljava/util/Timer;", "timerTask", "dev/entao/web/log/DirLogPrinter$timerTask$1", "Ldev/entao/web/log/DirLogPrinter$timerTask$1;", "deleteOldLogs", "", "flush", "install", "keyOfTag", "tag", "outOf", "printItem", "item", "Ldev/entao/web/log/LogItem;", "uninstall", "WebBasic"})
public final class DirLogPrinter
implements LogPrinter {
    @NotNull
    private final File logdir;
    private final int keepDays;
    private final boolean tagSeprateFile;
    @NotNull
    private final HashMap<String, BufferedWriter> mapWriter;
    @NotNull
    private final HashMap<String, Integer> mapDay;
    private boolean installed;
    @NotNull
    private final Regex reg;
    @NotNull
    private String keyDefault;
    @NotNull
    private final Timer timer;
    @NotNull
    private final timerTask.1 timerTask;

    public DirLogPrinter(@NotNull File logdir, int keepDays, boolean tagSeprateFile) {
        Intrinsics.checkNotNullParameter((Object)logdir, (String)"logdir");
        this.logdir = logdir;
        this.keepDays = keepDays;
        this.tagSeprateFile = tagSeprateFile;
        this.mapWriter = new HashMap();
        this.mapDay = new HashMap();
        this.reg = new Regex("\\d{4}-\\d{2}-\\d{2}.*\\.log");
        this.keyDefault = "XLOG";
        this.timer = new Timer("LogDirTimer", true);
        this.timerTask = new TimerTask(this){
            final /* synthetic */ DirLogPrinter this$0;
            {
                this.this$0 = $receiver;
            }

            public void run() {
                Map $this$forEach$iv = DirLogPrinter.access$getMapWriter$p(this.this$0);
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<K, V> element$iv;
                    Map.Entry<K, V> entry = element$iv = iterator.next();
                    boolean bl = false;
                    BufferedWriter u = (BufferedWriter)entry.getValue();
                    u.flush();
                }
            }
        };
        if (!this.logdir.exists()) {
            this.logdir.mkdirs();
        }
        this.timer.scheduleAtFixedRate((TimerTask)this.timerTask, 5000L, 5000L);
    }

    public /* synthetic */ DirLogPrinter(File file, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        this(file, n, bl);
    }

    @Override
    public synchronized void install() {
        this.installed = true;
    }

    @Override
    public synchronized void uninstall() {
        this.installed = false;
        HashMap m = new HashMap(this.mapWriter);
        this.mapWriter.clear();
        Iterator iterator = ((Map)m).entrySet().iterator();
        while (iterator.hasNext()) {
            BufferedWriter v = (BufferedWriter)iterator.next().getValue();
            v.flush();
            v.close();
        }
        m.clear();
    }

    @Override
    public synchronized void flush() {
        try {
            for (Map.Entry e : ((Map)this.mapWriter).entrySet()) {
                ((BufferedWriter)e.getValue()).flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final String keyOfTag(String tag) {
        return !this.tagSeprateFile || ((CharSequence)tag).length() == 0 ? this.keyDefault : tag;
    }

    private final synchronized BufferedWriter outOf(String tag) {
        BufferedWriter oldW;
        if (!this.installed) {
            return null;
        }
        String tagKey = this.keyOfTag(tag);
        int dayOfYear = Calendar.getInstance().get(6);
        Integer n = this.mapDay.get(tagKey);
        int n2 = dayOfYear;
        if (n != null && n == n2) {
            return this.mapWriter.get(tagKey);
        }
        BufferedWriter bufferedWriter = oldW = this.mapWriter.remove(tagKey);
        if (bufferedWriter != null) {
            bufferedWriter.flush();
        }
        BufferedWriter bufferedWriter2 = oldW;
        if (bufferedWriter2 != null) {
            bufferedWriter2.close();
        }
        this.deleteOldLogs();
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        String ds = fmt.format(new Date(System.currentTimeMillis()));
        String filename = this.tagSeprateFile ? ds + tagKey + ".log" : ds + ".log";
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File(this.logdir, filename), true), 16384);
            ((Map)this.mapWriter).put(tagKey, writer);
            Integer n3 = dayOfYear;
            ((Map)this.mapDay).put(tagKey, n3);
            return writer;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void deleteOldLogs() {
        void $this$sortedByDescending$iv;
        void $this$filterTo$iv$iv;
        File[] fs;
        if (this.keepDays <= 0) {
            return;
        }
        int n = this.keepDays;
        File[] fileArray = this.logdir.listFiles();
        if (fileArray == null) {
            return;
        }
        Object $this$filter$iv = fs = fileArray;
        boolean $i$f$filter = false;
        File[] fileArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n2 = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n2; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
            CharSequence charSequence = string;
            if (!this.reg.matches(charSequence)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        List ls2 = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a2, T b) {
                File it = (File)b;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (File)a2;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        if (ls2.size() > n + 1) {
            int n3 = ls2.size();
            for (int i = n + 1; i < n3; ++i) {
                ((File)ls2.get(i)).delete();
            }
        }
    }

    @Override
    public void printItem(@NotNull LogItem item) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            BufferedWriter bufferedWriter = this.outOf(item.getTag());
            if (bufferedWriter == null) {
                return;
            }
            BufferedWriter w = bufferedWriter;
            try {
                w.write(item.getLine());
                w.write("\n");
            }
            catch (IOException e) {
                IOUtilsKt.closeSafe(w);
                e.printStackTrace();
                BufferedWriter bufferedWriter2 = this.mapWriter.remove(this.keyOfTag(item.getTag()));
                if (bufferedWriter2 == null) break block3;
                IOUtilsKt.closeSafe(bufferedWriter2);
            }
        }
    }

    public static final /* synthetic */ HashMap access$getMapWriter$p(DirLogPrinter $this) {
        return $this.mapWriter;
    }
}

