/*
 * Decompiled with CFR 0.152.
 */
package dev.entao.web.log;

import dev.entao.web.log.LogLevel;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\b\u0010\u0018\u001a\u00020\u0005H\u0002J\t\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u001a"}, d2={"Ldev/entao/web/log/LogItem;", "", "level", "Ldev/entao/web/log/LogLevel;", "tag", "", "message", "(Ldev/entao/web/log/LogLevel;Ljava/lang/String;Ljava/lang/String;)V", "getLevel", "()Ldev/entao/web/log/LogLevel;", "line", "getLine", "()Ljava/lang/String;", "getMessage", "getTag", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "makeLine", "toString", "WebBasic"})
public final class LogItem {
    @NotNull
    private final LogLevel level;
    @NotNull
    private final String tag;
    @NotNull
    private final String message;
    @NotNull
    private final String line;

    public LogItem(@NotNull LogLevel level, @NotNull String tag, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.level = level;
        this.tag = tag;
        this.message = message;
        this.line = this.makeLine();
    }

    @NotNull
    public final LogLevel getLevel() {
        return this.level;
    }

    @NotNull
    public final String getTag() {
        return this.tag;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    @NotNull
    public final String getLine() {
        return this.line;
    }

    private final String makeLine() {
        StringBuilder sb = new StringBuilder(this.message.length() + 64);
        sb.append("TIM:");
        String date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.getDefault()).format(new Date(System.currentTimeMillis()));
        sb.append(date);
        sb.append(" TID:");
        Locale locale = Locale.getDefault();
        String string = "%6d";
        Object[] objectArray = new Object[]{Thread.currentThread().getId()};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
        sb.append(string2);
        sb.append(" LVL:");
        sb.append(StringsKt.first((CharSequence)this.level.name()));
        sb.append(" TAG:");
        sb.append(this.tag);
        sb.append(" MSG:");
        sb.append(this.message);
        String string3 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"sb.toString()");
        return string3;
    }

    @NotNull
    public final LogLevel component1() {
        return this.level;
    }

    @NotNull
    public final String component2() {
        return this.tag;
    }

    @NotNull
    public final String component3() {
        return this.message;
    }

    @NotNull
    public final LogItem copy(@NotNull LogLevel level, @NotNull String tag, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return new LogItem(level, tag, message);
    }

    public static /* synthetic */ LogItem copy$default(LogItem logItem, LogLevel logLevel, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            logLevel = logItem.level;
        }
        if ((n & 2) != 0) {
            string = logItem.tag;
        }
        if ((n & 4) != 0) {
            string2 = logItem.message;
        }
        return logItem.copy(logLevel, string, string2);
    }

    @NotNull
    public String toString() {
        return "LogItem(level=" + this.level + ", tag=" + this.tag + ", message=" + this.message + ")";
    }

    public int hashCode() {
        int result = this.level.hashCode();
        result = result * 31 + this.tag.hashCode();
        result = result * 31 + this.message.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LogItem)) {
            return false;
        }
        LogItem logItem = (LogItem)other;
        if (this.level != logItem.level) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tag, (Object)logItem.tag)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.message, (Object)logItem.message);
    }
}

