/*
 * Decompiled with CFR 0.152.
 */
package dev.entao.web.log;

import dev.entao.web.log.LogItem;
import dev.entao.web.log.LogPrinter;
import java.util.ArrayList;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001J\u0006\u0010\n\u001a\u00020\bJ\b\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001J\b\u0010\u0011\u001a\u00020\bH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/entao/web/log/LogTree;", "Ldev/entao/web/log/LogPrinter;", "ps", "", "([Ldev/entao/web/log/LogPrinter;)V", "list", "Ljava/util/ArrayList;", "add", "", "p", "clear", "flush", "install", "printItem", "item", "Ldev/entao/web/log/LogItem;", "remove", "uninstall", "WebBasic"})
public final class LogTree
implements LogPrinter {
    @NotNull
    private final ArrayList<LogPrinter> list;

    public LogTree(LogPrinter ... ps) {
        Intrinsics.checkNotNullParameter((Object)ps, (String)"ps");
        this.list = CollectionsKt.arrayListOf((Object[])Arrays.copyOf(ps, ps.length));
    }

    @Override
    public void printItem(@NotNull LogItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        for (LogPrinter p : this.list) {
            p.printItem(item);
        }
    }

    public final void clear() {
        for (LogPrinter p : this.list) {
            p.flush();
            p.uninstall();
        }
        this.list.clear();
    }

    public final void add(@NotNull LogPrinter p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        p.install();
        this.list.add(p);
    }

    public final void remove(@NotNull LogPrinter p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        this.list.remove(p);
        p.uninstall();
    }

    @Override
    public void flush() {
        for (LogPrinter p : this.list) {
            p.flush();
        }
    }

    @Override
    public void uninstall() {
        for (LogPrinter p : this.list) {
            p.uninstall();
        }
    }

    @Override
    public void install() {
        for (LogPrinter p : this.list) {
            p.install();
        }
    }
}

