/*
 * Decompiled with CFR 0.152.
 */
package dev.entao.web.log;

import dev.entao.web.log.AnyToStringKt;
import dev.entao.web.log.ConsoleLogPrinter;
import dev.entao.web.log.LogItem;
import dev.entao.web.log.LogLevel;
import dev.entao.web.log.LogPrinter;
import dev.entao.web.log.LogTree;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0012J#\u0010\u0016\u001a\u00020\u00122\u0016\u0010\u0017\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0018\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0019J+\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00042\u0016\u0010\u0017\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0018\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u001cJ#\u0010\u001d\u001a\u00020\u00122\u0016\u0010\u0017\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0018\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0019J+\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00042\u0016\u0010\u0017\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0018\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u001cJ#\u0010\u001f\u001a\u00020\u00122\u0016\u0010\u0017\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0018\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0019J+\u0010 \u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00042\u0016\u0010\u0017\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0018\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u001cJ\u0006\u0010!\u001a\u00020\u0012J#\u0010\"\u001a\u00020\u00122\u0016\u0010\u0017\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0018\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0019J+\u0010#\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00042\u0016\u0010\u0017\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0018\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u001cJ\u000e\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020&J3\u0010$\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001b\u001a\u00020\u00042\u0016\u0010\u0017\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0018\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010)J\u000e\u0010*\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010+\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J#\u0010,\u001a\u00020\u00122\u0016\u0010\u0017\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0018\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0019J+\u0010-\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00042\u0016\u0010\u0017\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0018\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u001cR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Ldev/entao/web/log/LogX;", "", "()V", "TAG", "", "getTAG", "()Ljava/lang/String;", "setTAG", "(Ljava/lang/String;)V", "enabled", "", "getEnabled", "()Z", "setEnabled", "(Z)V", "printer", "Ldev/entao/web/log/LogTree;", "addPrinter", "", "p", "Ldev/entao/web/log/LogPrinter;", "clearPrinter", "d", "args", "", "([Ljava/lang/Object;)V", "dx", "tag", "(Ljava/lang/String;[Ljava/lang/Object;)V", "e", "ex", "fatal", "fatalX", "flush", "i", "ix", "printItem", "item", "Ldev/entao/web/log/LogItem;", "level", "Ldev/entao/web/log/LogLevel;", "(Ldev/entao/web/log/LogLevel;Ljava/lang/String;[Ljava/lang/Object;)V", "removePrinter", "setPrinter", "w", "wx", "WebBasic"})
public final class LogX {
    @NotNull
    public static final LogX INSTANCE = new LogX();
    @NotNull
    private static final LogTree printer;
    private static boolean enabled;
    @NotNull
    private static String TAG;

    private LogX() {
    }

    public final boolean getEnabled() {
        return enabled;
    }

    public final void setEnabled(boolean bl) {
        enabled = bl;
    }

    @NotNull
    public final String getTAG() {
        return TAG;
    }

    public final void setTAG(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        TAG = string;
    }

    public final void setPrinter(@NotNull LogPrinter p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        printer.clear();
        this.addPrinter(p);
    }

    public final synchronized void addPrinter(@NotNull LogPrinter p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        printer.add(p);
    }

    public final synchronized void clearPrinter() {
        printer.clear();
    }

    public final synchronized void removePrinter(@NotNull LogPrinter p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        printer.remove(p);
    }

    public final synchronized void flush() {
        printer.flush();
    }

    public final synchronized void printItem(@NotNull LogItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (enabled) {
            printer.printItem(item);
        }
    }

    public final void printItem(@NotNull LogLevel level, @NotNull String tag, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.printItem(new LogItem(level, tag, AnyToStringKt.anyArrayToString(args)));
    }

    public final void d(Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.printItem(new LogItem(LogLevel.DEBUG, TAG, AnyToStringKt.anyArrayToString(args)));
    }

    public final void w(Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.printItem(new LogItem(LogLevel.WARN, TAG, AnyToStringKt.anyArrayToString(args)));
    }

    public final void e(Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.printItem(new LogItem(LogLevel.ERROR, TAG, AnyToStringKt.anyArrayToString(args)));
        this.flush();
    }

    public final void i(Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.printItem(new LogItem(LogLevel.INFO, TAG, AnyToStringKt.anyArrayToString(args)));
    }

    public final void fatal(Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.printItem(new LogItem(LogLevel.FATAIL, TAG, AnyToStringKt.anyArrayToString(args)));
        this.flush();
        throw new RuntimeException("fatal error!");
    }

    public final void dx(@NotNull String tag, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.printItem(new LogItem(LogLevel.DEBUG, tag, AnyToStringKt.anyArrayToString(args)));
    }

    public final void wx(@NotNull String tag, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.printItem(new LogItem(LogLevel.WARN, tag, AnyToStringKt.anyArrayToString(args)));
    }

    public final void ex(@NotNull String tag, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.printItem(new LogItem(LogLevel.ERROR, tag, AnyToStringKt.anyArrayToString(args)));
        this.flush();
    }

    public final void ix(@NotNull String tag, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.printItem(new LogItem(LogLevel.INFO, tag, AnyToStringKt.anyArrayToString(args)));
    }

    public final void fatalX(@NotNull String tag, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.printItem(new LogItem(LogLevel.FATAIL, tag, AnyToStringKt.anyArrayToString(args)));
        this.flush();
        throw new RuntimeException("fatal error!");
    }

    static {
        LogPrinter[] logPrinterArray = new LogPrinter[]{new ConsoleLogPrinter()};
        printer = new LogTree(logPrinterArray);
        enabled = true;
        TAG = "xlog";
    }
}

